/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.StreamUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.ReportdConfigurationDao;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.web.servlet.MissingParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DownloadReportController
extends AbstractController {
    private static Logger LOG = LoggerFactory.getLogger(DownloadReportController.class);
    private ReportStoreService m_reportStoreService;
    private ReportdConfigurationDao m_reportdConfigurationDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] requiredParameters;
        String fileName = request.getParameter("fileName");
        this.m_reportdConfigurationDao = (ReportdConfigurationDao)BeanUtils.getBean((String)"reportdContext", (String)"reportdConfigDao", ReportdConfigurationDao.class);
        File storageDirectory = new File(this.m_reportdConfigurationDao.getStorageDirectory());
        if (fileName != null) {
            File requestedFile = new File(fileName);
            if (!requestedFile.getParentFile().getCanonicalFile().equals(storageDirectory.getCanonicalFile())) {
                LOG.warn("User attempted to retrieve file {} but was restricted to {}", (Object)requestedFile, (Object)storageDirectory);
                throw new IllegalArgumentException("Cannot retrieve reports from outside Reportd storage directory");
            }
            if (fileName.toLowerCase().endsWith(".pdf")) {
                response.setContentType("application/pdf;charset=UTF-8");
            }
            if (fileName.toLowerCase().endsWith(".csv")) {
                response.setContentType("text/csv;charset=UTF-8");
            }
            response.setHeader("Content-disposition", "inline; filename=" + fileName);
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "cache");
            response.setHeader("Cache-Control", "must-revalidate");
            StreamUtils.streamToStream((InputStream)new FileInputStream(new File(fileName)), (OutputStream)response.getOutputStream());
            return null;
        }
        for (String requiredParameter : requiredParameters = new String[]{"locatorId", "format"}) {
            if (request.getParameter(requiredParameter) != null) continue;
            throw new MissingParameterException(requiredParameter, requiredParameters);
        }
        try {
            Integer reportCatalogEntryId = WebSecurityUtils.safeParseInt((String)request.getParameter("locatorId"));
            String requestFormat = new String(request.getParameter("format"));
            if (ReportFormat.PDF == ReportFormat.valueOf((String)requestFormat) || ReportFormat.SVG == ReportFormat.valueOf((String)requestFormat)) {
                response.setContentType("application/pdf;charset=UTF-8");
                response.setHeader("Content-disposition", "inline; filename=" + reportCatalogEntryId.toString() + ".pdf");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "cache");
                response.setHeader("Cache-Control", "must-revalidate");
            }
            if (ReportFormat.CSV == ReportFormat.valueOf((String)requestFormat)) {
                response.setContentType("text/csv;charset=UTF-8");
                response.setHeader("Content-disposition", "inline; filename=" + reportCatalogEntryId.toString() + ".csv");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "cache");
                response.setHeader("Cache-Control", "must-revalidate");
            }
            this.m_reportStoreService.render(reportCatalogEntryId, ReportFormat.valueOf((String)requestFormat), (OutputStream)response.getOutputStream());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public void setReportStoreService(ReportStoreService reportStoreService) {
        this.m_reportStoreService = reportStoreService;
    }
}

