/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.asset;

import au.com.bytecode.opencsv.CSVReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.api.Util;
import org.opennms.web.asset.Asset;
import org.opennms.web.asset.AssetModel;
import org.opennms.web.servlet.MissingParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAssetsServlet
extends HttpServlet {
    private static final long serialVersionUID = 8282814214167099107L;
    private Logger logger = LoggerFactory.getLogger((String)ImportAssetsServlet.class.getName());
    private List<String> errors = new ArrayList<String>();
    protected String redirectSuccess;
    protected AssetModel model;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new UnavailableException("Require a redirect.success init parameter.");
        }
        this.model = new AssetModel();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String assetsText = request.getParameter("assetsText");
        if (assetsText == null) {
            this.logger.error("assetsText was null");
            throw new MissingParameterException("assetsText");
        }
        try {
            List<Asset> assets = this.decodeAssetsText(assetsText);
            List<Integer> nodesWithAssets = this.getCurrentAssetNodesList();
            for (Asset asset : assets) {
                asset.setUserLastModified(request.getRemoteUser());
                asset.setLastModifiedDate(new Date());
                if (nodesWithAssets.contains(asset.getNodeId())) {
                    this.logger.debug("modifyAsset call for asset:'{}'", (Object)asset);
                    this.model.modifyAsset(asset);
                    continue;
                }
                this.logger.debug("createAsset:'{}'", (Object)asset);
                this.model.createAsset(asset);
            }
            StringBuilder messageText = new StringBuilder();
            messageText.append("Successfully imported ").append(assets.size()).append(" asset");
            if (assets.size() > 1) {
                messageText.append("s");
            }
            messageText.append(".");
            if (this.errors.size() > 0) {
                messageText.append("  ").append(this.errors.size()).append(" non-fatal errors occurred:");
                for (String error : this.errors) {
                    messageText.append("<br />").append(error);
                }
            }
            request.getSession().setAttribute("message", (Object)messageText.toString());
            response.sendRedirect(response.encodeRedirectURL(this.redirectSuccess + "&showMessage=true"));
        }
        catch (AssetException e) {
            String message = "Error importing assets: " + e.getMessage();
            this.redirectWithErrorMessage(request, response, e, message);
        }
        catch (SQLException e) {
            String message = "Database exception importing assets: " + e.getMessage();
            this.redirectWithErrorMessage(request, response, e, message);
        }
    }

    private void redirectWithErrorMessage(HttpServletRequest request, HttpServletResponse response, Exception e, String message) throws IOException, UnsupportedEncodingException {
        this.log(message, e);
        request.getSession().setAttribute("message", (Object)message);
        response.sendRedirect(response.encodeRedirectURL("import.jsp?showMessage=true"));
    }

    public List<Asset> decodeAssetsText(String text) throws AssetException {
        CSVReader csvReader = null;
        StringReader stringReader = null;
        ArrayList<Asset> list = new ArrayList<Asset>();
        text = text.trim();
        int count = 0;
        try {
            String[] line;
            stringReader = new StringReader(text);
            csvReader = new CSVReader((Reader)stringReader);
            while ((line = csvReader.readNext()) != null) {
                ++count;
                try {
                    this.logger.debug("asset line is:'{}'", (Object)line);
                    if (line.length <= 37) {
                        this.logger.error("csv test row length was not at least 37 line length: '{}' line was:'{}', line length", (Object)line.length, (Object)line);
                        throw new NoSuchElementException();
                    }
                    if (line[0].equals("Node Label")) {
                        this.logger.debug("line was header. line:'{}'", (Object)line);
                        continue;
                    }
                    Asset asset = new Asset();
                    asset.setNodeId(WebSecurityUtils.safeParseInt((String)line[1]));
                    asset.setCategory(Util.decode((String)line[2]));
                    asset.setManufacturer(Util.decode((String)line[3]));
                    asset.setVendor(Util.decode((String)line[4]));
                    asset.setModelNumber(Util.decode((String)line[5]));
                    asset.setSerialNumber(Util.decode((String)line[6]));
                    asset.setDescription(Util.decode((String)line[7]));
                    asset.setCircuitId(Util.decode((String)line[8]));
                    asset.setAssetNumber(Util.decode((String)line[9]));
                    asset.setOperatingSystem(Util.decode((String)line[10]));
                    asset.setRack(Util.decode((String)line[11]));
                    asset.setSlot(Util.decode((String)line[12]));
                    asset.setPort(Util.decode((String)line[13]));
                    asset.setRegion(Util.decode((String)line[14]));
                    asset.setDivision(Util.decode((String)line[15]));
                    asset.setDepartment(Util.decode((String)line[16]));
                    asset.setAddress1(Util.decode((String)line[17]));
                    asset.setAddress2(Util.decode((String)line[18]));
                    asset.setCity(Util.decode((String)line[19]));
                    asset.setState(Util.decode((String)line[20]));
                    asset.setZip(Util.decode((String)line[21]));
                    asset.setBuilding(Util.decode((String)line[22]));
                    asset.setFloor(Util.decode((String)line[23]));
                    asset.setRoom(Util.decode((String)line[24]));
                    asset.setVendorPhone(Util.decode((String)line[25]));
                    asset.setVendorFax(Util.decode((String)line[26]));
                    asset.setDateInstalled(Util.decode((String)line[27]));
                    asset.setLease(Util.decode((String)line[28]));
                    asset.setLeaseExpires(Util.decode((String)line[29]));
                    asset.setSupportPhone(Util.decode((String)line[30]));
                    asset.setMaintContract(Util.decode((String)line[31]));
                    asset.setVendorAssetNumber(Util.decode((String)line[32]));
                    asset.setMaintContractExpires(Util.decode((String)line[33]));
                    asset.setDisplayCategory(Util.decode((String)line[34]));
                    asset.setNotifyCategory(Util.decode((String)line[35]));
                    asset.setPollerCategory(Util.decode((String)line[36]));
                    if (line.length > 37) {
                        asset.setThresholdCategory(Util.decode((String)line[37]));
                        asset.setUsername(Util.decode((String)line[38]));
                        asset.setPassword(Util.decode((String)line[39]));
                        asset.setEnable(Util.decode((String)line[40]));
                        asset.setConnection(Util.decode((String)line[41]));
                        asset.setAutoenable(Util.decode((String)line[42]));
                        asset.setComments(Util.decode((String)line[43]));
                    }
                    if (line.length > 44) {
                        asset.setCpu(Util.decode((String)line[44]));
                        asset.setRam(Util.decode((String)line[45]));
                        asset.setStoragectrl(Util.decode((String)line[46]));
                        asset.setHdd1(Util.decode((String)line[47]));
                        asset.setHdd2(Util.decode((String)line[48]));
                        asset.setHdd3(Util.decode((String)line[49]));
                        asset.setHdd4(Util.decode((String)line[50]));
                        asset.setHdd5(Util.decode((String)line[51]));
                        asset.setHdd6(Util.decode((String)line[52]));
                        asset.setNumpowersupplies(Util.decode((String)line[53]));
                        asset.setInputpower(Util.decode((String)line[54]));
                        asset.setAdditionalhardware(Util.decode((String)line[55]));
                        asset.setAdmin(Util.decode((String)line[56]));
                        asset.setSnmpcommunity(Util.decode((String)line[57]));
                        asset.setRackunitheight(Util.decode((String)line[58]));
                    }
                    if (line.length > 59) {
                        asset.setCountry(Util.decode((String)line[59]));
                        asset.setLongitude(Util.decode((String)line[60]));
                        asset.setLatitude(Util.decode((String)line[61]));
                    }
                    list.add(asset);
                    this.logger.debug("decoded asset:'{}'", (Object)asset);
                }
                catch (NoSuchElementException e) {
                    this.errors.add("Ignoring malformed import for entry " + count + ", not enough values.");
                }
                catch (NumberFormatException e) {
                    this.logger.error("NodeId parsing to int faild, ignoreing malformed import for entry number '{}' exception message:'{}'", (Object)count, (Object)e.getMessage());
                    this.errors.add("Ignoring malformed import for entry " + count + ", node id not a number.");
                }
            }
        }
        catch (IOException e) {
            try {
                this.logger.error("An error occurred reading the CSV input. Message:'{}'", (Object)e.getMessage());
                throw new AssetException("An error occurred reading the CSV input.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stringReader);
                IOUtils.closeQuietly(csvReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)stringReader);
        IOUtils.closeQuietly((Closeable)csvReader);
        if (list.size() == 0) {
            this.logger.error("No asset information was found, list size was 0");
            throw new AssetException("No asset information was found.");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getCurrentAssetNodesList() throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery("SELECT NODEID FROM ASSETS");
            d.watch((Object)rs);
            while (rs.next()) {
                list.add(rs.getInt("NODEID"));
            }
        }
        finally {
            d.cleanUp();
        }
        return list;
    }

    private static class AssetException
    extends Exception {
        private static final long serialVersionUID = 2498335935646001342L;

        public AssetException(String message) {
            super(message);
        }

        public AssetException(String message, Throwable t) {
            super(message, t);
        }
    }
}

