/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.servlet.MissingParameterException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class AcknowledgeAlarmController
extends AbstractController
implements InitializingBean {
    private AlarmRepository m_webAlarmRepository;
    private String m_redirectView;

    public void setRedirectView(String redirectView) {
        this.m_redirectView = redirectView;
    }

    public void setAlarmRepository(AlarmRepository webAlarmRepository) {
        this.m_webAlarmRepository = webAlarmRepository;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_redirectView, (String)"redirectView must be set");
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] alarmIdStrings = request.getParameterValues("alarm");
        String action = request.getParameter("actionCode");
        if (alarmIdStrings == null) {
            throw new MissingParameterException("alarm", new String[]{"alarm", "actionCode"});
        }
        if (action == null) {
            throw new MissingParameterException("actionCode", new String[]{"alarm", "actionCode"});
        }
        int[] alarmIds = new int[alarmIdStrings.length];
        for (int i = 0; i < alarmIds.length; ++i) {
            alarmIds[i] = WebSecurityUtils.safeParseInt((String)alarmIdStrings[i]);
        }
        if (action.equals(AcknowledgeType.ACKNOWLEDGED.getShortName())) {
            this.m_webAlarmRepository.acknowledgeAlarms(alarmIds, request.getRemoteUser(), new Date());
        } else if (action.equals(AcknowledgeType.UNACKNOWLEDGED.getShortName())) {
            this.m_webAlarmRepository.unacknowledgeAlarms(alarmIds, request.getRemoteUser());
        } else {
            throw new ServletException("Unknown acknowledge action: " + action);
        }
        String redirectParms = request.getParameter("redirectParms");
        String redirect = request.getParameter("redirect");
        String viewName = redirect != null ? redirect : (redirectParms == null || redirectParms == "" || redirectParms == "null" ? this.m_redirectView : this.m_redirectView + "?" + redirectParms);
        RedirectView view = new RedirectView(viewName, true);
        return new ModelAndView((View)view);
    }
}

