/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.alarm.AlarmUtil;
import org.opennms.web.alarm.filter.AfterFirstEventTimeFilter;
import org.opennms.web.alarm.filter.AfterLastEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeFirstEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeLastEventTimeFilter;
import org.opennms.web.alarm.filter.IPAddrLikeFilter;
import org.opennms.web.alarm.filter.LocationFilter;
import org.opennms.web.alarm.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.alarm.filter.LogMessageSubstringFilter;
import org.opennms.web.alarm.filter.NodeLocationFilter;
import org.opennms.web.alarm.filter.NodeNameLikeFilter;
import org.opennms.web.alarm.filter.ServiceFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.api.Util;
import org.opennms.web.filter.Filter;
import org.opennms.web.servlet.MissingParameterException;

public class AlarmQueryServlet
extends HttpServlet {
    private static final long serialVersionUID = 9140535159580534211L;
    protected static String[] IGNORE_LIST = new String[]{"msgsub", "msgmatchany", "nodenamelike", "service", "iplike", "severity", "relativetime", "usebeforetime", "beforehour", "beforeminute", "beforeampm", "beforedate", "beforemonth", "beforeyear", "useaftertime", "afterhour", "afterminute", "afterampm", "afterdate", "aftermonth", "afteryear"};
    protected String redirectUrl = "filter";

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        if (config.getInitParameter("redirect.url") != null) {
            this.redirectUrl = config.getInitParameter("redirect.url");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodelocation;
        String location;
        String useAfterFirstEventTime;
        String useBeforeFirstEventTime;
        String useAfterLastEventTime;
        String useBeforeLastEventTime;
        String relativeTime;
        String severity;
        String ipLikePattern;
        String service;
        String nodeNameLike;
        String msgMatchAny;
        ArrayList<Filter> filterArray = new ArrayList<Filter>();
        String msgSubstring = WebSecurityUtils.sanitizeString((String)request.getParameter("msgsub"));
        if (msgSubstring != null && msgSubstring.length() > 0) {
            filterArray.add(new LogMessageSubstringFilter(msgSubstring));
        }
        if ((msgMatchAny = WebSecurityUtils.sanitizeString((String)request.getParameter("msgmatchany"))) != null && msgMatchAny.length() > 0) {
            filterArray.add(new LogMessageMatchesAnyFilter(msgMatchAny));
        }
        if ((nodeNameLike = WebSecurityUtils.sanitizeString((String)request.getParameter("nodenamelike"))) != null && nodeNameLike.length() > 0) {
            filterArray.add(new NodeNameLikeFilter(nodeNameLike));
        }
        if ((service = request.getParameter("service")) != null && !service.equals("Any")) {
            filterArray.add(new ServiceFilter(WebSecurityUtils.safeParseInt((String)service), this.getServletContext()));
        }
        if ((ipLikePattern = WebSecurityUtils.sanitizeString((String)request.getParameter("iplike"))) != null && !ipLikePattern.equals("")) {
            filterArray.add(new IPAddrLikeFilter(ipLikePattern));
        }
        if ((severity = request.getParameter("severity")) != null && !severity.equalsIgnoreCase("Any")) {
            filterArray.add(new SeverityFilter(OnmsSeverity.get((int)WebSecurityUtils.safeParseInt((String)severity))));
        }
        if ((relativeTime = request.getParameter("relativetime")) != null && !relativeTime.equalsIgnoreCase("Any")) {
            try {
                filterArray.add(AlarmUtil.getRelativeTimeFilter(WebSecurityUtils.safeParseInt((String)relativeTime)));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal relativetime value", e);
            }
        }
        if ((useBeforeLastEventTime = WebSecurityUtils.sanitizeString((String)request.getParameter("usebeforelasteventtime"))) != null && useBeforeLastEventTime.equals("1")) {
            try {
                filterArray.add(this.getBeforeLastEventTimeFilter(request));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal before last event time value", e);
            }
            catch (MissingParameterException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((useAfterLastEventTime = WebSecurityUtils.sanitizeString((String)request.getParameter("useafterlasteventtime"))) != null && useAfterLastEventTime.equals("1")) {
            try {
                filterArray.add(this.getAfterLastEventTimeFilter(request));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal after last event time value", e);
            }
            catch (MissingParameterException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((useBeforeFirstEventTime = WebSecurityUtils.sanitizeString((String)request.getParameter("usebeforefirsteventtime"))) != null && useBeforeFirstEventTime.equals("1")) {
            try {
                filterArray.add(this.getBeforeFirstEventTimeFilter(request));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal before first event time value", e);
            }
            catch (MissingParameterException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((useAfterFirstEventTime = WebSecurityUtils.sanitizeString((String)request.getParameter("useafterfirsteventtime"))) != null && useAfterFirstEventTime.equals("1")) {
            try {
                filterArray.add(this.getAfterFirstEventTimeFilter(request));
            }
            catch (IllegalArgumentException e) {
                this.log("Illegal after first event time value", e);
            }
            catch (MissingParameterException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((location = WebSecurityUtils.sanitizeString((String)request.getParameter("location"))) != null && !location.equalsIgnoreCase("any")) {
            filterArray.add(new LocationFilter(WebSecurityUtils.sanitizeString((String)location)));
        }
        if ((nodelocation = WebSecurityUtils.sanitizeString((String)request.getParameter("nodelocation"))) != null && !nodelocation.equalsIgnoreCase("any")) {
            filterArray.add(new NodeLocationFilter(WebSecurityUtils.sanitizeString((String)nodelocation)));
        }
        String queryString = "";
        if (filterArray.size() > 0) {
            String[] filterStrings = new String[filterArray.size()];
            for (int i = 0; i < filterStrings.length; ++i) {
                Filter filter = (Filter)filterArray.get(i);
                filterStrings[i] = AlarmUtil.getFilterString(filter);
            }
            HashMap<String, String[]> paramAdditions = new HashMap<String, String[]>();
            paramAdditions.put("filter", filterStrings);
            queryString = Util.makeQueryString((HttpServletRequest)request, paramAdditions, (String[])IGNORE_LIST);
        } else {
            queryString = Util.makeQueryString((HttpServletRequest)request, (String[])IGNORE_LIST);
        }
        response.sendRedirect(this.redirectUrl + "?" + queryString);
    }

    protected BeforeFirstEventTimeFilter getBeforeFirstEventTimeFilter(HttpServletRequest request) {
        Date beforeFirstEventDate = this.getDateFromRequest(request, "beforefirsteventtime");
        return new BeforeFirstEventTimeFilter(beforeFirstEventDate);
    }

    protected AfterFirstEventTimeFilter getAfterFirstEventTimeFilter(HttpServletRequest request) {
        Date afterFirstEventDate = this.getDateFromRequest(request, "afterfirsteventtime");
        return new AfterFirstEventTimeFilter(afterFirstEventDate);
    }

    protected BeforeLastEventTimeFilter getBeforeLastEventTimeFilter(HttpServletRequest request) {
        Date beforeLastEventDate = this.getDateFromRequest(request, "beforelasteventtime");
        return new BeforeLastEventTimeFilter(beforeLastEventDate);
    }

    protected AfterLastEventTimeFilter getAfterLastEventTimeFilter(HttpServletRequest request) {
        Date afterLastEventDate = this.getDateFromRequest(request, "afterlasteventtime");
        return new AfterLastEventTimeFilter(afterLastEventDate);
    }

    protected Date getDateFromRequest(HttpServletRequest request, String prefix) throws MissingParameterException {
        if (request == null || prefix == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setLenient(true);
        String hourString = request.getParameter(prefix + "hour");
        if (hourString == null) {
            throw new MissingParameterException(prefix + "hour", this.getRequiredDateFields(prefix));
        }
        cal.set(10, WebSecurityUtils.safeParseInt((String)hourString));
        String minuteString = request.getParameter(prefix + "minute");
        if (minuteString == null) {
            throw new MissingParameterException(prefix + "minute", this.getRequiredDateFields(prefix));
        }
        cal.set(12, WebSecurityUtils.safeParseInt((String)minuteString));
        String amPmString = request.getParameter(prefix + "ampm");
        if (amPmString == null) {
            throw new MissingParameterException(prefix + "ampm", this.getRequiredDateFields(prefix));
        }
        if (amPmString.equalsIgnoreCase("am")) {
            cal.set(9, 0);
        } else if (amPmString.equalsIgnoreCase("pm")) {
            cal.set(9, 1);
        } else {
            throw new IllegalArgumentException("Illegal AM/PM value: " + amPmString);
        }
        String monthString = request.getParameter(prefix + "month");
        if (monthString == null) {
            throw new MissingParameterException(prefix + "month", this.getRequiredDateFields(prefix));
        }
        cal.set(2, WebSecurityUtils.safeParseInt((String)monthString));
        String dateString = request.getParameter(prefix + "date");
        if (dateString == null) {
            throw new MissingParameterException(prefix + "date", this.getRequiredDateFields(prefix));
        }
        cal.set(5, WebSecurityUtils.safeParseInt((String)dateString));
        String yearString = request.getParameter(prefix + "year");
        if (yearString == null) {
            throw new MissingParameterException(prefix + "year", this.getRequiredDateFields(prefix));
        }
        cal.set(1, WebSecurityUtils.safeParseInt((String)yearString));
        return cal.getTime();
    }

    protected String[] getRequiredDateFields(String prefix) {
        return new String[]{prefix + "hour", prefix + "minute", prefix + "ampm", prefix + "date", prefix + "month", prefix + "year"};
    }
}

