/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class Service {
    private int m_id;
    private int m_nodeId;
    private String m_ipAddr;
    private int m_serviceId;
    private String m_serviceName;
    private String m_lastGood;
    private String m_lastFail;
    private String m_notify;
    private char m_status;

    Service(OnmsMonitoredService monSvc) {
        this.setId(monSvc.getId());
        this.setNodeId(monSvc.getNodeId());
        this.setIpAddress(InetAddressUtils.str((InetAddress)monSvc.getIpAddress()));
        this.setServiceId(monSvc.getServiceId());
        this.setServiceName(monSvc.getServiceName());
        if (monSvc.getLastGood() != null) {
            this.setLastGood(StringUtils.toStringEfficiently((Date)monSvc.getLastGood()));
        }
        if (monSvc.getLastFail() != null) {
            this.setLastFail(StringUtils.toStringEfficiently((Date)monSvc.getLastFail()));
        }
        this.setNotify(monSvc.getNotify());
        if (monSvc.getStatus() != null) {
            this.setStatus(monSvc.getStatus().charAt(0));
        }
    }

    public int getId() {
        return this.m_id;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getIpAddress() {
        return this.m_ipAddr;
    }

    public int getServiceId() {
        return this.m_serviceId;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getLastGood() {
        return this.m_lastGood;
    }

    public String getLastFail() {
        return this.m_lastFail;
    }

    public String getNotify() {
        return this.m_notify;
    }

    public char getStatus() {
        return this.m_status;
    }

    public boolean isManaged() {
        return this.getStatus() == 'A';
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.getNodeId() + "\n");
        str.append("Ipaddr = " + this.getIpAddress() + "\n");
        str.append("Service id = " + this.getServiceId() + "\n");
        str.append("Service name = " + this.getServiceName() + "\n");
        str.append("Last Good = " + this.getLastGood() + "\n");
        str.append("Last Fail  = " + this.getLastFail() + "\n");
        str.append("Status = " + this.getStatus() + "\n");
        return str.toString();
    }

    void setId(int id) {
        this.m_id = id;
    }

    void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    void setIpAddress(String ipAddr) {
        this.m_ipAddr = ipAddr;
    }

    void setServiceId(int serviceId) {
        this.m_serviceId = serviceId;
    }

    void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    void setLastGood(String lastGood) {
        this.m_lastGood = lastGood;
    }

    void setLastFail(String lastFail) {
        this.m_lastFail = lastFail;
    }

    void setNotify(String notify) {
        this.m_notify = notify;
    }

    void setStatus(char status) {
        this.m_status = status;
    }
}

