/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.distributed;

import javax.servlet.http.HttpServletRequest;
import org.opennms.web.svclayer.DistributedPollerService;
import org.opennms.web.svclayer.model.LocationMonitorIdCommand;
import org.opennms.web.svclayer.model.LocationMonitorListModel;
import org.opennms.web.validator.LocationMonitorIdValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/distributed/locationMonitorDetails.htm"})
public class LocationMonitorDetailsController {
    @Autowired
    private DistributedPollerService m_distributedPollerService;
    @Autowired
    private LocationMonitorIdValidator m_validator;
    private static final String SUCCESS_VIEW = "distributed/locationMonitorDetails";
    private static final String ERROR_VIEW = "distributed/error";

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView handle(HttpServletRequest request, @ModelAttribute(value="command") LocationMonitorIdCommand cmd, BindingResult errors) {
        this.m_validator.validate(cmd, (Errors)errors);
        LocationMonitorListModel model = null;
        if (!errors.hasErrors()) {
            model = this.m_distributedPollerService.getLocationMonitorDetails(cmd, errors);
        }
        if (errors.hasErrors()) {
            return new ModelAndView(ERROR_VIEW);
        }
        ModelAndView modelAndView = new ModelAndView(SUCCESS_VIEW, "model", (Object)model);
        if (request.isUserInRole("ROLE_ADMIN")) {
            modelAndView.addObject("isAdmin", (Object)"true");
        }
        return modelAndView;
    }
}

