/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.api.Util;
import org.opennms.web.graph.KscResultSet;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.api.KscReportService;
import org.opennms.web.svclayer.api.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class CustomViewController
extends AbstractController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CustomViewController.class);
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;
    private ResourceService m_resourceService;
    private int m_defaultGraphsPerLine = 0;
    private Executor m_executor;
    private Set<String> m_resourcesPendingPromotion = Collections.synchronizedSet(new HashSet());

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List graphCollection;
        String overrideGraphType;
        String overrideTimespan;
        String[] requiredParameters = new String[]{"report", "type"};
        int reportId = -1;
        String reportType = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.type.toString()));
        String reportIdString = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.report.toString()));
        if (reportType == null) {
            throw new MissingParameterException(Parameters.type.toString(), requiredParameters);
        }
        if (reportIdString == null) {
            throw new MissingParameterException(Parameters.report.toString(), requiredParameters);
        }
        if (reportType.equals("node") || reportType.equals("custom")) {
            reportId = WebSecurityUtils.safeParseInt((String)reportIdString);
        }
        if ("null".equals(overrideTimespan = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.timespan.toString()))) || "none".equals(overrideTimespan)) {
            overrideTimespan = null;
        }
        if ("null".equals(overrideGraphType = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graphtype.toString()))) || "none".equals(overrideGraphType)) {
            overrideGraphType = null;
        }
        Report report = null;
        if ("node".equals(reportType)) {
            LOG.debug("handleRequestInternal: buildNodeReport(reportId) {}", (Object)reportId);
            report = this.getKscReportService().buildNodeReport(reportId);
        } else if ("nodeSource".equals(reportType)) {
            LOG.debug("handleRequestInternal: buildNodeSourceReport(nodeSource) {}", (Object)reportIdString);
            report = this.getKscReportService().buildNodeSourceReport(reportIdString);
        } else if ("domain".equals(reportType)) {
            LOG.debug("handleRequestInternal: buildDomainReport(reportIdString) {}", (Object)reportIdString);
            report = this.getKscReportService().buildDomainReport(reportIdString);
        } else if ("custom".equals(reportType)) {
            LOG.debug("handleRequestInternal: getReportByIndex(reportId) {}", (Object)reportId);
            report = this.m_kscReportFactory.getReportByIndex(reportId);
            if (report == null) {
                throw new ServletException("Report could not be found in config file for index '" + reportId + "'");
            }
        } else {
            throw new IllegalArgumentException("value to 'type' parameter of '" + reportType + "' is not supported.  Must be one of: node, nodeSource, domain, or custom");
        }
        HashMap<String, OnmsResource> resourceMap = new HashMap<String, OnmsResource>();
        TreeSet<PrefabGraph> prefabGraphs = new TreeSet<PrefabGraph>();
        if (this.removeBrokenGraphsFromReport(report) && reportId > -1) {
            this.m_kscReportFactory.setReport(reportId, report);
            this.m_kscReportFactory.saveCurrent();
            EventBuilder eb = new EventBuilder("uei.opennms.org/internal/kscReportUpdated", "Web UI");
            eb.addParam("reportTitle", report.getTitle() == null ? "Report #" + report.getId() : report.getTitle());
            eb.addParam("graphCount", report.getGraphCount());
            try {
                Util.createEventProxy().send(eb.getEvent());
            }
            catch (Throwable e) {
                LOG.error("Can't send event " + eb.getEvent(), e);
            }
        }
        if (!(graphCollection = report.getGraphCollection()).isEmpty()) {
            for (Graph graph : graphCollection) {
                OnmsResource resource = this.getKscReportService().getResourceFromGraph(graph);
                resourceMap.put(graph.toString(), resource);
                if (resource == null) {
                    LOG.debug("Could not get resource for graph {} in report {}", (Object)graph, (Object)report.getTitle());
                    continue;
                }
                prefabGraphs.addAll(Arrays.asList(this.getResourceService().findPrefabGraphsForResource(resource)));
            }
        }
        ArrayList<KscResultSet> resultSets = new ArrayList<KscResultSet>(report.getGraphCount());
        for (Graph graph : graphCollection) {
            PrefabGraph displayGraph;
            OnmsResource resource = (OnmsResource)resourceMap.get(graph.toString());
            if (resource != null) {
                this.promoteResourceAttributesIfNecessary(resource);
            }
            String displayGraphType = overrideGraphType == null ? graph.getGraphtype() : overrideGraphType;
            try {
                displayGraph = this.getResourceService().getPrefabGraph(displayGraphType);
            }
            catch (ObjectRetrievalFailureException e) {
                LOG.debug("The prefabricated graph '{}' does not exist: {}", new Object[]{displayGraphType, e, e});
                displayGraph = null;
            }
            boolean foundGraph = false;
            if (resource != null) {
                for (PrefabGraph availableGraph : this.getResourceService().findPrefabGraphsForResource(resource)) {
                    if (!availableGraph.equals(displayGraph)) continue;
                    foundGraph = true;
                    break;
                }
            }
            if (!foundGraph) {
                displayGraph = null;
            }
            String displayTimespan = null;
            displayTimespan = overrideTimespan == null ? graph.getTimespan() : overrideTimespan;
            Calendar beginTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            KSC_PerformanceReportFactory.getBeginEndTime((String)displayTimespan, (Calendar)beginTime, (Calendar)endTime);
            KscResultSet resultSet = new KscResultSet(graph.getTitle(), beginTime.getTime(), endTime.getTime(), resource, displayGraph);
            resultSets.add(resultSet);
        }
        ModelAndView modelAndView = new ModelAndView("KSC/customView");
        modelAndView.addObject("loggedIn", (Object)(request.getRemoteUser() != null ? 1 : 0));
        modelAndView.addObject("reportType", (Object)reportType);
        if (report != null) {
            modelAndView.addObject("report", (Object)reportIdString);
        }
        modelAndView.addObject("title", (Object)report.getTitle());
        modelAndView.addObject("resultSets", resultSets);
        if (report.getShowTimespanButton().booleanValue()) {
            if (overrideTimespan == null || !this.getKscReportService().getTimeSpans(true).containsKey(overrideTimespan)) {
                modelAndView.addObject("timeSpan", (Object)"none");
            } else {
                modelAndView.addObject("timeSpan", (Object)overrideTimespan);
            }
            modelAndView.addObject("timeSpans", (Object)this.getKscReportService().getTimeSpans(true));
        } else {
            modelAndView.addObject("timeSpan", null);
        }
        if (report.getShowGraphtypeButton().booleanValue()) {
            LinkedHashMap<String, String> graphTypes = new LinkedHashMap<String, String>();
            graphTypes.put("none", "none");
            for (PrefabGraph graphOption : prefabGraphs) {
                graphTypes.put(graphOption.getName(), graphOption.getName());
            }
            if (overrideGraphType == null || !graphTypes.containsKey(overrideGraphType)) {
                modelAndView.addObject("graphType", (Object)"none");
            } else {
                modelAndView.addObject("graphType", (Object)overrideGraphType);
            }
            modelAndView.addObject("graphTypes", graphTypes);
        } else {
            modelAndView.addObject("graphType", null);
        }
        modelAndView.addObject("showCustomizeButton", (Object)((request.isUserInRole("ROLE_ADMIN") || !request.isUserInRole("ROLE_READONLY")) && request.getRemoteUser() != null ? 1 : 0));
        if (report.getGraphsPerLine() > 0) {
            modelAndView.addObject("graphsPerLine", (Object)report.getGraphsPerLine());
        } else {
            modelAndView.addObject("graphsPerLine", (Object)this.getDefaultGraphsPerLine());
        }
        return modelAndView;
    }

    private boolean removeBrokenGraphsFromReport(Report report) {
        Iterator itr = report.getGraphCollection().iterator();
        while (itr.hasNext()) {
            Graph graph = (Graph)itr.next();
            try {
                OnmsResource r = this.getKscReportService().getResourceFromGraph(graph);
                if (r != null) continue;
                LOG.error("Removing graph '{}' in KSC report '{}' because the resource it refers to could not be found. Perhaps resource '{}' (or its ancestor) referenced by this graph no longer exists?", new Object[]{graph.getTitle(), report.getTitle(), graph.getResourceId()});
                itr.remove();
                return true;
            }
            catch (ObjectRetrievalFailureException orfe) {
                LOG.error("Removing graph '{}' in KSC report '{}' because the resource it refers to could not be found. Perhaps resource '{}' (or its ancestor) referenced by this graph no longer exists?", new Object[]{graph.getTitle(), report.getTitle(), graph.getResourceId()});
                itr.remove();
                return true;
            }
            catch (Throwable e) {
                LOG.error("Unexpected error while scanning through graphs in report: {}", (Object)e.getMessage(), (Object)e);
                itr.remove();
                return true;
            }
        }
        return false;
    }

    private void promoteResourceAttributesIfNecessary(final OnmsResource resource) {
        boolean needToSchedule = false;
        if (resource != null && resource.getId() != null) {
            needToSchedule = this.m_resourcesPendingPromotion.add(resource.getId());
        }
        if (needToSchedule) {
            this.m_executor.execute(new Runnable(){

                @Override
                public void run() {
                    CustomViewController.this.getResourceService().promoteGraphAttributesForResource(resource);
                    CustomViewController.this.m_resourcesPendingPromotion.remove(resource.getId());
                }
            });
        }
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public int getDefaultGraphsPerLine() {
        return this.m_defaultGraphsPerLine;
    }

    public void setDefaultGraphsPerLine(int defaultGraphsPerLine) {
        Assert.isTrue((defaultGraphsPerLine > 0 ? 1 : 0) != 0, (String)"property defaultGraphsPerLine must be greater than zero");
        this.m_defaultGraphsPerLine = defaultGraphsPerLine;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
        Assert.state((this.m_defaultGraphsPerLine != 0 ? 1 : 0) != 0, (String)"property defaultGraphsPerLine must be set");
        this.m_executor = Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory(((Object)((Object)this)).getClass().getSimpleName(), 1));
    }

    public static enum Parameters {
        report,
        type,
        timespan,
        graphtype;

    }
}

