/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsElementDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OspfElementDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.web.api.Util;
import org.opennms.web.enlinkd.BridgeElementNode;
import org.opennms.web.enlinkd.BridgeLinkNode;
import org.opennms.web.enlinkd.BridgeLinkRemoteNode;
import org.opennms.web.enlinkd.BridgeLinkSharedHost;
import org.opennms.web.enlinkd.CdpElementNode;
import org.opennms.web.enlinkd.CdpLinkNode;
import org.opennms.web.enlinkd.EnLinkdElementFactoryInterface;
import org.opennms.web.enlinkd.IsisElementNode;
import org.opennms.web.enlinkd.IsisLinkNode;
import org.opennms.web.enlinkd.LldpElementNode;
import org.opennms.web.enlinkd.LldpLinkNode;
import org.opennms.web.enlinkd.NodeLinkBridge;
import org.opennms.web.enlinkd.OspfElementNode;
import org.opennms.web.enlinkd.OspfLinkNode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class EnLinkdElementFactory
implements InitializingBean,
EnLinkdElementFactoryInterface {
    @Autowired
    private OspfElementDao m_ospfElementDao;
    @Autowired
    private OspfLinkDao m_ospfLinkDao;
    @Autowired
    private LldpElementDao m_lldpElementDao;
    @Autowired
    private LldpLinkDao m_lldpLinkDao;
    @Autowired
    private CdpElementDao m_cdpElementDao;
    @Autowired
    private CdpLinkDao m_cdpLinkDao;
    @Autowired
    private BridgeElementDao m_bridgeElementDao;
    @Autowired
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    @Autowired
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    @Autowired
    private BridgeTopologyDao m_bridgetopologyDao;
    @Autowired
    private IpNetToMediaDao m_ipNetToMediaDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private IsIsElementDao m_isisElementDao;
    @Autowired
    private IsIsLinkDao m_isisLinkDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public static EnLinkdElementFactoryInterface getInstance(ServletContext servletContext) {
        return EnLinkdElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static EnLinkdElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (EnLinkdElementFactoryInterface)appContext.getBean(EnLinkdElementFactoryInterface.class);
    }

    @Override
    public OspfElementNode getOspfElement(int nodeId) {
        return this.convertFromModel(this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private OspfElementNode convertFromModel(OspfElement ospf) {
        if (ospf == null) {
            return null;
        }
        OspfElementNode ospfNode = new OspfElementNode();
        ospfNode.setOspfRouterId(InetAddressUtils.str((InetAddress)ospf.getOspfRouterId()));
        ospfNode.setOspfVersionNumber(ospf.getOspfVersionNumber());
        ospfNode.setOspfAdminStat(OspfElement.Status.getTypeString((Integer)ospf.getOspfAdminStat().getValue()));
        ospfNode.setOspfCreateTime(Util.formatDateToUIString((Date)ospf.getOspfNodeCreateTime()));
        ospfNode.setOspfLastPollTime(Util.formatDateToUIString((Date)ospf.getOspfNodeLastPollTime()));
        return ospfNode;
    }

    @Override
    public List<OspfLinkNode> getOspfLinks(int nodeId) {
        ArrayList<OspfLinkNode> nodelinks = new ArrayList<OspfLinkNode>();
        for (OspfLink link : this.m_ospfLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.addAll(this.convertFromModel(nodeId, link));
        }
        return nodelinks;
    }

    @Transactional
    private List<OspfLinkNode> convertFromModel(int nodeid, OspfLink link) {
        ArrayList<OspfLinkNode> linkNodes = new ArrayList<OspfLinkNode>();
        List ospfElements = this.m_ospfElementDao.findAllByRouterId(link.getOspfRemRouterId());
        if (ospfElements.size() > 0) {
            for (OspfElement ospfElement : ospfElements) {
                OspfLinkNode linknode = new OspfLinkNode();
                linknode.setOspfIpAddr(InetAddressUtils.str((InetAddress)link.getOspfIpAddr()));
                linknode.setOspfAddressLessIndex(link.getOspfAddressLessIndex());
                linknode.setOspfIfIndex(link.getOspfIfIndex());
                linknode.setOspfRemRouterId(this.getRemRouterIdString(InetAddressUtils.str((InetAddress)link.getOspfRemRouterId()), ospfElement.getNode().getLabel()));
                linknode.setOspfRemRouterUrl(this.getNodeUrl(ospfElement.getNode().getId()));
                linknode.setOspfRemIpAddr(InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr()));
                linknode.setOspfRemAddressLessIndex(link.getOspfRemAddressLessIndex());
                if (ospfElement != null && linknode.getOspfRemIpAddr() != null) {
                    linknode.setOspfRemPortUrl(this.getIpInterfaceUrl(ospfElement.getNode().getId(), linknode.getOspfRemIpAddr()));
                }
                linknode.setOspfLinkCreateTime(Util.formatDateToUIString((Date)link.getOspfLinkCreateTime()));
                linknode.setOspfLinkLastPollTime(Util.formatDateToUIString((Date)link.getOspfLinkLastPollTime()));
                linkNodes.add(linknode);
            }
        } else {
            OspfLinkNode linknode = new OspfLinkNode();
            linknode.setOspfIpAddr(InetAddressUtils.str((InetAddress)link.getOspfIpAddr()));
            linknode.setOspfAddressLessIndex(link.getOspfAddressLessIndex());
            linknode.setOspfIfIndex(link.getOspfIfIndex());
            linknode.setOspfRemRouterId(InetAddressUtils.str((InetAddress)link.getOspfRemRouterId()));
            linknode.setOspfRemIpAddr(InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr()));
            linknode.setOspfRemAddressLessIndex(link.getOspfRemAddressLessIndex());
            linknode.setOspfLinkCreateTime(Util.formatDateToUIString((Date)link.getOspfLinkCreateTime()));
            linknode.setOspfLinkLastPollTime(Util.formatDateToUIString((Date)link.getOspfLinkLastPollTime()));
            linkNodes.add(linknode);
        }
        Collections.sort(linkNodes);
        return linkNodes;
    }

    @Override
    public CdpElementNode getCdpElement(int nodeId) {
        return this.convertFromModel(this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private CdpElementNode convertFromModel(CdpElement cdp) {
        if (cdp == null) {
            return null;
        }
        CdpElementNode cdpNode = new CdpElementNode();
        cdpNode.setCdpGlobalRun(OspfElement.TruthValue.getTypeString((Integer)cdp.getCdpGlobalRun().getValue()));
        cdpNode.setCdpGlobalDeviceId(cdp.getCdpGlobalDeviceId());
        if (cdp.getCdpGlobalDeviceIdFormat() != null) {
            cdpNode.setCdpGlobalDeviceIdFormat(CdpElement.CdpGlobalDeviceIdFormat.getTypeString((Integer)cdp.getCdpGlobalDeviceIdFormat().getValue()));
        } else {
            cdpNode.setCdpGlobalDeviceIdFormat("&nbsp");
        }
        cdpNode.setCdpCreateTime(Util.formatDateToUIString((Date)cdp.getCdpNodeCreateTime()));
        cdpNode.setCdpLastPollTime(Util.formatDateToUIString((Date)cdp.getCdpNodeLastPollTime()));
        return cdpNode;
    }

    @Override
    public List<CdpLinkNode> getCdpLinks(int nodeId) {
        ArrayList<CdpLinkNode> nodelinks = new ArrayList<CdpLinkNode>();
        for (CdpLink link : this.m_cdpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    @Transactional
    private CdpLinkNode convertFromModel(int nodeid, CdpLink link) {
        CdpLinkNode linknode = new CdpLinkNode();
        linknode.setCdpLocalPort(this.getPortString(link.getCdpCacheIfIndex(), link.getCdpInterfaceName(), null));
        if (link.getCdpCacheIfIndex() != null) {
            linknode.setCdpLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getCdpCacheIfIndex()));
        }
        linknode.setCdpCacheAddressType(CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()));
        linknode.setCdpCacheAddress(link.getCdpCacheAddress());
        linknode.setCdpCacheDeviceId(link.getCdpCacheDeviceId());
        linknode.setCdpCacheDevicePlatform(link.getCdpCacheDevicePlatform());
        linknode.setCdpCacheVersion(link.getCdpCacheVersion());
        linknode.setCdpCacheDevicePort(link.getCdpCacheDevicePort());
        CdpElement cdpCacheElement = this.m_cdpElementDao.findByGlobalDeviceId(link.getCdpCacheDeviceId());
        if (cdpCacheElement != null) {
            linknode.setCdpCacheDeviceUrl(this.getNodeUrl(cdpCacheElement.getNode().getId()));
            OnmsSnmpInterface cdpcachesnmp = this.getFromCdpCacheDevicePort(cdpCacheElement.getNode().getId(), link.getCdpCacheDevicePort());
            if (cdpcachesnmp != null) {
                linknode.setCdpCacheDevicePort(this.getPortString(cdpcachesnmp.getIfIndex(), link.getCdpCacheDevicePort(), cdpcachesnmp.getIfAlias()));
                linknode.setCdpCacheDevicePortUrl(this.getSnmpInterfaceUrl(cdpCacheElement.getNode().getId(), cdpcachesnmp.getIfIndex()));
            }
        }
        linknode.setCdpCreateTime(Util.formatDateToUIString((Date)link.getCdpLinkCreateTime()));
        linknode.setCdpLastPollTime(Util.formatDateToUIString((Date)link.getCdpLinkLastPollTime()));
        return linknode;
    }

    @Override
    public LldpElementNode getLldpElement(int nodeId) {
        return this.convertFromModel(this.m_lldpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private LldpElementNode convertFromModel(LldpElement lldp) {
        if (lldp == null) {
            return null;
        }
        LldpElementNode lldpNode = new LldpElementNode();
        lldpNode.setLldpChassisIdString(this.getChassisIdString(lldp.getLldpChassisId(), lldp.getLldpChassisIdSubType()));
        lldpNode.setLldpSysName(lldp.getLldpSysname());
        lldpNode.setLldpCreateTime(Util.formatDateToUIString((Date)lldp.getLldpNodeCreateTime()));
        lldpNode.setLldpLastPollTime(Util.formatDateToUIString((Date)lldp.getLldpNodeLastPollTime()));
        return lldpNode;
    }

    @Override
    public List<LldpLinkNode> getLldpLinks(int nodeId) {
        ArrayList<LldpLinkNode> nodelinks = new ArrayList<LldpLinkNode>();
        for (LldpLink link : this.m_lldpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    @Transactional
    private LldpLinkNode convertFromModel(int nodeid, LldpLink link) {
        LldpLinkNode linknode = new LldpLinkNode();
        linknode.setLldpPortString(this.getPortString(link.getLldpPortId(), link.getLldpPortIdSubType()));
        linknode.setLldpPortDescr(link.getLldpPortDescr());
        linknode.setLldpPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getLldpPortIfindex()));
        linknode.setLldpRemSysName(link.getLldpRemSysname());
        linknode.setLldpRemPortString(this.getPortString(link.getLldpRemPortId(), link.getLldpRemPortIdSubType()));
        linknode.setLldpRemPortDescr(link.getLldpRemPortDescr());
        linknode.setLldpCreateTime(Util.formatDateToUIString((Date)link.getLldpLinkCreateTime()));
        linknode.setLldpLastPollTime(Util.formatDateToUIString((Date)link.getLldpLinkLastPollTime()));
        OnmsNode remNode = null;
        List lldpremelements = this.m_lldpElementDao.findByChassisId(link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType());
        if (lldpremelements.size() == 1) {
            remNode = ((LldpElement)lldpremelements.get(0)).getNode();
        } else {
            if (lldpremelements.size() > 1) {
                linknode.setLldpRemChassisIdString(this.getChassisIdString("Found " + lldpremelements.size() + " nodes for", link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType()));
                return linknode;
            }
            Criteria criteria = new Criteria(OnmsNode.class).addRestriction((Restriction)new EqRestriction("sysName", (Object)link.getLldpRemSysname()));
            List nodes = this.m_nodeDao.findMatching(criteria);
            if (nodes.size() == 1) {
                remNode = (OnmsNode)nodes.get(0);
            }
        }
        if (remNode != null) {
            linknode.setLldpRemChassisIdString(this.getChassisIdString(remNode.getLabel(), link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType()));
            linknode.setLldpRemChassisIdUrl(this.getNodeUrl(remNode.getId()));
            if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
                try {
                    Integer remIfIndex = Integer.getInteger(link.getLldpRemPortId());
                    linknode.setLldpRemPortUrl(this.getSnmpInterfaceUrl((int)remNode.getId(), remIfIndex));
                }
                catch (Exception exception) {}
            }
        } else {
            linknode.setLldpRemChassisIdString(this.getChassisIdString(link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType()));
        }
        return linknode;
    }

    @Override
    public IsisElementNode getIsisElement(int nodeId) {
        return this.convertFromModel(this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private IsisElementNode convertFromModel(IsIsElement isis) {
        if (isis == null) {
            return null;
        }
        IsisElementNode isisNode = new IsisElementNode();
        isisNode.setIsisSysID(isis.getIsisSysID());
        isisNode.setIsisSysAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)isis.getIsisSysAdminState().getValue()));
        isisNode.setIsisCreateTime(Util.formatDateToUIString((Date)isis.getIsisNodeCreateTime()));
        isisNode.setIsisLastPollTime(Util.formatDateToUIString((Date)isis.getIsisNodeLastPollTime()));
        return isisNode;
    }

    @Override
    public List<IsisLinkNode> getIsisLinks(int nodeId) {
        ArrayList<IsisLinkNode> nodelinks = new ArrayList<IsisLinkNode>();
        for (IsIsLink link : this.m_isisLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    @Transactional
    private IsisLinkNode convertFromModel(int nodeid, IsIsLink link) {
        IsIsLink adjLink;
        IsisLinkNode linknode = new IsisLinkNode();
        linknode.setIsisCircIfIndex(link.getIsisCircIfIndex());
        linknode.setIsisCircAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)link.getIsisCircAdminState().getValue()));
        IsIsElement isiselement = this.m_isisElementDao.findByIsIsSysId(link.getIsisISAdjNeighSysID());
        if (isiselement != null) {
            linknode.setIsisISAdjNeighSysID(this.getAdjSysIDString(link.getIsisISAdjNeighSysID(), isiselement.getNode().getLabel()));
            linknode.setIsisISAdjUrl(this.getNodeUrl(isiselement.getNode().getId()));
        } else {
            linknode.setIsisISAdjNeighSysID(link.getIsisISAdjNeighSysID());
        }
        linknode.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)link.getIsisISAdjNeighSysType().getValue()));
        linknode.setIsisISAdjNeighSNPAAddress(link.getIsisISAdjNeighSNPAAddress());
        linknode.setIsisISAdjState(IsIsLink.IsisISAdjState.get((Integer)link.getIsisISAdjState().getValue()).toString());
        linknode.setIsisISAdjNbrExtendedCircID(link.getIsisISAdjNbrExtendedCircID());
        OnmsSnmpInterface remiface = null;
        if (isiselement != null && (adjLink = this.m_isisLinkDao.get(isiselement.getNode().getId(), link.getIsisISAdjIndex(), link.getIsisCircIndex())) != null) {
            remiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(isiselement.getNode().getId(), adjLink.getIsisCircIfIndex());
        }
        if (remiface == null) {
            remiface = this.getFromPhysAddress(link.getIsisISAdjNeighSNPAAddress());
        }
        if (remiface != null) {
            linknode.setIsisISAdjNeighPort(this.getPortString(remiface.getIfIndex(), remiface.getIfName(), remiface.getIfAlias()));
            linknode.setIsisISAdjUrl(this.getSnmpInterfaceUrl(remiface.getNode().getId(), remiface.getIfIndex()));
        } else {
            linknode.setIsisISAdjNeighPort("(Isis IS Adj Index: " + link.getIsisISAdjIndex() + ")");
        }
        linknode.setIsisLinkCreateTime(Util.formatDateToUIString((Date)link.getIsisLinkCreateTime()));
        linknode.setIsisLinkLastPollTime(Util.formatDateToUIString((Date)link.getIsisLinkLastPollTime()));
        return linknode;
    }

    @Override
    public List<BridgeElementNode> getBridgeElements(int nodeId) {
        ArrayList<BridgeElementNode> nodes = new ArrayList<BridgeElementNode>();
        for (BridgeElement bridge : this.m_bridgeElementDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodes.add(this.convertFromModel(bridge));
        }
        return nodes;
    }

    private BridgeElementNode convertFromModel(BridgeElement bridge) {
        if (bridge == null) {
            return null;
        }
        BridgeElementNode bridgeNode = new BridgeElementNode();
        bridgeNode.setBaseBridgeAddress(bridge.getBaseBridgeAddress());
        bridgeNode.setBaseNumPorts(bridge.getBaseNumPorts());
        bridgeNode.setBaseType(BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)bridge.getBaseType().getValue()));
        bridgeNode.setVlan(bridge.getVlan());
        bridgeNode.setVlanname(bridge.getVlanname());
        if (bridge.getStpProtocolSpecification() != null) {
            bridgeNode.setStpProtocolSpecification(BridgeElement.BridgeDot1dStpProtocolSpecification.getTypeString((Integer)bridge.getStpProtocolSpecification().getValue()));
        }
        bridgeNode.setStpPriority(bridge.getStpPriority());
        bridgeNode.setStpDesignatedRoot(bridge.getStpDesignatedRoot());
        bridgeNode.setStpRootCost(bridge.getStpRootCost());
        bridgeNode.setStpRootPort(bridge.getStpRootPort());
        bridgeNode.setBridgeNodeCreateTime(Util.formatDateToUIString((Date)bridge.getBridgeNodeCreateTime()));
        bridgeNode.setBridgeNodeLastPollTime(Util.formatDateToUIString((Date)bridge.getBridgeNodeLastPollTime()));
        return bridgeNode;
    }

    @Override
    public Collection<NodeLinkBridge> getNodeLinks(int nodeId) {
        HashMap mactoIpMap = new HashMap();
        for (OnmsIpInterface ip : this.m_ipInterfaceDao.findByNodeId(Integer.valueOf(nodeId))) {
            for (IpNetToMedia ipnetomedia : this.m_ipNetToMediaDao.findByNetAddress(ip.getIpAddress())) {
                if (!mactoIpMap.containsKey(ipnetomedia.getPhysAddress())) {
                    mactoIpMap.put(ipnetomedia.getPhysAddress(), new HashSet());
                }
                ((Set)mactoIpMap.get(ipnetomedia.getPhysAddress())).add(ip.getIpAddress());
            }
        }
        ArrayList<NodeLinkBridge> nodelinks = new ArrayList<NodeLinkBridge>();
        for (String mac : mactoIpMap.keySet()) {
            SharedSegment segment = this.m_bridgetopologyDao.getHostNodeSharedSegment(this.m_bridgeBridgeLinkDao, this.m_bridgeMacLinkDao, mac);
            if (segment.isEmpty() || !segment.containsMac(mac)) continue;
            nodelinks.add(this.convertFromModel(mac, segment, this.getNodePortString((Set)mactoIpMap.get(mac), mac)));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    @Transactional
    private NodeLinkBridge convertFromModel(String mac, SharedSegment segment, String port) {
        Object remlinknode;
        NodeLinkBridge linknode = new NodeLinkBridge();
        linknode.setNodeLocalPort(port);
        for (Object link : segment.getBridgePortsOnSegment()) {
            OnmsSnmpInterface remiface;
            BridgeLinkRemoteNode remlinknode2 = new BridgeLinkRemoteNode();
            Integer rempnodeId = link.getNode().getId();
            Integer rembridgePortIfIndex = link.getBridgePortIfIndex();
            remlinknode2.setBridgeRemoteNode(link.getNode().getLabel());
            remlinknode2.setBridgeRemoteUrl(this.getNodeUrl(rempnodeId));
            OnmsSnmpInterface onmsSnmpInterface = remiface = rembridgePortIfIndex == null ? null : this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(rempnodeId, rembridgePortIfIndex);
            if (remiface != null) {
                remlinknode2.setBridgeRemotePort(this.getPortString(rembridgePortIfIndex, remiface.getIfName(), remiface.getIfAlias()));
            } else {
                remlinknode2.setBridgeRemotePort(this.getPortString(rembridgePortIfIndex, null, null));
            }
            remlinknode2.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(rempnodeId, rembridgePortIfIndex));
            remlinknode2.setBridgeRemoteVlan(link.getVlan());
            linknode.getBridgeLinkRemoteNodes().add(remlinknode2);
        }
        for (Object link : segment.getBridgeMacLinks()) {
            if (!link.getMacAddress().equals(mac)) continue;
            linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkCreateTime()));
            linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkLastPollTime()));
            break;
        }
        HashMap sharedmacs = new HashMap();
        for (String shredmac : segment.getMacsOnSegment()) {
            if (shredmac.equals(mac)) continue;
            sharedmacs.put(shredmac, new ArrayList());
            ((List)sharedmacs.get(shredmac)).addAll(this.m_ipNetToMediaDao.findByPhysAddress(shredmac));
        }
        HashMap sharedhosts = new HashMap();
        for (String shredmac : sharedmacs.keySet()) {
            if (((List)sharedmacs.get(shredmac)).isEmpty()) {
                remlinknode = new BridgeLinkSharedHost();
                OnmsSnmpInterface snmp = this.getFromPhysAddress(shredmac);
                if (snmp == null) {
                    ((BridgeLinkSharedHost)remlinknode).setSharedHost(shredmac + " No ip address found");
                } else {
                    ((BridgeLinkSharedHost)remlinknode).setSharedHost(snmp.getNode().getLabel());
                    ((BridgeLinkSharedHost)remlinknode).setSharedHostUrl(this.getNodeUrl(snmp.getNode().getId()));
                    ((BridgeLinkSharedHost)remlinknode).setSharedHostPort(this.getPortString(snmp.getIfIndex(), snmp.getIfName(), snmp.getIfAlias()));
                    ((BridgeLinkSharedHost)remlinknode).setSharedHostPortUrl(this.getSnmpInterfaceUrl(snmp.getNode().getId(), snmp.getIfIndex()));
                }
                linknode.getBridgeLinkSharedHost().add((BridgeLinkSharedHost)remlinknode);
                continue;
            }
            sharedhosts.put(shredmac, new ArrayList());
            for (IpNetToMedia ipnettomedia : (List)sharedmacs.get(shredmac)) {
                ((List)sharedhosts.get(shredmac)).addAll(this.m_ipInterfaceDao.findByIpAddress(ipnettomedia.getNetAddress().getHostAddress()));
            }
        }
        for (String shredmac : sharedhosts.keySet()) {
            remlinknode = new BridgeLinkSharedHost();
            HashSet<InetAddress> ips = new HashSet<InetAddress>();
            if (((List)sharedhosts.get(shredmac)).isEmpty()) {
                for (IpNetToMedia ipnettomedia : (List)sharedmacs.get(shredmac)) {
                    ips.add(ipnettomedia.getNetAddress());
                }
                ((BridgeLinkSharedHost)remlinknode).setSharedHost(this.getNodePortString(ips, shredmac) + " No node found");
                linknode.getBridgeLinkSharedHost().add((BridgeLinkSharedHost)remlinknode);
                continue;
            }
            OnmsIpInterface first = null;
            boolean multiplenodeids = false;
            for (OnmsIpInterface ip : (List)sharedhosts.get(shredmac)) {
                if (first == null) {
                    first = ip;
                }
                if (first.getNode().getId().intValue() != ip.getNode().getId().intValue()) {
                    multiplenodeids = true;
                }
                ips.add(ip.getIpAddress());
            }
            if (multiplenodeids) {
                ((BridgeLinkSharedHost)remlinknode).setSharedHost(this.getNodePortString(ips, shredmac) + " duplicated ip multiple node associated in db");
            } else {
                ((BridgeLinkSharedHost)remlinknode).setSharedHost(first.getNode().getLabel());
                ((BridgeLinkSharedHost)remlinknode).setSharedHostUrl(this.getNodeUrl(first.getNode().getId()));
            }
            ((BridgeLinkSharedHost)remlinknode).setSharedHostPort(this.getNodePortString(ips, shredmac));
            if (ips.size() == 1) {
                ((BridgeLinkSharedHost)remlinknode).setSharedHostPortUrl(this.getIpInterfaceUrl(first));
            }
            linknode.getBridgeLinkSharedHost().add((BridgeLinkSharedHost)remlinknode);
        }
        return linknode;
    }

    @Override
    public Collection<BridgeLinkNode> getBridgeLinks(int nodeId) {
        ArrayList<BridgeLinkNode> bridgelinks = new ArrayList<BridgeLinkNode>();
        for (SharedSegment segment : this.m_bridgetopologyDao.getBridgeNodeSharedSegments(this.m_bridgeBridgeLinkDao, this.m_bridgeMacLinkDao, nodeId)) {
            bridgelinks.add(this.convertFromModel(nodeId, segment));
        }
        Collections.sort(bridgelinks);
        return bridgelinks;
    }

    @Transactional
    private BridgeLinkNode convertFromModel(int nodeid, SharedSegment segment) {
        Object remlinknode;
        BridgeLinkNode linknode = new BridgeLinkNode();
        for (Object link : segment.getBridgePortsOnSegment()) {
            OnmsSnmpInterface remiface;
            Integer rempnodeId = link.getNode().getId();
            Integer rembridgePortIfIndex = link.getBridgePortIfIndex();
            OnmsSnmpInterface onmsSnmpInterface = remiface = rembridgePortIfIndex == null ? null : this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(rempnodeId, rembridgePortIfIndex);
            if (link.getNode().getId() == nodeid) {
                if (remiface != null) {
                    linknode.setNodeLocalPort(this.getPortString(rembridgePortIfIndex, remiface.getIfName(), remiface.getIfAlias()));
                } else {
                    linknode.setNodeLocalPort(this.getPortString(rembridgePortIfIndex, null, null));
                }
                linknode.setBridgeLocalVlan(link.getVlan());
                continue;
            }
            BridgeLinkRemoteNode remlinknode2 = new BridgeLinkRemoteNode();
            remlinknode2.setBridgeRemoteNode(link.getNode().getLabel());
            remlinknode2.setBridgeRemoteUrl(this.getNodeUrl(rempnodeId));
            if (remiface != null) {
                remlinknode2.setBridgeRemotePort(this.getPortString(rembridgePortIfIndex, remiface.getIfName(), remiface.getIfAlias()));
            } else {
                remlinknode2.setBridgeRemotePort(this.getPortString(rembridgePortIfIndex, null, null));
            }
            remlinknode2.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(rempnodeId, rembridgePortIfIndex));
            remlinknode2.setBridgeRemoteVlan(link.getVlan());
            linknode.getBridgeLinkRemoteNodes().add(remlinknode2);
        }
        if (segment.getBridgeBridgeLinks().isEmpty()) {
            for (Object link : segment.getBridgeMacLinks()) {
                if (link.getNode().getId() != nodeid) continue;
                linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkCreateTime()));
                linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkLastPollTime()));
                break;
            }
        } else {
            for (Object link : segment.getBridgeBridgeLinks()) {
                if (link.getNode().getId() != nodeid && link.getDesignatedNode().getId() != nodeid) continue;
                linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)link.getBridgeBridgeLinkCreateTime()));
                linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)link.getBridgeBridgeLinkLastPollTime()));
                break;
            }
        }
        HashMap sharedmacs = new HashMap();
        for (String shredmac : segment.getMacsOnSegment()) {
            sharedmacs.put(shredmac, new ArrayList());
            ((List)sharedmacs.get(shredmac)).addAll(this.m_ipNetToMediaDao.findByPhysAddress(shredmac));
        }
        HashMap sharedhosts = new HashMap();
        for (String shredmac : sharedmacs.keySet()) {
            if (((List)sharedmacs.get(shredmac)).isEmpty()) {
                remlinknode = new BridgeLinkSharedHost();
                OnmsSnmpInterface snmp = this.getFromPhysAddress(shredmac);
                if (snmp == null) {
                    ((BridgeLinkSharedHost)remlinknode).setSharedHost(shredmac + " No ip address found");
                } else {
                    ((BridgeLinkSharedHost)remlinknode).setSharedHost(snmp.getNode().getLabel());
                    ((BridgeLinkSharedHost)remlinknode).setSharedHostUrl(this.getNodeUrl(snmp.getNode().getId()));
                    ((BridgeLinkSharedHost)remlinknode).setSharedHostPort(this.getPortString(snmp.getIfIndex(), snmp.getIfName(), snmp.getIfAlias()));
                    ((BridgeLinkSharedHost)remlinknode).setSharedHostPortUrl(this.getSnmpInterfaceUrl(snmp.getNode().getId(), snmp.getIfIndex()));
                }
                linknode.getBridgeLinkSharedHost().add((BridgeLinkSharedHost)remlinknode);
                continue;
            }
            sharedhosts.put(shredmac, new ArrayList());
            for (IpNetToMedia ipnettomedia : (List)sharedmacs.get(shredmac)) {
                ((List)sharedhosts.get(shredmac)).addAll(this.m_ipInterfaceDao.findByIpAddress(ipnettomedia.getNetAddress().getHostAddress()));
            }
        }
        for (String shredmac : sharedhosts.keySet()) {
            remlinknode = new BridgeLinkSharedHost();
            HashSet<InetAddress> ips = new HashSet<InetAddress>();
            if (((List)sharedhosts.get(shredmac)).isEmpty()) {
                for (IpNetToMedia ipnettomedia : (List)sharedmacs.get(shredmac)) {
                    ips.add(ipnettomedia.getNetAddress());
                }
                ((BridgeLinkSharedHost)remlinknode).setSharedHost(this.getNodePortString(ips, shredmac) + " No node found");
                linknode.getBridgeLinkSharedHost().add((BridgeLinkSharedHost)remlinknode);
                continue;
            }
            OnmsIpInterface first = null;
            boolean multiplenodeids = false;
            for (OnmsIpInterface ip : (List)sharedhosts.get(shredmac)) {
                if (first == null) {
                    first = ip;
                }
                if (first.getNode().getId().intValue() != ip.getNode().getId().intValue()) {
                    multiplenodeids = true;
                }
                ips.add(ip.getIpAddress());
            }
            if (multiplenodeids) {
                ((BridgeLinkSharedHost)remlinknode).setSharedHost(this.getNodePortString(ips, shredmac) + " duplicated ip multiple node associated in db");
            } else {
                ((BridgeLinkSharedHost)remlinknode).setSharedHost(first.getNode().getLabel());
                ((BridgeLinkSharedHost)remlinknode).setSharedHostUrl(this.getNodeUrl(first.getNode().getId()));
            }
            ((BridgeLinkSharedHost)remlinknode).setSharedHostPort(this.getNodePortString(ips, shredmac));
            if (ips.size() == 1) {
                ((BridgeLinkSharedHost)remlinknode).setSharedHostPortUrl(this.getIpInterfaceUrl(first));
            }
            linknode.getBridgeLinkSharedHost().add((BridgeLinkSharedHost)remlinknode);
        }
        return linknode;
    }

    private String getAdjSysIDString(String adjsysid, String label) {
        return adjsysid + "(" + label + ")";
    }

    private String getChassisIdString(String sysname, String chassisId, LldpUtils.LldpChassisIdSubType chassisType) {
        return sysname + ": " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)chassisType.getValue()) + ": " + chassisId;
    }

    private String getChassisIdString(String chassisId, LldpUtils.LldpChassisIdSubType chassisType) {
        return LldpUtils.LldpChassisIdSubType.getTypeString((Integer)chassisType.getValue()) + ": " + chassisId;
    }

    private String getPortString(String portId, LldpUtils.LldpPortIdSubType type) {
        return LldpUtils.LldpPortIdSubType.getTypeString((Integer)type.getValue()) + ": " + portId;
    }

    private OnmsSnmpInterface getFromCdpCacheDevicePort(Integer nodeid, String cdpCacheDevicePort) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.sql((Object)("snmpifalias = '" + cdpCacheDevicePort + "' OR snmpifname = '" + cdpCacheDevicePort + "' OR snmpifdescr = '" + cdpCacheDevicePort + "'")).eq("node.id", (Object)nodeid);
        List nodes = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (nodes.size() == 1) {
            return (OnmsSnmpInterface)nodes.get(0);
        }
        return null;
    }

    private OnmsSnmpInterface getFromPhysAddress(String physAddress) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.eq("physAddr", (Object)physAddress);
        List nodes = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (nodes.size() == 1) {
            return (OnmsSnmpInterface)nodes.get(0);
        }
        return null;
    }

    private String getNodePortString(Set<InetAddress> ips, String physaddr) {
        String port = "";
        if (ips.size() > 1) {
            port = port + "multiple ip addresses";
        }
        if (ips.size() == 1) {
            port = port + InetAddressUtils.str((InetAddress)ips.iterator().next());
        }
        if (physaddr != null) {
            port = port + "(" + physaddr + ")";
        }
        return port;
    }

    private String getPortString(Integer ifindex, String ifName, String ifAlias) {
        if (ifindex == null && ifName == null && ifAlias == null) {
            return null;
        }
        String port = "";
        if (ifName != null) {
            port = port + ifName;
        }
        if (ifindex != null) {
            port = port + "(ifindex:" + ifindex + ")";
        }
        if (ifAlias != null) {
            port = port + "(ifalias: " + ifAlias + ")";
        }
        return port;
    }

    private String getRemRouterIdString(String ip, String label) {
        return ip + "(" + label + ")";
    }

    private String getNodeUrl(Integer nodeid) {
        return "element/node.jsp?node=" + nodeid;
    }

    private String getSnmpInterfaceUrl(Integer nodeid, Integer ifindex) {
        if (ifindex != null && nodeid != null) {
            return "element/snmpinterface.jsp?node=" + nodeid + "&ifindex=" + ifindex;
        }
        return null;
    }

    private String getIpInterfaceUrl(Integer nodeid, String ipaddress) {
        return "element/interface.jsp?node=" + nodeid + "&intf=" + ipaddress;
    }

    private String getIpInterfaceUrl(OnmsIpInterface ip) {
        return "element/interface.jsp?node=" + ip.getNode().getId() + "&intf=" + InetAddressUtils.str((InetAddress)ip.getIpAddress());
    }
}

