/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.web.outage.Outage;

public abstract class OutageModel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Outage[] getCurrentOutagesForNode(int nodeId) throws SQLException {
        Outage[] outages = new Outage[]{};
        DBUtils d = new DBUtils(OutageModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT \n         outages.outageid, outages.iflostservice, outages.ifregainedservice, node.nodeID, \n         node.nodeLabel, \n         ipinterface.ipaddr, \n         ipinterface.iphostname, \n         service.servicename, \n         ifservices.serviceId \n    from outages \n    join ifservices \n      on ifservices.id = outages.ifserviceid \n    join ipinterface \n      on ipinterface.id = ifservices.ipinterfaceid \n    join node \n       on node.nodeid = ipinterface.nodeid \n    join service \n      on ifservices.serviceid = service.serviceid \n   where node.nodeid = ? \n     and outages.ifregainedservice is null \n     and outages.suppresstime is null \n      or outages.suppresstime < now() \norder by iflostservice desc");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            outages = OutageModel.rs2Outages(rs, false);
        }
        finally {
            d.cleanUp();
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutageSummary[] getAllOutageSummaries(Date date) throws SQLException {
        OutageSummary[] summaries = new OutageSummary[]{};
        DBUtils d = new DBUtils(OutageModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT node.nodeid, outages.iflostservice as timeDown, outages.ifregainedservice as timeUp, node.nodelabel FROM outages, node, ipinterface, ifservices WHERE node.nodeid=ipinterface.nodeid AND ipinterface.id=ifservices.ipinterfaceid AND ifservices.id=outages.ifserviceid AND node.nodeType != 'D' AND ipinterface.ismanaged != 'D' AND ifservices.status != 'D' AND outages.iflostservice >= ? ORDER BY timeDown DESC;");
            d.watch((Object)stmt);
            stmt.setTimestamp(1, new Timestamp(date.getTime()));
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            ArrayList<OutageSummary> list = new ArrayList<OutageSummary>();
            while (rs.next()) {
                int nodeId = rs.getInt("nodeID");
                Timestamp timeDown = rs.getTimestamp("timeDown");
                Date downDate = new Date(timeDown.getTime());
                Timestamp timeUp = rs.getTimestamp("timeUp");
                Date upDate = null;
                if (timeUp != null) {
                    upDate = new Date(timeUp.getTime());
                }
                String nodeLabel = rs.getString("nodelabel");
                list.add(new OutageSummary(nodeId, nodeLabel, downDate, upDate));
            }
            summaries = list.toArray(new OutageSummary[list.size()]);
        }
        finally {
            d.cleanUp();
        }
        return summaries;
    }

    private static Outage[] rs2Outages(ResultSet rs, boolean includesRegainedTime) throws SQLException {
        return OutageModel.rs2Outages(rs, includesRegainedTime, false);
    }

    private static Outage[] rs2Outages(ResultSet rs, boolean includesRegainedTime, boolean includesNotifications) throws SQLException {
        Outage[] outages = null;
        ArrayList<Outage> list = new ArrayList<Outage>();
        while (rs.next()) {
            Outage outage = new Outage();
            outage.nodeId = rs.getInt("nodeid");
            outage.ipAddress = rs.getString("ipaddr");
            outage.serviceId = rs.getInt("serviceid");
            outage.nodeLabel = rs.getString("nodeLabel");
            outage.hostname = rs.getString("iphostname");
            outage.serviceName = rs.getString("servicename");
            outage.outageId = rs.getInt("outageid");
            Timestamp lostService = rs.getTimestamp("iflostservice");
            if (!rs.wasNull()) {
                outage.lostServiceTime = new Date(lostService.getTime());
            }
            if (includesRegainedTime) {
                Timestamp regainedService = rs.getTimestamp("ifregainedservice");
                if (!rs.wasNull()) {
                    outage.regainedServiceTime = new Date(regainedService.getTime());
                }
            }
            if (includesNotifications) {
                int serviceLostEventId = rs.getInt("svclosteventid");
                if (!rs.wasNull()) {
                    outage.lostServiceEventId = serviceLostEventId;
                }
                int notifyId = rs.getInt("notifyid");
                if (!rs.wasNull()) {
                    outage.lostServiceNotificationId = notifyId;
                }
                outage.lostServiceNotificationAcknowledgedBy = rs.getString("answeredby");
            }
            list.add(outage);
        }
        outages = list.toArray(new Outage[list.size()]);
        return outages;
    }
}

