/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.List;
import org.opennms.web.svclayer.SchedulerService;
import org.opennms.web.svclayer.model.ManageReportScheduleCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/report/database/manageSchedule.htm"})
public class ManageReportScheduleController {
    private final int m_pageSize = 10;
    @Autowired
    private SchedulerService m_reportSchedulerService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView listTriggers(@RequestParam(value="p", required=false, defaultValue="0") int page, ModelAndView modelAndView) {
        List reportTriggers = this.m_reportSchedulerService.getTriggerDescriptions();
        PagedListHolder pagedListHolder = new PagedListHolder(reportTriggers);
        pagedListHolder.setPageSize(10);
        pagedListHolder.setPage(Math.max(page, 0));
        modelAndView.addObject("pagedListHolder", (Object)pagedListHolder);
        modelAndView.addObject("command", (Object)new ManageReportScheduleCommand());
        modelAndView.setViewName("/report/database/manageSchedule");
        return modelAndView;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView deleteTriggers(WebRequest request, @ModelAttribute ManageReportScheduleCommand command) {
        ModelAndView modelAndView = new ModelAndView();
        if (request.isUserInRole("ROLE_READONLY")) {
            modelAndView.addObject("error", (Object)"You are a read only user and therefore not allowed to unschedule reports.");
            return this.listTriggers(0, modelAndView);
        }
        this.m_reportSchedulerService.removeTriggers(command.getTriggerNames());
        modelAndView.addObject("success", (Object)"Reports successfully unscheduled.");
        return this.listTriggers(0, modelAndView);
    }
}

