/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.web.outage.OutageModel;
import org.opennms.web.rss.AbstractFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutageFeed
extends AbstractFeed {
    private static final Logger LOG = LoggerFactory.getLogger(OutageFeed.class);

    public OutageFeed() {
        this.setMaxEntries(Integer.MAX_VALUE);
    }

    public OutageFeed(String feedType) {
        super(feedType);
        this.setMaxEntries(Integer.MAX_VALUE);
    }

    @Override
    public SyndFeed getFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Nodes with Outages");
        feed.setDescription("OpenNMS Nodes with Outages");
        feed.setLink(this.getUrlBase() + "outage/list.htm");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            Date date = new Date();
            date.setTime(date.getTime() - 86400000L);
            OutageSummary[] summaries = OutageModel.getAllOutageSummaries(date);
            int count = 0;
            for (OutageSummary summary : summaries) {
                if (count++ != this.getMaxEntries()) {
                    String link = this.getUrlBase() + "element/node.jsp?node=" + summary.getNodeId();
                    SyndEntryImpl entry = new SyndEntryImpl();
                    entry.setPublishedDate(summary.getTimeDown());
                    if (summary.getTimeUp() == null) {
                        entry.setTitle(this.sanitizeTitle(summary.getNodeLabel()));
                        entry.setUpdatedDate(summary.getTimeDown());
                    } else {
                        entry.setTitle(this.sanitizeTitle(summary.getNodeLabel()) + " (Resolved)");
                        entry.setUpdatedDate(summary.getTimeUp());
                    }
                    entry.setLink(link);
                    entry.setAuthor("OpenNMS");
                    entries.add(entry);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            LOG.warn("unable to get current outages", (Throwable)e);
        }
        feed.setEntries(entries);
        return feed;
    }
}

