/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

public class AssetFilter
extends EqualsFilter<String> {
    public static final String TYPE = "asset.";
    private String assetField;

    public AssetFilter(String field, String value) {
        super(field, SQLType.STRING, "OUTAGES.IFSERVICEID", field, value);
        this.assetField = field.replaceFirst(TYPE, "");
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " IN (SELECT DISTINCT ifservices.id FROM ifservices, ipinterface, assets WHERE ifservices.ipinterfaceid = ipinterface.id AND ipinterface.nodeid = assets.nodeid AND assets." + this.assetField + "=%s)";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)(" {alias}.ifserviceid IN (SELECT DISTINCT ifservices.id FROM ifservices, ipinterface, assets WHERE ifservices.ipinterfaceid = ipinterface.id AND ipinterface.nodeid = assets.nodeid AND assets." + this.assetField + "=?)"), this.getValue(), (Type)StringType.INSTANCE);
    }

    @Override
    public String toString() {
        return "<AssetFilter: " + this.getDescription() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

