/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.controller.ksc.CustomGraphEditDetailsController;
import org.opennms.web.controller.ksc.KscReportEditor;
import org.opennms.web.svclayer.api.KscReportService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcReportController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        KscReportEditor editor = KscReportEditor.getFromSession(request.getSession(), true);
        Report report = editor.getWorkingReport();
        String action = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.action.toString()));
        String report_title = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.report_title.toString()));
        String show_timespan = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.show_timespan.toString()));
        String show_graphtype = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.show_graphtype.toString()));
        String g_index = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graph_index.toString()));
        int graph_index = WebSecurityUtils.safeParseInt((String)g_index);
        int graphs_per_line = WebSecurityUtils.safeParseInt((String)request.getParameter(Parameters.graphs_per_line.toString()));
        report.setTitle(report_title);
        if (show_graphtype == null) {
            report.setShow_graphtype_button(false);
        } else {
            report.setShow_graphtype_button(true);
        }
        if (show_timespan == null) {
            report.setShow_timespan_button(false);
        } else {
            report.setShow_timespan_button(true);
        }
        if (graphs_per_line > 0) {
            report.setGraphs_per_line(graphs_per_line);
        } else {
            report.setGraphs_per_line(0);
        }
        if (Actions.Save.toString().equals(action)) {
            try {
                editor.unloadWorkingReport(this.getKscReportFactory());
                this.getKscReportFactory().saveCurrent();
                KscReportEditor.unloadFromSession(request.getSession());
            }
            catch (Throwable e) {
                throw new ServletException("Couldn't save report: " + e.getMessage(), e);
            }
        } else if (Actions.AddGraph.toString().equals(action) || Actions.ModGraph.toString().equals(action)) {
            editor.loadWorkingGraph(graph_index);
        } else if (Actions.DelGraph.toString().equals(action)) {
            report.removeGraph(report.getGraph(graph_index));
        } else {
            throw new ServletException("Invalid Argument for Customize Form Action.");
        }
        if (Actions.Save.toString().equals(action)) {
            return new ModelAndView("redirect:/KSC/index.jsp");
        }
        if (Actions.DelGraph.toString().equals(action)) {
            return new ModelAndView("redirect:/KSC/customReport.htm");
        }
        if (Actions.AddGraph.toString().equals(action)) {
            return new ModelAndView("redirect:/KSC/customGraphChooseResource.jsp");
        }
        if (Actions.ModGraph.toString().equals(action)) {
            Graph graph = editor.getWorkingGraph();
            OnmsResource resource = this.getKscReportService().getResourceFromGraph(graph);
            String graphType = graph.getGraphtype();
            HashMap<String, String> modelData = new HashMap<String, String>();
            modelData.put(CustomGraphEditDetailsController.Parameters.resourceId.toString(), resource.getId());
            modelData.put(CustomGraphEditDetailsController.Parameters.graphtype.toString(), graphType);
            return new ModelAndView("redirect:/KSC/customGraphEditDetails.htm", modelData);
        }
        throw new IllegalArgumentException("Parameter action of '" + action + "' is not supported.  Must be one of: Save, Cancel, Update, AddGraph, or DelGraph");
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
    }

    public static enum Actions {
        Save,
        AddGraph,
        DelGraph,
        ModGraph;

    }

    public static enum Parameters {
        action,
        report_title,
        show_timespan,
        show_graphtype,
        graph_index,
        graphs_per_line;

    }
}

