/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.bsm;

import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteriaBuilder;
import org.opennms.netmgt.bsm.service.model.Status;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class BusinessServicesBoxController
extends AbstractController
implements InitializingBean {
    public static final int DEFAULT_ROW_COUNT = 10;
    private BusinessServiceManager businessServiceManager;
    private String m_successView;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean more;
        int numberOfRows = Integer.getInteger("opennms.businessServicesWithProblems.count", 10);
        BusinessServiceSearchCriteriaBuilder criteriaBuilder = new BusinessServiceSearchCriteriaBuilder().order(BusinessServiceSearchCriteriaBuilder.Order.Severity).greaterSeverity(Status.NORMAL).desc();
        List bsList = criteriaBuilder.apply(this.businessServiceManager, this.businessServiceManager.getAllBusinessServices());
        boolean bl = more = bsList.size() - numberOfRows > 0;
        if (bsList.size() > numberOfRows) {
            bsList = bsList.subList(0, numberOfRows);
        }
        ModelAndView modelAndView = new ModelAndView(this.m_successView);
        modelAndView.addObject("more", (Object)more);
        modelAndView.addObject("services", bsList);
        return modelAndView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = businessServiceManager;
    }

    public void afterPropertiesSet() {
        Objects.requireNonNull(this.m_successView, "successView must be set");
        Objects.requireNonNull(this.businessServiceManager, "businessServiceManager must be set");
    }
}

