/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.TreeMap;
import java.util.TreeSet;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.web.svclayer.ManualProvisioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/admin/provisioningGroups.htm"})
public class ProvisioningGroupsController {
    public static final String DEFAULT_PROVISIONING_GROUP_NAME = "default";
    @Autowired
    private ManualProvisioningService m_provisioningService;
    @Autowired
    private ForeignSourceService m_foreignSourceService;

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(GroupAction command, BindingResult result) {
        String action = command.getAction();
        if (action == null || "show".equalsIgnoreCase(action)) {
            this.doShow(command);
        } else if ("addGroup".equalsIgnoreCase(action)) {
            this.doAddGroup(command);
        } else if ("deleteNodes".equalsIgnoreCase(action)) {
            this.doDeleteNodes(command);
        } else if ("import".equalsIgnoreCase(action)) {
            this.doImport(command);
        } else if ("deleteGroup".equalsIgnoreCase(action)) {
            this.doDeleteGroup(command);
        } else if ("cloneForeignSource".equalsIgnoreCase(action)) {
            this.doCloneForeignSource(command);
        } else if ("resetDefaultForeignSource".equalsIgnoreCase(action)) {
            this.doResetDefaultForeignSource(command);
        } else {
            result.reject("Unrecognized action: " + action);
        }
        return "redirect:/admin/provisioningGroups.htm";
    }

    private void doShow(GroupAction command) {
    }

    private void doDeleteGroup(GroupAction command) {
        this.m_provisioningService.deleteProvisioningGroup(command.getGroupName());
        this.m_foreignSourceService.deleteForeignSource(command.getGroupName());
    }

    private void doImport(GroupAction command) {
        this.m_provisioningService.importProvisioningGroup(command.getGroupName());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doDeleteNodes(GroupAction command) {
        this.m_provisioningService.deleteAllNodes(command.getGroupName());
    }

    private void doAddGroup(GroupAction command) {
        String groupName = command.getGroupName();
        if (!groupName.equals(DEFAULT_PROVISIONING_GROUP_NAME) && !groupName.equals("") && this.m_provisioningService.getProvisioningGroup(groupName) == null) {
            this.m_provisioningService.createProvisioningGroup(command.getGroupName());
        }
    }

    private void doCloneForeignSource(GroupAction command) {
        this.m_foreignSourceService.cloneForeignSource(command.getGroupName(), command.getActionTarget());
    }

    private void doResetDefaultForeignSource(GroupAction command) {
        this.m_foreignSourceService.deleteForeignSource(DEFAULT_PROVISIONING_GROUP_NAME);
    }

    @RequestMapping(method={RequestMethod.GET})
    public void referenceData(ModelMap map) {
        TreeSet<String> names = new TreeSet<String>();
        TreeMap<String, Requisition> groups = new TreeMap<String, Requisition>();
        TreeMap<String, ForeignSource> foreignSources = new TreeMap<String, ForeignSource>();
        for (Requisition mi : this.m_provisioningService.getAllGroups()) {
            if (mi == null) continue;
            names.add(mi.getForeignSource());
            groups.put(mi.getForeignSource(), mi);
        }
        for (ForeignSource fs : this.m_foreignSourceService.getAllForeignSources()) {
            if (fs.isDefault()) continue;
            names.add(fs.getName());
            foreignSources.put(fs.getName(), fs);
        }
        map.put((Object)"foreignSourceNames", names);
        map.put((Object)"groups", groups);
        map.put((Object)"foreignSources", foreignSources);
        map.put((Object)"dbNodeCounts", (Object)this.m_provisioningService.getGroupDbNodeCounts());
    }

    public static class GroupAction {
        private String m_groupName;
        private String m_action = "show";
        private String m_actionTarget;

        public String getAction() {
            return this.m_action;
        }

        public void setAction(String action) {
            this.m_action = action;
        }

        public String getGroupName() {
            return this.m_groupName;
        }

        public void setGroupName(String groupName) {
            this.m_groupName = groupName;
        }

        public String getActionTarget() {
            return this.m_actionTarget;
        }

        public void setActionTarget(String target) {
            this.m_actionTarget = target;
        }
    }
}

