/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.Columns;
import org.opennms.netmgt.config.surveillanceViews.RowDef;
import org.opennms.netmgt.config.surveillanceViews.Rows;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.config.surveillanceViews.Views;
import org.opennms.netmgt.dao.api.SurveillanceViewConfigDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.web.svclayer.AdminCategoryService;
import org.opennms.web.svclayer.support.DefaultAdminCategoryService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class CategoryController
extends AbstractController {
    private AdminCategoryService m_adminCategoryService;
    private SurveillanceViewConfigDao m_surveillanceViewConfigDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String removeCategoryIdString = request.getParameter("removeCategoryId");
        String newCategoryName = request.getParameter("newCategoryName");
        String categoryIdString = request.getParameter("categoryid");
        String editString = request.getParameter("edit");
        String nodeIdString = request.getParameter("node");
        RedirectView redirect = new RedirectView("/admin/categories.htm", true);
        if (removeCategoryIdString != null) {
            this.m_adminCategoryService.removeCategory(removeCategoryIdString);
            return new ModelAndView((org.springframework.web.servlet.View)redirect);
        }
        if (newCategoryName != null) {
            OnmsCategory cat = this.m_adminCategoryService.getCategoryWithName(newCategoryName);
            if (cat == null) {
                this.m_adminCategoryService.addNewCategory(newCategoryName);
            }
            return new ModelAndView((org.springframework.web.servlet.View)redirect);
        }
        if (categoryIdString != null && editString != null) {
            String editAction = request.getParameter("action");
            if (editAction != null) {
                String[] toAdd = request.getParameterValues("toAdd");
                String[] toDelete = request.getParameterValues("toDelete");
                this.m_adminCategoryService.performEdit(categoryIdString, editAction, toAdd, toDelete);
                ModelAndView modelAndView = new ModelAndView((org.springframework.web.servlet.View)redirect);
                modelAndView.addObject("categoryid", (Object)categoryIdString);
                modelAndView.addObject("edit", (Object)"edit");
                return modelAndView;
            }
            DefaultAdminCategoryService.EditModel model = this.m_adminCategoryService.findCategoryAndAllNodes(categoryIdString);
            return new ModelAndView("/admin/editCategory", "model", (Object)model);
        }
        if (categoryIdString != null) {
            return new ModelAndView("/admin/showCategory", "model", (Object)this.m_adminCategoryService.getCategory(categoryIdString));
        }
        if (nodeIdString != null && editString != null) {
            String editAction = request.getParameter("action");
            if (editAction != null) {
                String[] toAdd = request.getParameterValues("toAdd");
                String[] toDelete = request.getParameterValues("toDelete");
                this.m_adminCategoryService.performNodeEdit(nodeIdString, editAction, toAdd, toDelete);
                ModelAndView modelAndView = new ModelAndView((org.springframework.web.servlet.View)redirect);
                modelAndView.addObject("node", (Object)nodeIdString);
                modelAndView.addObject("edit", (Object)"edit");
                return modelAndView;
            }
            DefaultAdminCategoryService.NodeEditModel model = this.m_adminCategoryService.findNodeCategories(nodeIdString);
            return new ModelAndView("/admin/editNodeCategories", "model", (Object)model);
        }
        List sortedCategories = this.m_adminCategoryService.findAllCategories();
        List<String> surveillanceCategories = this.getAllSurveillanceViewCategories();
        ModelAndView modelAndView = new ModelAndView("/admin/categories");
        modelAndView.addObject("categories", (Object)sortedCategories);
        modelAndView.addObject("surveillanceCategories", surveillanceCategories);
        return modelAndView;
    }

    private List<String> getAllSurveillanceViewCategories() {
        ArrayList<String> categoryNames = new ArrayList<String>();
        Views views = this.getSurveillanceViewConfigDao().getViews();
        for (View view : views.getViewCollection()) {
            Rows rows = view.getRows();
            for (RowDef row : rows.getRowDefCollection()) {
                List categoryCollection = row.getCategoryCollection();
                this.addCategoryNames(categoryNames, categoryCollection);
            }
            Columns columns = view.getColumns();
            for (ColumnDef column : columns.getColumnDefCollection()) {
                List categoryCollection = column.getCategoryCollection();
                this.addCategoryNames(categoryNames, categoryCollection);
            }
        }
        return categoryNames;
    }

    private void addCategoryNames(List<String> categoryNames, List<Category> categoryCollection) {
        for (Category category : categoryCollection) {
            if (categoryNames.contains(category.getName())) continue;
            categoryNames.add(category.getName());
        }
    }

    public AdminCategoryService getAdminCategoryService() {
        return this.m_adminCategoryService;
    }

    public void setAdminCategoryService(AdminCategoryService adminCategoryService) {
        this.m_adminCategoryService = adminCategoryService;
    }

    public void setSurveillanceViewConfigDao(SurveillanceViewConfigDao surveillanceConfigDao) {
        this.m_surveillanceViewConfigDao = surveillanceConfigDao;
    }

    public SurveillanceViewConfigDao getSurveillanceViewConfigDao() {
        return this.m_surveillanceViewConfigDao;
    }
}

