/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.NormalizedQueryParameters;
import org.opennms.web.filter.QueryParameters;
import org.opennms.web.tags.filters.FilterCallback;

public class FavoriteTag
extends TagSupport {
    private static final long serialVersionUID = -2620230289707902880L;
    public static Action CLEAR_FILTERS = new Action(){
        private static final String DESELECT_FAVORITE_JAVASCRIPT_TEMPLATE = "   function clearFilters() {\n       window.location.href = '{CLEAR_URL}'\n   }";

        @Override
        public String getJavascript(FavoriteTag favoriteTag) {
            NormalizedQueryParameters parameters = new NormalizedQueryParameters(favoriteTag.parameters);
            parameters.setFilters(new ArrayList<Filter>());
            return DESELECT_FAVORITE_JAVASCRIPT_TEMPLATE.replaceAll("\\{CLEAR_URL\\}", FavoriteTag.createLink(favoriteTag.filterCallback, favoriteTag.getContext(), parameters, null));
        }
    };
    public static Action DELETE_FAVORITE = new Action(){
        private static final String DELETE_FAVORITE_JAVASCRIPT_TEMPLATE = "   function deleteFavorite(favoriteId) {\n       var reallyDelete = confirm('Do you really want to delete this favorite?');\n       if (reallyDelete) {\n           window.location.href = '{DELETE_FAVORITE_URL}' + favoriteId;\n       }\n   }";

        @Override
        public String getJavascript(FavoriteTag favoriteTag) {
            String urlBase = favoriteTag.getUrlBase() + favoriteTag.getDeleteFilterController();
            String deleteFavoriteUrl = FavoriteTag.createLink(favoriteTag.filterCallback, urlBase, favoriteTag.parameters, null);
            return DELETE_FAVORITE_JAVASCRIPT_TEMPLATE.replaceAll("\\{DELETE_FAVORITE_URL\\}", MessageFormat.format("{0}&favoriteId=", deleteFavoriteUrl));
        }
    };
    public static Action CREATE_FAVORITE = new Action(){
        private static final String CREATE_FAVORITE_JAVASCRIPT_TEMPLATE = "   function createFavorite() {\n       var favoriteName = prompt(\"Please enter a name for this filter favorite:\", \"\");\n       if (favoriteName != null && favoriteName != '') {\n           window.location.href = '{CREATE_FAVORITE_URL}' + favoriteName;\n       }\n}";

        @Override
        public String getJavascript(FavoriteTag favoriteTag) {
            String urlBase = favoriteTag.getUrlBase() + favoriteTag.getCreateFilterController();
            String createUrl = FavoriteTag.createLink(favoriteTag.filterCallback, urlBase, favoriteTag.parameters, null);
            String createFavoriteURL = MessageFormat.format("{0}&favoriteName=", createUrl);
            return CREATE_FAVORITE_JAVASCRIPT_TEMPLATE.replaceAll("\\{CREATE_FAVORITE_URL\\}", createFavoriteURL);
        }
    };
    private FilterCallback filterCallback;
    private OnmsFilterFavorite favorite;
    private QueryParameters parameters;
    private String createFavoriteController;
    private String deleteFavoriteController;
    private String context;

    private static String createLink(FilterCallback callback, String urlBase, QueryParameters params, OnmsFilterFavorite favorite) {
        return callback.createLink(urlBase, params, favorite).replaceAll("&amp;", "&");
    }

    public void setCallback(FilterCallback callback) {
        this.filterCallback = callback;
    }

    public void setParameters(QueryParameters parameters) {
        this.parameters = parameters;
    }

    public void setCreateFavoriteController(String createFavoriteController) {
        if (createFavoriteController.startsWith("/")) {
            createFavoriteController = createFavoriteController.substring(1, createFavoriteController.length());
        }
        this.createFavoriteController = createFavoriteController;
    }

    public void setDeleteFavoriteController(String deleteFavoriteController) {
        if (deleteFavoriteController.startsWith("/")) {
            deleteFavoriteController = deleteFavoriteController.substring(1, deleteFavoriteController.length());
        }
        this.deleteFavoriteController = deleteFavoriteController;
    }

    public void setFavorite(OnmsFilterFavorite favorite) {
        this.favorite = favorite;
    }

    public void setContext(String context) {
        if (context != null && context.startsWith("/")) {
            context = context.substring(1, context.length());
        }
        this.context = context;
    }

    public OnmsFilterFavorite getFavorite() {
        return this.favorite;
    }

    public int doStartTag() throws JspException {
        this.out(String.format("<script type=\"text/javascript\">\n%s\n%s\n%s\n</script>\n", CREATE_FAVORITE.getJavascript(this), DELETE_FAVORITE.getJavascript(this), CLEAR_FILTERS.getJavascript(this)));
        return 1;
    }

    private String getUrlBase() {
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        return contextPath;
    }

    private void out(String content) throws JspException {
        try {
            this.pageContext.getOut().write(content);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private String getCreateFilterController() {
        return this.createFavoriteController;
    }

    private String getDeleteFilterController() {
        return this.deleteFavoriteController;
    }

    private String getContext() {
        return this.getUrlBase() + this.context;
    }

    public static interface Action {
        public String getJavascript(FavoriteTag var1);
    }
}

