/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.Password;
import org.opennms.netmgt.config.users.User;

public class AddNewUserServlet
extends HttpServlet {
    private static final long serialVersionUID = 9221831285444697701L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            UserFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("AddNewUserServlet: Error initialising user factory." + e);
        }
        UserManager userFactory = UserFactory.getInstance();
        String userID = request.getParameter("userID");
        String password = request.getParameter("pass1");
        boolean hasUser = false;
        try {
            hasUser = userFactory.hasUser(userID);
        }
        catch (Throwable e) {
            throw new ServletException("can't determine if user " + userID + " already exists in users.xml.", e);
        }
        if (hasUser) {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/userGroupView/users/newUser.jsp?action=redo");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            Password pass = new Password();
            pass.setEncryptedPassword(UserFactory.getInstance().encryptedPassword(password, true));
            pass.setSalt(Boolean.valueOf(true));
            User newUser = new User();
            newUser.setUserId(userID);
            newUser.setPassword(pass);
            HttpSession userSession = request.getSession(false);
            userSession.setAttribute("user.modifyUser.jsp", (Object)newUser);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/userGroupView/users/modifyUser.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

