/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.admin.nodeManagement.ManagedInterface;
import org.opennms.web.admin.nodeManagement.ManagedService;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageNodeServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ManageNodeServlet.class);
    private static final long serialVersionUID = -544260517139205801L;
    private static final String UPDATE_SERVICE = "UPDATE ifservices SET status = ? FROM ipInterface INNER JOIN node ON ipInterface.nodeId = node.nodeId WHERE ifServices.ipInterfaceId = ipInterface.id AND node.nodeId = ? AND ipInterface.ipAddr = ? AND ifServices.serviceId = ?";
    private static final String DELETE_SERVICE_OUTAGES = "DELETE FROM outages WHERE ifregainedservice IS NULL AND ifserviceid IN (SELECT ifServices.id FROM ifServices, ipInterface, node WHERE ifServices.ipInterfaceId = ipInterface.id AND ipInterface.nodeId = node.nodeId AND node.nodeId = ? AND ipInterface.ipAddr = ? AND ifServices.serviceId = ?)";
    private static final String INCLUDE_FILE_NAME = "include";
    public static final String NOTICE_NAME = "Email-Reporting";

    public void init() throws ServletException {
        try {
            NotificationFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not initialize notification factory: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        List<ManagedInterface> allNodes = ManageNodeServlet.getManagedInterfacesFromSession(userSession);
        String[] parameters = request.getParameterValues("interfaceCheck");
        List<Object> interfaceList = parameters == null ? Collections.emptyList() : Arrays.asList(parameters);
        parameters = request.getParameterValues("serviceCheck");
        List<Object> serviceList = parameters == null ? Collections.emptyList() : Arrays.asList(parameters);
        ArrayList<String> addToURL = new ArrayList<String>();
        ArrayList<String> unmanageInterfacesList = new ArrayList<String>();
        ArrayList<String> manageInterfacesList = new ArrayList<String>();
        Date curDate = new Date();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            try {
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement(UPDATE_SERVICE);
                d.watch((Object)stmt);
                PreparedStatement outagesstmt = connection.prepareStatement(DELETE_SERVICE_OUTAGES);
                d.watch((Object)outagesstmt);
                for (ManagedInterface curInterface : allNodes) {
                    String intKey = curInterface.getNodeid() + "-" + curInterface.getAddress();
                    if (interfaceList.contains(intKey)) {
                        addToURL.add(curInterface.getAddress());
                    }
                    if (interfaceList.contains(intKey) && curInterface.getStatus().equals("unmanaged")) {
                        manageInterfacesList.add(curInterface.getAddress());
                    } else if (!interfaceList.contains(intKey) && curInterface.getStatus().equals("managed")) {
                        unmanageInterfacesList.add(curInterface.getAddress());
                    }
                    List<ManagedService> interfaceServices = curInterface.getServices();
                    for (int k = 0; k < interfaceServices.size(); ++k) {
                        EventBuilder bldr;
                        ManagedService curService = interfaceServices.get(k);
                        String serviceKey = intKey + "-" + curService.getId();
                        if (serviceList.contains(serviceKey) && curService.getStatus().equals("unmanaged")) {
                            stmt.setString(1, String.valueOf("A"));
                            stmt.setInt(2, curInterface.getNodeid());
                            stmt.setString(3, curInterface.getAddress());
                            stmt.setInt(4, curService.getId());
                            LOG.debug("doPost: executing manage service update for {} {}", (Object)curInterface.getAddress(), (Object)curService.getName());
                            stmt.executeUpdate();
                            bldr = new EventBuilder("uei.opennms.org/internal/poller/resumePollingService", "web ui", curDate);
                            bldr.setNodeid((long)curInterface.getNodeid());
                            bldr.setInterface(InetAddressUtils.addr((String)curInterface.getAddress()));
                            bldr.setService(curService.getName());
                            ManageNodeServlet.sendEvent(bldr.getEvent());
                            continue;
                        }
                        if (serviceList.contains(serviceKey) || !curService.getStatus().equals("managed")) continue;
                        stmt.setString(1, String.valueOf("F"));
                        stmt.setInt(2, curInterface.getNodeid());
                        stmt.setString(3, curInterface.getAddress());
                        stmt.setInt(4, curService.getId());
                        outagesstmt.setInt(1, curInterface.getNodeid());
                        outagesstmt.setString(2, curInterface.getAddress());
                        outagesstmt.setInt(3, curService.getId());
                        LOG.debug("doPost: executing unmanage service update for {} {}", (Object)curInterface.getAddress(), (Object)curService.getName());
                        stmt.executeUpdate();
                        outagesstmt.executeUpdate();
                        bldr = new EventBuilder("uei.opennms.org/nodes/serviceUnmanaged", "web ui", curDate);
                        bldr.setNodeid((long)curInterface.getNodeid());
                        bldr.setInterface(InetAddressUtils.addr((String)curInterface.getAddress()));
                        bldr.setService(curService.getName());
                        ManageNodeServlet.sendEvent(bldr.getEvent());
                        bldr.setUei("uei.opennms.org/internal/poller/suspendPollingService");
                        ManageNodeServlet.sendEvent(bldr.getEvent());
                    }
                }
                if (manageInterfacesList.size() > 0) {
                    ManageNodeServlet.manageInterfaces(manageInterfacesList, connection);
                }
                if (unmanageInterfacesList.size() > 0) {
                    ManageNodeServlet.unmanageInterfaces(unmanageInterfacesList, connection);
                }
                ManageNodeServlet.writeURLFile(addToURL);
                connection.commit();
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        ManageNodeServlet.sendSCMRestartEvent();
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/manageNodesFinish.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private static List<ManagedInterface> getManagedInterfacesFromSession(HttpSession userSession) {
        if (userSession == null) {
            return null;
        }
        return (List)userSession.getAttribute("interfaces.nodemanagement");
    }

    private static void manageInterfaces(List<String> interfaces, Connection connection) throws SQLException {
        StringBuffer query = new StringBuffer("UPDATE ipinterface SET isManaged = ");
        query.append("'M'").append(" WHERE ipaddr IN (");
        for (int i = 0; i < interfaces.size(); ++i) {
            query.append("'").append(interfaces.get(i)).append("'");
            if (i >= interfaces.size() - 1) continue;
            query.append(",");
        }
        query.append(")");
        LOG.debug("manageInterfaces: query string: {}", (Object)query);
        Statement update = connection.createStatement();
        update.executeUpdate(query.toString());
        update.close();
    }

    private static void unmanageInterfaces(List<String> interfaces, Connection connection) throws SQLException {
        StringBuffer query = new StringBuffer("UPDATE ipinterface SET isManaged = ");
        query.append("'F'").append(" WHERE ipaddr IN (");
        for (int i = 0; i < interfaces.size(); ++i) {
            query.append("'").append(interfaces.get(i)).append("'");
            if (i >= interfaces.size() - 1) continue;
            query.append(",");
        }
        query.append(")");
        LOG.debug("unmanageInterfaces: query: {}", (Object)query);
        Statement update = connection.createStatement();
        update.executeUpdate(query.toString());
        update.close();
    }

    private static void sendSCMRestartEvent() throws ServletException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/restartSCM", "web ui");
        ManageNodeServlet.sendEvent(bldr.getEvent());
    }

    private static void writeURLFile(List<String> interfaceList) throws ServletException {
        String path = System.getProperty("opennms.home") + File.separator + "etc" + File.separator;
        String fileName = path + INCLUDE_FILE_NAME;
        FileOutputStream fos = null;
        OutputStreamWriter fileWriter = null;
        try {
            fos = new FileOutputStream(fileName);
            fileWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            for (int i = 0; i < interfaceList.size(); ++i) {
                fileWriter.write(interfaceList.get(i) + System.getProperty("line.separator"));
            }
            ((Writer)fileWriter).flush();
        }
        catch (IOException e) {
            try {
                throw new ServletException("Error writing the include url file " + fileName + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                IOUtils.closeQuietly((OutputStream)fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }
}

