/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.FilterFavoriteDao;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterFavoriteService {
    @Autowired
    private FilterFavoriteDao favoriteDao;

    public OnmsFilterFavorite getFavorite(String favoriteId, String username, String filterString) {
        OnmsFilterFavorite favorite = this.getFavorite(favoriteId, username);
        if (favorite == null) {
            return null;
        }
        if (favorite.getFilter().equals(FilterFavoriteService.unescapeAndDecode(filterString))) {
            return favorite;
        }
        return null;
    }

    public boolean deleteFavorite(String favoriteId, String username) {
        OnmsFilterFavorite favorite = this.getFavorite(favoriteId, username);
        return this.deleteFavorite(favorite);
    }

    public OnmsFilterFavorite getFavorite(String favoriteId, String userName) {
        try {
            Integer filterIdInteger = Integer.valueOf(favoriteId);
            if (filterIdInteger == null) {
                return null;
            }
            return this.getFavorite(filterIdInteger, userName);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public OnmsFilterFavorite getFavorite(Integer favoriteId, String userName) {
        OnmsFilterFavorite favorite = (OnmsFilterFavorite)this.favoriteDao.get((Serializable)favoriteId);
        if (favorite != null && favorite.getUsername().equalsIgnoreCase(userName)) {
            this.sanitizeFavorite(favorite);
            return favorite;
        }
        return null;
    }

    public boolean deleteFavorite(int favoriteId, String userName) {
        OnmsFilterFavorite favorite = this.getFavorite(favoriteId, userName);
        return this.deleteFavorite(favorite);
    }

    public List<OnmsFilterFavorite> getFavorites(String userName, OnmsFilterFavorite.Page page) {
        List favorites = this.favoriteDao.findBy(userName, page);
        favorites.forEach(f -> this.sanitizeFavorite((OnmsFilterFavorite)f));
        return favorites;
    }

    public OnmsFilterFavorite createFavorite(String userName, String favoriteName, String filterString, OnmsFilterFavorite.Page page) throws FilterFavoriteException {
        this.validate(userName, favoriteName, filterString, page);
        OnmsFilterFavorite filter = new OnmsFilterFavorite();
        filter.setUsername(userName);
        filter.setFilter(filterString);
        filter.setName(favoriteName);
        filter.setPage(page);
        this.sanitizeFavorite(filter);
        this.favoriteDao.save((Object)filter);
        return filter;
    }

    protected void setFilterFavoriteDao(FilterFavoriteDao favoriteDao) {
        this.favoriteDao = favoriteDao;
    }

    protected FilterFavoriteDao getFilterFavoriteDao() {
        return this.favoriteDao;
    }

    private void validate(String userName, String favoriteName, String filter, OnmsFilterFavorite.Page page) throws FilterFavoriteException {
        if (StringUtils.isEmpty((String)userName)) {
            throw new FilterFavoriteException("No username specified.");
        }
        if (StringUtils.isEmpty((String)favoriteName)) {
            throw new FilterFavoriteException("No favorite name specified.");
        }
        if (StringUtils.isEmpty((String)filter)) {
            throw new FilterFavoriteException("The specified favorite is empty.");
        }
        if (this.favoriteDao.existsFilter(userName, favoriteName, page)) {
            throw new FilterFavoriteException("A favorite with this name already exists.");
        }
    }

    private void sanitizeFavorite(OnmsFilterFavorite favorite) {
        favorite.setName(FilterFavoriteService.unescapeAndDecode(favorite.getName()));
        favorite.setFilter(FilterFavoriteService.unescapeAndDecode(favorite.getFilter()));
        favorite.setName(WebSecurityUtils.sanitizeString((String)favorite.getName()));
        favorite.setFilter(WebSecurityUtils.sanitizeString((String)favorite.getFilter()));
    }

    protected boolean deleteFavorite(OnmsFilterFavorite favorite) {
        if (favorite != null) {
            this.favoriteDao.delete((Object)favorite);
            return true;
        }
        return false;
    }

    private static String unescapeAndDecode(String input) {
        try {
            return StringEscapeUtils.unescapeHtml((String)URLDecoder.decode(input, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FilterFavoriteException
    extends Exception {
        public FilterFavoriteException(String msg) {
            super(msg);
        }
    }
}

