/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsRestrictions;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.web.element.Interface;
import org.opennms.web.element.NetworkElementFactoryInterface;
import org.opennms.web.element.Service;
import org.opennms.web.svclayer.model.AggregateStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class NetworkElementFactory
implements InitializingBean,
NetworkElementFactoryInterface {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monSvcDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private static final Comparator<Interface> INTERFACE_COMPARATOR = new InterfaceComparator();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public static NetworkElementFactoryInterface getInstance(ServletContext servletContext) {
        return NetworkElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static NetworkElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (NetworkElementFactoryInterface)appContext.getBean(NetworkElementFactoryInterface.class);
    }

    @Override
    public String getNodeLabel(int nodeId) {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.eq("id", (Object)nodeId);
        List nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return node.getLabel();
        }
        return null;
    }

    @Override
    public String getIpPrimaryAddress(int nodeId) {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsIpInterface.class);
        cb.and(new Restriction[]{new EqRestriction("node.id", (Object)nodeId), new EqRestriction("isSnmpPrimary", (Object)PrimaryType.PRIMARY)});
        List ifaces = this.m_ipInterfaceDao.findMatching(cb.toCriteria());
        if (ifaces.size() > 0) {
            OnmsIpInterface iface = (OnmsIpInterface)ifaces.get(0);
            return InetAddressUtils.str((InetAddress)iface.getIpAddress());
        }
        return null;
    }

    @Override
    public OnmsNode getNode(int nodeId) {
        return (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
    }

    @Override
    public OnmsNode getNode(String lookupCriteria) {
        return this.m_nodeDao.get(lookupCriteria);
    }

    @Override
    public List<OnmsNode> getAllNodes() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"type"), (Criterion)Restrictions.ne((String)"type", (Object)"D")));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesLike(String nodeLabel) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ilike((String)"label", (String)nodeLabel, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"type"), (Criterion)Restrictions.ne((String)"type", (Object)"D"))));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIpLike(String iplike) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class, "node");
        nodeCrit.createCriteria("ipInterfaces", "iface").add(OnmsRestrictions.ipLike((String)iplike)).add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.addOrder(Order.asc((String)"label"));
        nodeCrit.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getNodesWithService(int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("ipInterfaces", "iface");
        criteria.createAlias("iface.monitoredServices", "svc");
        criteria.createAlias("svc.serviceType", "svcType").add((Criterion)Restrictions.eq((String)"svcType.id", (Object)serviceId));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddr(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("snmpInterfaces", "snmpIfaces", 1);
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"snmpIfaces.physAddr", (String)macAddr.replaceAll("[:-]*", ""), (MatchMode)MatchMode.ANYWHERE));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddrAtInterface(String macAddr) {
        return this.getNodesWithPhysAddr(macAddr);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddrFromSnmpInterface(String macAddr) {
        return this.getNodesWithPhysAddr(macAddr);
    }

    @Override
    public List<OnmsNode> getNodesWithIfAlias(String ifAlias) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("snmpInterfaces", "snmpIface");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"snmpIface.ifAlias", (String)ifAlias, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public String getHostname(String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add(Restrictions.isNotNull((String)"ipHostName"));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        List ipIfaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ipIfaces.size() > 0) {
            OnmsIpInterface iface = (OnmsIpInterface)ipIfaces.get(0);
            return iface.getIpHostName();
        }
        return null;
    }

    @Override
    public Integer getIfIndex(int ipinterfaceid) {
        return this.getIfIndex((OnmsIpInterface)this.m_ipInterfaceDao.get((Serializable)Integer.valueOf(ipinterfaceid)));
    }

    @Override
    public Integer getIfIndex(int nodeID, String ipaddr) {
        return this.getIfIndex(this.m_ipInterfaceDao.get((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeID)), ipaddr));
    }

    private Integer getIfIndex(OnmsIpInterface ipinterface) {
        if (ipinterface != null && ipinterface.getIfIndex() != null) {
            return ipinterface.getIfIndex();
        }
        return -1;
    }

    @Override
    public Interface getInterface(int ipInterfaceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)ipInterfaceId));
        criteria.setFetchMode("snmpInterface", FetchMode.JOIN);
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ifaces.size() > 0) {
            return new Interface((OnmsIpInterface)ifaces.get(0));
        }
        return null;
    }

    @Override
    public Interface getInterface(int nodeId, String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.setFetchMode("snmpInterface", FetchMode.JOIN);
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        return ifaces.size() > 0 ? new Interface((OnmsIpInterface)ifaces.get(0)) : null;
    }

    @Override
    public Interface getInterface(int nodeId, String ipAddress, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add((Criterion)Restrictions.eq((String)"snmpIface.ifIndex", (Object)ifIndex));
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        return ifaces.size() > 0 ? new Interface((OnmsIpInterface)ifaces.get(0)) : null;
    }

    @Override
    public Interface getSnmpInterface(int nodeId, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        List snmpIfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (snmpIfaces.size() > 0) {
            return new Interface((OnmsSnmpInterface)snmpIfaces.get(0));
        }
        return null;
    }

    @Override
    public Interface[] getInterfacesWithIpAddress(String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getInterfacesWithIfAlias(int nodeId, String ifAlias) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.createAlias("node.assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add(Restrictions.ilike((String)"snmpIface.ifAlias", (String)ifAlias, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.createAlias("node.assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllSnmpInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.addOrder(Order.asc((String)"ifIndex"));
        return this.onmsSnmpInterfaces2InterfaceArray(this.m_snmpInterfaceDao.findMatching(criteria));
    }

    private Interface[] onmsSnmpInterfaces2InterfaceArray(List<OnmsSnmpInterface> snmpIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsSnmpInterface snmpIface : snmpIfaces) {
            intfs.add(new Interface(snmpIface));
        }
        return intfs.toArray(new Interface[intfs.size()]);
    }

    @Override
    public Interface[] getActiveInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllInterfaces() {
        return this.getAllInterfaces(true);
    }

    @Override
    public Interface[] getAllInterfaces(boolean includeSnmp) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        if (!includeSnmp) {
            return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
        }
        return this.getInterfaceArrayWithSnmpData(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllManagedIpInterfaces(boolean includeSNMP) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        criteria.add((Criterion)Restrictions.ne((String)"ipAddress", (Object)InetAddressUtils.addr((String)"0.0.0.0")));
        criteria.add(Restrictions.isNotNull((String)"ipAddress"));
        criteria.addOrder(Order.asc((String)"ipHostName"));
        criteria.addOrder(Order.asc((String)"node.id"));
        criteria.addOrder(Order.asc((String)"ipAddress"));
        if (!includeSNMP) {
            return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
        }
        return this.getInterfaceArrayWithSnmpData(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllManagedIpInterfacesLike(String ipHost) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"ipHostName", (String)ipHost, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"ipAddress", (String)ipHost, (MatchMode)MatchMode.ANYWHERE)));
        criteria.addOrder(Order.asc((String)"ipHostName"));
        criteria.addOrder(Order.asc((String)"node.id"));
        criteria.addOrder(Order.asc((String)"ipAddress"));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Service getService(int nodeId, String ipAddress, int serviceId) {
        try {
            OnmsMonitoredService monSvc = this.m_monSvcDao.get(Integer.valueOf(nodeId), InetAddress.getByName(ipAddress), Integer.valueOf(serviceId));
            return monSvc == null ? null : new Service(monSvc);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid ip address '" + ipAddress + "'", e);
        }
    }

    @Override
    public Service getService(int ifServiceId) {
        OnmsMonitoredService monSvc = (OnmsMonitoredService)this.m_monSvcDao.get((Serializable)Integer.valueOf(ifServiceId));
        return monSvc == null ? null : new Service(monSvc);
    }

    @Override
    public Service[] getAllServices() {
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findAll());
    }

    @Override
    public Service[] getServicesOnInterface(int nodeId, String ipAddress) {
        return this.getServicesOnInterface(nodeId, ipAddress, false);
    }

    @Override
    public Service[] getServicesOnInterface(int nodeId, String ipAddress, boolean includeDeletions) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        if (!includeDeletions) {
            criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        }
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    @Override
    public Service[] getServicesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.createAlias("ipInterface.node", "node");
        criteria.createAlias("serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    @Override
    public Service[] getServicesOnNode(int nodeId, int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.node", "node");
        criteria.createAlias("ipInterface.snmpInterface", "snmpInterface", 1);
        criteria.createAlias("serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    private static Service[] getServiceArray(List<OnmsMonitoredService> monSvcs) {
        LinkedList<Service> svcs = new LinkedList<Service>();
        for (OnmsMonitoredService monSvc : monSvcs) {
            Service service = new Service(monSvc);
            svcs.add(service);
        }
        return svcs.toArray(new Service[svcs.size()]);
    }

    @Override
    public String getServiceNameFromId(int serviceId) {
        OnmsServiceType type = (OnmsServiceType)this.m_serviceTypeDao.get((Serializable)Integer.valueOf(serviceId));
        return type == null ? null : type.getName();
    }

    @Override
    public int getServiceIdFromName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsServiceType type = this.m_serviceTypeDao.findByName(serviceName);
        return type == null ? -1 : type.getId();
    }

    @Override
    public Map<Integer, String> getServiceIdToNameMap() {
        HashMap<Integer, String> serviceMap = new HashMap<Integer, String>();
        for (OnmsServiceType type : this.m_serviceTypeDao.findAll()) {
            serviceMap.put(type.getId(), type.getName());
        }
        return serviceMap;
    }

    @Override
    public Map<String, Integer> getServiceNameToIdMap() {
        HashMap<String, Integer> serviceMap = new HashMap<String, Integer>();
        for (OnmsServiceType type : this.m_serviceTypeDao.findAll()) {
            serviceMap.put(type.getName(), type.getId());
        }
        return serviceMap;
    }

    @Override
    public List<OnmsNode> getNodesLikeAndIpLike(String nodeLabel, String iplike, int serviceId) {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createAlias("assetRecord", "assetRecord");
        nodeCrit.add(Restrictions.ilike((String)"label", (Object)nodeLabel));
        nodeCrit.createCriteria("ipInterfaces").add(OnmsRestrictions.ipLike((String)iplike)).createAlias("monitoredServices", "monSvcs").createAlias("monSvcs.serviceType", "serviceType").add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        nodeCrit.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getNodesLike(String nodeLabel, int serviceId) {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("ipInterfaces", "iface");
        criteria.createAlias("iface.monitoredServices", "monSvcs");
        criteria.createAlias("monSvcs.serviceType", "serviceType");
        criteria.add(Restrictions.ilike((String)"label", (String)nodeLabel, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIpLike(String iplike, int serviceId) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createAlias("assetRecord", "assetRecord");
        nodeCrit.createCriteria("ipInterfaces", "iface").createAlias("monitoredServices", "monSvcs").createAlias("monSvcs.serviceType", "serviceType").add(OnmsRestrictions.ipLike((String)iplike)).add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.addOrder(Order.asc((String)"label"));
        nodeCrit.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getAllNodes(int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("ipInterfaces", "ipInterfaces");
        criteria.createAlias("ipInterfaces.monitoredServices", "monSvcs");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add((Criterion)Restrictions.eq((String)"monSvcs.serviceType.id", (Object)serviceId));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesFromPhysaddr(String physAddr) {
        if (physAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("snmpInterfaces", "iface").ilike("iface.physAddr", (Object)physAddr.replaceAll("[:-]", "")).ne("type", (Object)OnmsNode.NodeType.DELETED).distinct();
        return this.m_nodeDao.findMatching(builder.toCriteria());
    }

    private Interface getInterfaceForLink(int nodeid, int ifindex) {
        Interface iface = null;
        if (ifindex > 0) {
            iface = this.getSnmpInterface(nodeid, ifindex);
            Criteria criteria = new Criteria(OnmsIpInterface.class).setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN), new Alias("snmpInterface", "snmpInterface", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeid)).addRestriction((Restriction)new EqRestriction("snmpInterface.ifIndex", (Object)ifindex));
            ArrayList<String> addresses = new ArrayList<String>();
            for (OnmsIpInterface onmsIpInterface : this.m_ipInterfaceDao.findMatching(criteria)) {
                addresses.add(onmsIpInterface.getIpAddress().getHostAddress());
            }
            if (addresses.size() > 0) {
                if (iface == null) {
                    iface = new Interface();
                    iface.m_nodeId = nodeid;
                    iface.m_ifIndex = ifindex;
                }
                iface.setIpaddresses(addresses);
            } else if (iface != null) {
                iface.setIpaddresses(addresses);
            }
        }
        return iface;
    }

    @Override
    public List<Integer> getNodeIdsWithIpLike(String iplike) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createCriteria("ipInterfaces", "iface").add(OnmsRestrictions.ipLike((String)iplike));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        List nodes = this.m_nodeDao.findMatching(nodeCrit);
        for (OnmsNode node : nodes) {
            nodeIds.add(node.getId());
        }
        return nodeIds;
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(String[] categories, boolean onlyNodesWithDownAggregateStatus) {
        List ourNodes = this.getNodesInCategories(categories);
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(new HashSet<OnmsNode>(ourNodes));
            ourNodes = as.getDownNodes();
        }
        return ourNodes;
    }

    private List<OnmsNode> getNodesInCategories(String[] categoryStrings) {
        ArrayList<OnmsCategory> categories = new ArrayList<OnmsCategory>();
        for (String categoryString : categoryStrings) {
            OnmsCategory category = this.m_categoryDao.findByName(categoryString);
            if (category == null) {
                throw new IllegalArgumentException("The Category " + categoryString + " does not exist");
            }
            categories.add(category);
        }
        return this.m_nodeDao.findAllByCategoryList(categories);
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(String[] categories1, String[] categories2, boolean onlyNodesWithDownAggregateStatus) {
        ArrayList<OnmsCategory> c1 = new ArrayList<OnmsCategory>(categories1.length);
        for (String category : categories1) {
            c1.add(this.m_categoryDao.findByName(category));
        }
        ArrayList<OnmsCategory> c2 = new ArrayList<OnmsCategory>(categories2.length);
        for (String category : categories2) {
            c2.add(this.m_categoryDao.findByName(category));
        }
        List<OnmsNode> ourNodes1 = this.getNodesInCategories(categories1);
        List<OnmsNode> ourNodes2 = this.getNodesInCategories(categories2);
        HashSet<Integer> n2id = new HashSet<Integer>(ourNodes2.size());
        for (OnmsNode onmsNode : ourNodes2) {
            n2id.add(onmsNode.getId());
        }
        List<Object> ourNodes = new ArrayList<OnmsNode>();
        for (OnmsNode n1 : ourNodes1) {
            if (!n2id.contains(n1.getId())) continue;
            ourNodes.add(n1);
        }
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus aggregateStatus = new AggregateStatus(ourNodes);
            ourNodes = aggregateStatus.getDownNodes();
        }
        return ourNodes;
    }

    private Interface[] getInterfaceArray(List<OnmsIpInterface> ipIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsIpInterface iface : ipIfaces) {
            intfs.add(new Interface(iface));
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    private Interface[] getInterfaceArrayWithSnmpData(List<OnmsIpInterface> ipIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsIpInterface iface : ipIfaces) {
            Interface intf = new Interface(iface);
            if (iface.getSnmpInterface() != null) {
                OnmsSnmpInterface snmpIface = iface.getSnmpInterface();
                intf.createSnmpInterface(snmpIface);
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    @Override
    public List<OnmsMonitoringLocation> getMonitoringLocations() {
        return this.m_monitoringLocationDao.findAll().stream().sorted((a, b) -> a.getLocationName().compareTo(b.getLocationName())).collect(Collectors.toList());
    }

    public static class InterfaceComparator
    implements Comparator<Interface> {
        @Override
        public int compare(Interface o1, Interface o2) {
            if (!"0.0.0.0".equals(o1.getIpAddress()) && !"0.0.0.0".equals(o2.getIpAddress())) {
                return new InetAddressComparator().compare(InetAddressUtils.addr((String)o1.getIpAddress()), InetAddressUtils.addr((String)o2.getIpAddress()));
            }
            if (!"0.0.0.0".equals(o1.getIpAddress())) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2.getIpAddress())) {
                return 1;
            }
            return 0;
        }
    }
}

