/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.trend;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.trend.TrendConfiguration;
import org.opennms.netmgt.config.trend.TrendDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class TrendController
extends AbstractController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(TrendController.class);
    private final File CONFIG_FILE = new File("etc/trend-configuration.xml");

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("trend/trend");
        TrendDefinition trendDefinition = this.getConfiguration().getTrendDefintionForName(request.getParameter("name"));
        if (trendDefinition != null) {
            List<Double> valuesList = this.lookupData(trendDefinition.getQuery());
            String valuesString = StringUtils.join(valuesList, (char)',');
            Map<String, String> replacements = this.variableReplacements(valuesList);
            trendDefinition.setTitle(this.replace(trendDefinition.getTitle(), replacements));
            trendDefinition.setSubtitle(this.replace(trendDefinition.getSubtitle(), replacements));
            trendDefinition.setDescription(this.replace(trendDefinition.getDescription(), replacements));
            modelAndView.addObject("trendDefinition", (Object)trendDefinition);
            modelAndView.addObject("trendValues", valuesList);
            modelAndView.addObject("trendValuesString", (Object)valuesString);
        } else {
            LOG.warn("trend definition is null for name '{}'", (Object)request.getParameter("name"));
        }
        return modelAndView;
    }

    private Map<String, String> variableReplacements(List<Double> values) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        DoubleSummaryStatistics doubleSummaryStatistics = values.stream().mapToDouble(Double::doubleValue).summaryStatistics();
        replacements.put("${doubleMax}", String.format("%.2f", doubleSummaryStatistics.getMax()));
        replacements.put("${intMax}", String.format("%d", (int)doubleSummaryStatistics.getMax()));
        replacements.put("${doubleMin}", String.format("%.2f", doubleSummaryStatistics.getMin()));
        replacements.put("${intMin}", String.format("%d", (int)doubleSummaryStatistics.getMin()));
        replacements.put("${doubleAvg}", String.format("%.2f", doubleSummaryStatistics.getAverage()));
        replacements.put("${intAvg}", String.format("%d", (int)doubleSummaryStatistics.getAverage()));
        replacements.put("${doubleSum}", String.format("%.2f", doubleSummaryStatistics.getSum()));
        replacements.put("${intSum}", String.format("%d", (int)doubleSummaryStatistics.getSum()));
        for (int i = 0; i < values.size(); ++i) {
            double current = values.get(i);
            replacements.put("${doubleValue[" + i + "]}", String.format("%.2f", current));
            replacements.put("${intValue[" + i + "]}", String.format("%d", (int)current));
            if (i > 0) {
                double previous = values.get(i - 1);
                double change = current - previous;
                replacements.put("${doubleValueChange[" + i + "]}", String.format("%+.2f", change));
                replacements.put("${intValueChange[" + i + "]}", String.format("%+d", (int)change));
                continue;
            }
            replacements.put("${doubleValueChange[" + i + "]}", "NaN");
            replacements.put("${intValueChange[" + i + "]}", "NaN");
        }
        if (values.size() > 0) {
            replacements.put("${doubleLastValueChange}", (String)replacements.get("${doubleValueChange[" + (values.size() - 1) + "]}"));
            replacements.put("${intLastValueChange}", (String)replacements.get("${intValueChange[" + (values.size() - 1) + "]}"));
            replacements.put("${doubleLastValue}", (String)replacements.get("${doubleValue[" + (values.size() - 1) + "]}"));
            replacements.put("${intLastValue}", (String)replacements.get("${intValue[" + (values.size() - 1) + "]}"));
        } else {
            replacements.put("${doubleLastValueChange}", "NaN");
            replacements.put("${intLastValueChange}", "NaN");
            replacements.put("${doubleLastValue}", "NaN");
            replacements.put("${intLastValue}", "NaN");
        }
        return replacements;
    }

    private String replace(String string, Map<String, String> replacements) {
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            string = string.replace(replacement.getKey(), replacement.getValue());
        }
        return string;
    }

    public TrendConfiguration getConfiguration() {
        return (TrendConfiguration)JAXB.unmarshal((File)this.CONFIG_FILE, TrendConfiguration.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> lookupData(String query) throws SQLException {
        ArrayList<Double> dataSet = new ArrayList<Double>();
        try (Connection connection = null;){
            connection = DataSourceFactory.getInstance().getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            while (resultSet.next()) {
                dataSet.add(resultSet.getDouble(1));
            }
            resultSet.close();
            statement.close();
        }
        return dataSet;
    }

    public void afterPropertiesSet() {
    }
}

