/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ElementIdNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 6002934081158722933L;
    protected String badId;
    protected String message;
    protected String elemType;
    protected String detailUri;
    protected String detailParam;
    protected String browseUri;

    public ElementIdNotFoundException(String msg, String id, String elemType, String detailUri, String detailParam, String browseUri) {
        this.message = msg;
        this.setBadId(id);
        this.elemType = elemType;
        this.detailUri = detailUri;
        this.detailParam = detailParam;
    }

    public ElementIdNotFoundException(String msg, String id, String elemType, String browseUri) {
        this.message = msg;
        this.setBadId(id);
        this.elemType = elemType;
        this.browseUri = browseUri;
        this.detailUri = null;
        this.detailParam = null;
    }

    public ElementIdNotFoundException(String msg, String id, String elemType) {
        this.message = msg;
        this.setBadId(id);
        this.elemType = elemType;
        this.browseUri = null;
        this.detailUri = null;
        this.detailParam = null;
    }

    private void setBadId(String idIn) {
        try {
            this.badId = URLEncoder.encode(idIn, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.badId = "";
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getBadID() {
        return this.badId;
    }

    public String getElemType() {
        return this.getElemType(false);
    }

    public String getElemType(boolean initialCap) {
        String result = initialCap ? this.elemType.substring(0, 1).toUpperCase() + this.elemType.substring(1) : this.elemType;
        return result;
    }

    public String getDetailUri() {
        return this.detailUri;
    }

    public String getDetailParam() {
        return this.detailParam;
    }

    public String getBrowseUri() {
        return this.browseUri;
    }
}

