/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.svclayer.api.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class CustomGraphChooseParentResourceController
extends AbstractController
implements InitializingBean {
    private ResourceService m_resourceService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("KSC/customGraphChooseResource");
        String selectedResourceId = request.getParameter(Parameters.selectedResourceId.toString());
        if (selectedResourceId != null) {
            OnmsResource selectedResource = this.m_resourceService.getResourceById(selectedResourceId);
            HashMap<String, OnmsResource> selectedResourceAndParents = new HashMap<String, OnmsResource>();
            for (OnmsResource r = selectedResource; r != null; r = r.getParent()) {
                selectedResourceAndParents.put(r.getId(), r);
            }
            modelAndView.addObject("selectedResourceAndParents", selectedResourceAndParents);
        }
        modelAndView.addObject("resources", (Object)this.getResourceService().findTopLevelResources());
        return modelAndView;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
    }

    public static enum Parameters {
        selectedResourceId;

    }
}

