/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.discovery.DiscoveryTaskExecutor;
import org.opennms.web.admin.discovery.GeneralSettingsLoader;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DiscoveryScanServlet
extends HttpServlet {
    private static final long serialVersionUID = 1018907997499737690L;
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryScanServlet.class);
    public static final String ATTRIBUTE_DISCOVERY_CONFIGURATION = DiscoveryScanServlet.class.getSimpleName() + "-discoveryConfiguration";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String specificIndex;
        String location;
        String retries;
        LOG.info("Loading Discovery configuration.");
        HttpSession sess = request.getSession(true);
        DiscoveryConfiguration config = (DiscoveryConfiguration)sess.getAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION);
        if (config == null) {
            config = new DiscoveryConfiguration();
        }
        config = GeneralSettingsLoader.load(request, config);
        String action = request.getParameter("action");
        LOG.debug("action: {}", (Object)action);
        if (action.equals("AddSpecific")) {
            LOG.debug("Adding Specific");
            String ipAddr = request.getParameter("specificipaddress");
            String timeout = request.getParameter("specifictimeout");
            retries = request.getParameter("specificretries");
            String foreignSource = request.getParameter("specificforeignsource");
            location = request.getParameter("specificlocation");
            Specific newSpecific = new Specific();
            newSpecific.setContent(ipAddr);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(String.valueOf(config.getTimeout()))) {
                newSpecific.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(String.valueOf(config.getRetries()))) {
                newSpecific.setRetries(WebSecurityUtils.safeParseInt((String)retries));
            }
            if (foreignSource != null && !"".equals(foreignSource.trim()) && !foreignSource.equals(config.getForeignSource())) {
                newSpecific.setForeignSource(foreignSource);
            }
            if (location != null && !"".equals(location.trim()) && !location.equals(config.getLocation())) {
                newSpecific.setLocation(location);
            }
            config.addSpecific(newSpecific);
        }
        if (action.equals("RemoveSpecific")) {
            LOG.debug("Removing Specific");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            Specific spec = config.getSpecific(index);
            boolean result = config.removeSpecific(spec);
            LOG.debug("Removing Specific result = {}", (Object)result);
        }
        if (action.equals("AddIncludeRange")) {
            LOG.debug("Adding Include Range");
            String ipAddrBase = request.getParameter("irbase");
            String ipAddrEnd = request.getParameter("irend");
            String timeout = request.getParameter("irtimeout");
            String retries2 = request.getParameter("irretries");
            String foreignSource = request.getParameter("irforeignsource");
            String location2 = request.getParameter("irlocation");
            IncludeRange newIR = new IncludeRange();
            newIR.setBegin(ipAddrBase);
            newIR.setEnd(ipAddrEnd);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(String.valueOf(config.getTimeout()))) {
                newIR.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries2 != null && !"".equals(retries2.trim()) && !retries2.equals(String.valueOf(config.getRetries()))) {
                newIR.setRetries(WebSecurityUtils.safeParseInt((String)retries2));
            }
            if (foreignSource != null && !"".equals(foreignSource.trim()) && !foreignSource.equals(config.getForeignSource())) {
                newIR.setForeignSource(foreignSource);
            }
            if (location2 != null && !"".equals(location2.trim()) && !location2.equals(config.getLocation())) {
                newIR.setLocation(location2);
            }
            config.addIncludeRange(newIR);
        }
        if (action.equals("RemoveIncludeRange")) {
            LOG.debug("Removing Include Range");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeRange ir = config.getIncludeRange(index);
            boolean result = config.removeIncludeRange(ir);
            LOG.debug("Removing Include Range result = {}", (Object)result);
        }
        if (action.equals("AddIncludeUrl")) {
            LOG.debug("Adding Include URL");
            String url = request.getParameter("iuurl");
            String timeout = request.getParameter("iutimeout");
            retries = request.getParameter("iuretries");
            String foreignSource = request.getParameter("iuforeignsource");
            location = request.getParameter("iulocation");
            IncludeUrl iu = new IncludeUrl();
            iu.setContent(url);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(String.valueOf(config.getTimeout()))) {
                iu.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(String.valueOf(config.getRetries()))) {
                iu.setRetries(WebSecurityUtils.safeParseInt((String)retries));
            }
            if (foreignSource != null && !"".equals(foreignSource.trim()) && !foreignSource.equals(config.getForeignSource())) {
                iu.setForeignSource(foreignSource);
            }
            if (location != null && !"".equals(location.trim()) && !location.equals(config.getLocation())) {
                iu.setLocation(location);
            }
            config.addIncludeUrl(iu);
        }
        if (action.equals("RemoveIncludeUrl")) {
            LOG.debug("Removing Include URL");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeUrl iu = config.getIncludeUrl(index);
            boolean result = config.removeIncludeUrl(iu);
            LOG.debug("Removing Include URL result = {}", (Object)result);
        }
        if (action.equals("AddExcludeRange")) {
            LOG.debug("Adding Exclude Range");
            String ipAddrBegin = request.getParameter("erbegin");
            String ipAddrEnd = request.getParameter("erend");
            ExcludeRange newER = new ExcludeRange();
            newER.setBegin(ipAddrBegin);
            newER.setEnd(ipAddrEnd);
            config.addExcludeRange(newER);
        }
        if (action.equals("RemoveExcludeRange")) {
            LOG.debug("Removing Exclude Range");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            ExcludeRange er = config.getExcludeRange(index);
            boolean result = config.removeExcludeRange(er);
            LOG.debug("Removing Exclude Range result = {}", (Object)result);
        }
        if (action.equals("SaveAndRestart")) {
            try {
                WebApplicationContext beanFactory = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
                ServiceRegistry registry = (ServiceRegistry)beanFactory.getBean(ServiceRegistry.class);
                DiscoveryTaskExecutor executor = (DiscoveryTaskExecutor)registry.findProvider(DiscoveryTaskExecutor.class);
                if (executor != null) {
                    executor.handleDiscoveryTask(config);
                } else {
                    LOG.warn("No DiscoveryTaskExecutor service is available");
                }
            }
            catch (Throwable ex) {
                LOG.error("Error while submitting task", ex);
                throw new ServletException(ex);
            }
            sess.removeAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION);
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)"admin/discovery/scan-done.jsp"));
            return;
        }
        sess.setAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION, (Object)config);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/discovery/edit-scan.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

