/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.api.Util;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageQueryParms;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.filter.ForeignSourceFilter;
import org.opennms.web.outage.filter.InterfaceFilter;
import org.opennms.web.outage.filter.LostServiceDateAfterFilter;
import org.opennms.web.outage.filter.LostServiceDateBeforeFilter;
import org.opennms.web.outage.filter.NegativeForeignSourceFilter;
import org.opennms.web.outage.filter.NegativeInterfaceFilter;
import org.opennms.web.outage.filter.NegativeNodeFilter;
import org.opennms.web.outage.filter.NegativeServiceFilter;
import org.opennms.web.outage.filter.NodeFilter;
import org.opennms.web.outage.filter.OutageIdFilter;
import org.opennms.web.outage.filter.RegainedServiceDateAfterFilter;
import org.opennms.web.outage.filter.RegainedServiceDateBeforeFilter;
import org.opennms.web.outage.filter.ServiceFilter;

public abstract class OutageUtil {
    protected static final String DOWN_COLOR = "red";
    public static final String FILTER_SERVLET_URL_BASE = "outage/list.htm";
    protected static final String[] LINK_IGNORES = new String[]{"sortby", "outtype", "limit", "multiple", "filter"};

    public static Filter getFilter(String filterString, ServletContext servletContext) {
        String value;
        String type;
        if (filterString == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OneArgFilter filter = null;
        StringTokenizer tokens = new StringTokenizer(filterString, "=");
        try {
            type = tokens.nextToken();
            value = tokens.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Could not tokenize filter string: " + filterString);
        }
        if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("foreignsource")) {
            filter = new ForeignSourceFilter(value);
        } else if (type.equals("intf")) {
            filter = new InterfaceFilter(value);
        } else if (type.equals("service")) {
            filter = new ServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("outage")) {
            filter = new OutageIdFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("foreignsourcenot")) {
            filter = new NegativeForeignSourceFilter(value);
        } else if (type.equals("nodenot")) {
            filter = new NegativeNodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("intfnot")) {
            filter = new NegativeInterfaceFilter(value);
        } else if (type.equals("servicenot")) {
            filter = new NegativeServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("lostbefore")) {
            filter = new LostServiceDateBeforeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("lostafter")) {
            filter = new LostServiceDateAfterFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("regainedbefore")) {
            filter = new RegainedServiceDateBeforeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("regainedafter")) {
            filter = new RegainedServiceDateAfterFilter(WebSecurityUtils.safeParseLong((String)value));
        }
        return filter;
    }

    public static String getFilterString(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return filter.getDescription();
    }

    public static String getStatusColor(Outage outage) {
        if (outage == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String color = null;
        if (outage.getRegainedServiceTime() == null) {
            color = DOWN_COLOR;
        }
        return color;
    }

    public static String getStatusLabel(Outage outage) {
        if (outage == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String label = null;
        if (outage.getRegainedServiceTime() == null) {
            label = "DOWN";
        }
        return label;
    }

    public static String makeLink(HttpServletRequest request, SortStyle sortStyle, OutageType outageType, List<Filter> filters, int limit) {
        if (request == null || sortStyle == null || outageType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (limit < 1) {
            throw new IllegalArgumentException("Cannot take a zero or negative limit value.");
        }
        HashMap<String, Object> additions = new HashMap<String, Object>();
        additions.put("sortby", sortStyle.getShortName());
        additions.put("outtype", outageType.getShortName());
        additions.put("limit", Integer.toString(limit));
        if (filters != null) {
            String[] filterStrings = new String[filters.size()];
            for (int i = 0; i < filters.size(); ++i) {
                filterStrings[i] = OutageUtil.getFilterString(filters.get(i));
            }
            additions.put("filter", filterStrings);
        }
        return "outage/list.htm?" + Util.makeQueryString((HttpServletRequest)request, additions, (String[])LINK_IGNORES, (Util.IgnoreType)Util.IgnoreType.REQUEST_ONLY);
    }

    public static String makeLink(HttpServletRequest request, OutageQueryParms parms) {
        if (request == null || parms == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeLink(request, parms.sortStyle, parms.outageType, parms.filters, parms.limit);
    }

    public static String makeLink(HttpServletRequest request, OutageQueryParms parms, SortStyle sortStyle) {
        if (request == null || parms == null || sortStyle == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeLink(request, sortStyle, parms.outageType, parms.filters, parms.limit);
    }

    public static String makeLink(HttpServletRequest request, OutageQueryParms parms, OutageType outageType) {
        if (request == null || parms == null || outageType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeLink(request, parms.sortStyle, outageType, parms.filters, parms.limit);
    }

    public static String makeLink(HttpServletRequest request, OutageQueryParms parms, List<Filter> filters) {
        if (request == null || parms == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeLink(request, parms.sortStyle, parms.outageType, filters, parms.limit);
    }

    public static String makeLink(HttpServletRequest request, OutageQueryParms parms, Filter filter, boolean add) {
        if (request == null || parms == null || filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<Filter> newList = new ArrayList<Filter>(parms.filters);
        if (add) {
            newList.add(filter);
        } else {
            newList.remove(filter);
        }
        return OutageUtil.makeLink(request, parms.sortStyle, parms.outageType, newList, parms.limit);
    }

    public static String makeHiddenTags(HttpServletRequest request, SortStyle sortStyle, OutageType outageType, List<Filter> filters, int limit) {
        if (request == null || sortStyle == null || outageType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (limit < 1) {
            throw new IllegalArgumentException("Cannot take a zero or negative limit value.");
        }
        HashMap<String, Object> additions = new HashMap<String, Object>();
        additions.put("sortby", sortStyle.getShortName());
        additions.put("outtype", outageType.getShortName());
        additions.put("limit", Integer.toString(limit));
        if (filters != null) {
            String[] filterStrings = new String[filters.size()];
            for (int i = 0; i < filters.size(); ++i) {
                filterStrings[i] = OutageUtil.getFilterString(filters.get(i));
            }
            additions.put("filter", filterStrings);
        }
        return Util.makeHiddenTags((HttpServletRequest)request, additions, (String[])LINK_IGNORES, (Util.IgnoreType)Util.IgnoreType.REQUEST_ONLY);
    }

    public static String makeHiddenTags(HttpServletRequest request, OutageQueryParms parms) {
        if (request == null || parms == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeHiddenTags(request, parms.sortStyle, parms.outageType, parms.filters, parms.limit);
    }

    public static String makeHiddenTags(HttpServletRequest request, OutageQueryParms parms, SortStyle sortStyle) {
        if (request == null || parms == null || sortStyle == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeHiddenTags(request, sortStyle, parms.outageType, parms.filters, parms.limit);
    }

    public static String makeHiddenTags(HttpServletRequest request, OutageQueryParms parms, OutageType outageType) {
        if (request == null || parms == null || outageType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeHiddenTags(request, parms.sortStyle, outageType, parms.filters, parms.limit);
    }

    public static String makeHiddenTags(HttpServletRequest request, OutageQueryParms parms, List<Filter> filters) {
        if (request == null || parms == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return OutageUtil.makeHiddenTags(request, parms.sortStyle, parms.outageType, filters, parms.limit);
    }

    public static String makeHiddenTags(HttpServletRequest request, OutageQueryParms parms, Filter filter, boolean add) {
        if (request == null || parms == null || filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<Filter> newList = new ArrayList<Filter>(parms.filters);
        if (add) {
            newList.add(filter);
        } else {
            newList.remove(filter);
        }
        return OutageUtil.makeHiddenTags(request, parms.sortStyle, parms.outageType, newList, parms.limit);
    }
}

