/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.notification.filter.AcknowledgedByFilter;
import org.opennms.web.notification.filter.InterfaceFilter;
import org.opennms.web.notification.filter.NegativeNodeFilter;
import org.opennms.web.notification.filter.NodeFilter;
import org.opennms.web.notification.filter.NotificationIdFilter;
import org.opennms.web.notification.filter.ResponderFilter;
import org.opennms.web.notification.filter.ServiceFilter;
import org.opennms.web.notification.filter.SeverityFilter;
import org.opennms.web.notification.filter.UserFilter;

public abstract class NoticeUtil {
    public static Filter getFilter(String filterString, ServletContext servletContext) {
        String value;
        OneArgFilter filter = null;
        StringTokenizer tokens = new StringTokenizer(filterString, "=");
        String type = tokens.nextToken();
        try {
            value = tokens.nextToken();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        if (type.equals("acknowledgeBy")) {
            filter = new AcknowledgedByFilter(value);
        } else if (type.equals("interface")) {
            filter = new InterfaceFilter(value);
        } else if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("nodenot")) {
            filter = new NegativeNodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("notificationIdFilter")) {
            filter = new NotificationIdFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("responder")) {
            filter = new ResponderFilter(value);
        } else if (type.equals("service")) {
            filter = new ServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("user")) {
            filter = new UserFilter(value);
        } else if (type.equals("severity")) {
            filter = new SeverityFilter(OnmsSeverity.get((String)value));
        }
        return filter;
    }
}

