/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.notification;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.DestinationPathFactory;
import org.opennms.netmgt.config.destinationPaths.Escalate;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.opennms.netmgt.config.destinationPaths.Target;
import org.opennms.web.api.Util;

public class DestinationWizardServlet
extends HttpServlet {
    private static final long serialVersionUID = 836611092234429387L;
    private String SESSION_ATTRIBUTE_NEW_PATH = "newPath";
    private String SESSION_ATTRIBUTE_OLD_PATH = "oldPath";
    private String SESSION_ATTRIBUTE_OLD_PATH_NAME = "oldName";
    private String SOURCE_PAGE_PATHS = "destinationPaths.jsp";
    private String SOURCE_PAGE_OUTLINE = "pathOutline.jsp";
    private String SOURCE_PAGE_TARGETS = "chooseTargets.jsp";
    private String SOURCE_PAGE_INTERVALS = "groupIntervals.jsp";
    private String SOURCE_PAGE_COMMANDS = "chooseCommands.jsp";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DestinationPathFactory.init();
        }
        catch (MarshalException e1) {
            throw new ServletException("Exception initializing DestinationPatchFactory " + e1.getMessage(), (Throwable)e1);
        }
        catch (ValidationException e1) {
            throw new ServletException("Exception initializing DestinationPatchFactory " + e1.getMessage(), (Throwable)e1);
        }
        catch (FileNotFoundException e1) {
            throw new ServletException("Exception initializing DestinationPatchFactory " + e1.getMessage(), (Throwable)e1);
        }
        catch (IOException e1) {
            throw new ServletException("Exception initializing DestinationPatchFactory " + e1.getMessage(), (Throwable)e1);
        }
        String sourcePage = request.getParameter("sourcePage");
        HttpSession user = request.getSession(true);
        StringBuffer redirectString = new StringBuffer();
        if (sourcePage.equals(this.SOURCE_PAGE_PATHS)) {
            String action = request.getParameter("userAction");
            if (action.equals("edit")) {
                try {
                    Path oldPath = DestinationPathFactory.getInstance().getPath(request.getParameter("paths"));
                    user.setAttribute(this.SESSION_ATTRIBUTE_OLD_PATH, (Object)oldPath);
                    user.setAttribute(this.SESSION_ATTRIBUTE_OLD_PATH_NAME, (Object)oldPath.getName());
                    Path newPath = DestinationWizardServlet.copyPath(oldPath);
                    user.setAttribute(this.SESSION_ATTRIBUTE_NEW_PATH, (Object)newPath);
                    redirectString.append(this.SOURCE_PAGE_OUTLINE);
                }
                catch (Throwable e) {
                    throw new ServletException("Couldn't get path to edit.", e);
                }
            } else if (action.equals("delete")) {
                try {
                    DestinationPathFactory.getInstance().removePath(request.getParameter("paths"));
                    redirectString.append(this.SOURCE_PAGE_PATHS);
                }
                catch (Throwable e) {
                    throw new ServletException("Couldn't save/reload destination path configuration file.", e);
                }
            } else if (action.equals("new")) {
                Path newPath = new Path();
                user.setAttribute(this.SESSION_ATTRIBUTE_NEW_PATH, (Object)newPath);
                user.removeAttribute(this.SESSION_ATTRIBUTE_OLD_PATH);
                user.removeAttribute(this.SESSION_ATTRIBUTE_OLD_PATH_NAME);
                redirectString.append(this.SOURCE_PAGE_OUTLINE);
            }
        } else if (sourcePage.equals(this.SOURCE_PAGE_OUTLINE)) {
            String action = request.getParameter("userAction");
            Path path = (Path)user.getAttribute(this.SESSION_ATTRIBUTE_NEW_PATH);
            if (path == null) {
                redirectString.append(this.SOURCE_PAGE_PATHS);
            } else {
                DestinationWizardServlet.saveOutlineForm(path, request);
                if (action.equals("add")) {
                    int index = WebSecurityUtils.safeParseInt((String)request.getParameter("index"));
                    Escalate newEscalate = new Escalate();
                    newEscalate.setDelay("0s");
                    path.addEscalate(index, newEscalate);
                    HashMap<String, String> requestParams = new HashMap<String, String>();
                    requestParams.put("targetIndex", request.getParameter("index"));
                    redirectString.append(this.SOURCE_PAGE_TARGETS).append(DestinationWizardServlet.makeQueryString(requestParams));
                } else if (action.equals("remove")) {
                    int index = WebSecurityUtils.safeParseInt((String)request.getParameter("index"));
                    DestinationWizardServlet.removeEscalation(path, index);
                    redirectString.append(this.SOURCE_PAGE_OUTLINE);
                } else if (action.equals("edit")) {
                    HashMap<String, String> requestParams = new HashMap<String, String>();
                    requestParams.put("targetIndex", request.getParameter("index"));
                    redirectString.append(this.SOURCE_PAGE_TARGETS).append(DestinationWizardServlet.makeQueryString(requestParams));
                } else if (action.equals("finish")) {
                    String oldName = (String)user.getAttribute(this.SESSION_ATTRIBUTE_OLD_PATH_NAME);
                    path.setName(request.getParameter("name"));
                    path.setInitialDelay(request.getParameter("initialDelay"));
                    try {
                        if (oldName != null && !oldName.equals(path.getName())) {
                            DestinationPathFactory.getInstance().replacePath(oldName, path);
                        } else {
                            DestinationPathFactory.getInstance().addPath(path);
                        }
                    }
                    catch (Throwable e) {
                        throw new ServletException("Couldn't save/reload destination path configuration file.", e);
                    }
                    user.removeAttribute(this.SESSION_ATTRIBUTE_OLD_PATH);
                    user.removeAttribute(this.SESSION_ATTRIBUTE_OLD_PATH_NAME);
                    redirectString.append(this.SOURCE_PAGE_PATHS);
                } else if (action.equals("cancel")) {
                    redirectString.append(this.SOURCE_PAGE_PATHS);
                }
            }
        } else if (sourcePage.equals(this.SOURCE_PAGE_TARGETS)) {
            int k;
            int j;
            Target target;
            String[] userTargets = request.getParameterValues("users");
            String[] groupTargets = request.getParameterValues("groups");
            String[] roleTargets = request.getParameterValues("roles");
            String[] emailTargets = request.getParameterValues("emails");
            Path newPath = (Path)user.getAttribute(this.SESSION_ATTRIBUTE_NEW_PATH);
            int index = WebSecurityUtils.safeParseInt((String)request.getParameter("targetIndex"));
            Target[] existingTargets = null;
            try {
                existingTargets = DestinationPathFactory.getInstance().getTargetList(index, newPath);
            }
            catch (Throwable e) {
                throw new ServletException("Unable to get targets for path " + newPath.getName(), e);
            }
            if (index == -1) {
                newPath.removeAllTarget();
            } else {
                newPath.getEscalate(index).removeAllTarget();
            }
            if (userTargets != null) {
                for (int i = 0; i < userTargets.length; ++i) {
                    target = new Target();
                    target.setName(userTargets[i]);
                    for (j = 0; j < existingTargets.length; ++j) {
                        if (!userTargets[i].equals(existingTargets[j].getName())) continue;
                        target = existingTargets[j];
                        break;
                    }
                    if (index == -1) {
                        newPath.addTarget(target);
                        continue;
                    }
                    newPath.getEscalate(index).addTarget(target);
                }
            }
            if (groupTargets != null) {
                for (k = 0; k < groupTargets.length; ++k) {
                    target = new Target();
                    target.setName(groupTargets[k]);
                    for (j = 0; j < existingTargets.length; ++j) {
                        if (!groupTargets[k].equals(existingTargets[j].getName())) continue;
                        target = existingTargets[j];
                        break;
                    }
                    if (index == -1) {
                        newPath.addTarget(target);
                        continue;
                    }
                    newPath.getEscalate(index).addTarget(target);
                }
            }
            if (roleTargets != null) {
                for (k = 0; k < roleTargets.length; ++k) {
                    target = new Target();
                    target.setName(roleTargets[k]);
                    for (j = 0; j < existingTargets.length; ++j) {
                        if (!roleTargets[k].equals(existingTargets[j].getName())) continue;
                        target = existingTargets[j];
                        break;
                    }
                    if (index == -1) {
                        newPath.addTarget(target);
                        continue;
                    }
                    newPath.getEscalate(index).addTarget(target);
                }
            }
            if (emailTargets != null) {
                for (int l = 0; l < emailTargets.length; ++l) {
                    target = new Target();
                    target.setName(emailTargets[l]);
                    target.addCommand("email");
                    for (int m = 0; m < existingTargets.length; ++m) {
                        if (!emailTargets[l].equals(existingTargets[m].getName())) continue;
                        target = existingTargets[m];
                        break;
                    }
                    if (index == -1) {
                        newPath.addTarget(target);
                        continue;
                    }
                    newPath.getEscalate(index).addTarget(target);
                }
            }
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put("targetIndex", request.getParameter("targetIndex"));
            String redirectPage = request.getParameter("nextPage");
            redirectString.append(redirectPage);
            if (redirectPage.equals(this.SOURCE_PAGE_INTERVALS)) {
                String[] ignores = new String[]{"sourcePage", "nextPage", "users"};
                redirectString.append("?").append(Util.makeQueryString((HttpServletRequest)request, (String[])ignores));
            } else {
                redirectString.append(DestinationWizardServlet.makeQueryString(requestParams));
            }
        } else if (sourcePage.equals(this.SOURCE_PAGE_INTERVALS)) {
            Path newPath = (Path)user.getAttribute(this.SESSION_ATTRIBUTE_NEW_PATH);
            int index = WebSecurityUtils.safeParseInt((String)request.getParameter("targetIndex"));
            Target[] targets = null;
            try {
                targets = DestinationPathFactory.getInstance().getTargetList(index, newPath);
            }
            catch (Throwable e) {
                throw new ServletException("Couldn't get target list for path " + newPath.getName(), e);
            }
            for (int i = 0; i < targets.length; ++i) {
                String name = targets[i].getName();
                if (request.getParameter(name + "Interval") == null) continue;
                targets[i].setInterval(request.getParameter(name + "Interval"));
            }
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put("targetIndex", request.getParameter("targetIndex"));
            redirectString.append(this.SOURCE_PAGE_COMMANDS).append(DestinationWizardServlet.makeQueryString(requestParams));
        } else if (sourcePage.equals(this.SOURCE_PAGE_COMMANDS)) {
            Path newPath = (Path)user.getAttribute(this.SESSION_ATTRIBUTE_NEW_PATH);
            int index = WebSecurityUtils.safeParseInt((String)request.getParameter("targetIndex"));
            Target[] targets = null;
            try {
                targets = DestinationPathFactory.getInstance().getTargetList(index, newPath);
            }
            catch (Throwable e) {
                throw new ServletException("Couldn't get target list for path " + newPath.getName(), e);
            }
            for (int i = 0; i < targets.length; ++i) {
                String[] autoNotify;
                String name = targets[i].getName();
                if (targets[i].getName().indexOf("@") == -1) {
                    targets[i].removeAllCommand();
                    String[] commands = request.getParameterValues(name + "Commands");
                    for (int j = 0; j < commands.length; ++j) {
                        targets[i].addCommand(commands[j]);
                    }
                }
                if ((autoNotify = request.getParameterValues(name + "AutoNotify"))[0] == null) {
                    autoNotify[0] = "auto";
                }
                targets[i].setAutoNotify(autoNotify[0]);
            }
            redirectString.append(this.SOURCE_PAGE_OUTLINE);
        }
        response.sendRedirect(redirectString.toString());
    }

    private static void saveOutlineForm(Path path, HttpServletRequest request) {
        path.setName(request.getParameter("name"));
        Escalate[] escalations = path.getEscalate();
        for (int i = 0; i < escalations.length; ++i) {
            escalations[i].setDelay(request.getParameter("escalate" + i + "Delay"));
        }
    }

    private static void removeEscalation(Path path, int index) {
        Escalate escalate = path.getEscalate(index);
        path.removeEscalate(escalate);
    }

    private static String makeQueryString(Map<String, String> map) {
        StringBuffer buffer = new StringBuffer();
        String separator = "?";
        for (String key : map.keySet()) {
            buffer.append(separator).append(key).append("=").append(Util.encode((String)map.get(key)));
            separator = "&";
        }
        return buffer.toString();
    }

    private static Path copyPath(Path oldPath) {
        Path newPath = new Path();
        newPath.setName(oldPath.getName());
        newPath.setInitialDelay(oldPath.getInitialDelay());
        List targets = oldPath.getTargetCollection();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            newPath.addTarget(DestinationWizardServlet.copyTarget((Target)it.next()));
        }
        List escalations = oldPath.getEscalateCollection();
        for (Escalate curEscalate : escalations) {
            Escalate newEscalate = new Escalate();
            newEscalate.setDelay(curEscalate.getDelay());
            List esTargets = curEscalate.getTargetCollection();
            Iterator iet = esTargets.iterator();
            while (iet.hasNext()) {
                newEscalate.addTarget(DestinationWizardServlet.copyTarget((Target)iet.next()));
            }
            newPath.addEscalate(newEscalate);
        }
        return newPath;
    }

    private static Target copyTarget(Target target) {
        Target newTarget = new Target();
        newTarget.setName(target.getName());
        newTarget.setInterval(target.getInterval());
        newTarget.setAutoNotify(target.getAutoNotify());
        for (int i = 0; i < target.getCommand().length; ++i) {
            newTarget.addCommand(target.getCommand()[i]);
        }
        return newTarget;
    }
}

