/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.presenter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.gwt.web.ui.asset.client.AssetPageConstants;
import org.opennms.gwt.web.ui.asset.client.AssetServiceAsync;
import org.opennms.gwt.web.ui.asset.client.event.SavedAssetEvent;
import org.opennms.gwt.web.ui.asset.client.presenter.Presenter;
import org.opennms.gwt.web.ui.asset.shared.AssetCommand;
import org.opennms.gwt.web.ui.asset.shared.AssetSuggCommand;

public class AssetPagePresenter
implements Presenter {
    private AssetPageConstants con = (AssetPageConstants)GWT.create(AssetPageConstants.class);
    private final AssetServiceAsync rpcService;
    private final HandlerManager eventBus;
    private final Display display;
    private AssetCommand asset;
    private int nodeId;

    public AssetPagePresenter(AssetServiceAsync rpcService, HandlerManager eventBus, Display view) {
        this.rpcService = rpcService;
        this.eventBus = eventBus;
        this.display = view;
        try {
            this.nodeId = Integer.parseInt(Window.Location.getParameter((String)"node"));
        }
        catch (NumberFormatException e) {
            GWT.log((String)(this.con.nodeParamNotValidInt() + Window.Location.getParameter((String)"node")), (Throwable)e);
            this.display.setError(this.con.nodeParamNotValidInt() + Window.Location.getParameter((String)"node"), e);
        }
    }

    public void bind() {
        this.display.getSaveButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AssetPagePresenter.this.display.isUiValid()) {
                    AssetPagePresenter.this.display.setInfo(AssetPagePresenter.this.con.infoAssetSaving() + AssetPagePresenter.this.nodeId);
                    AssetPagePresenter.this.saveAssetData();
                } else {
                    GWT.log((String)"isUiValid -> false; will not save.");
                    AssetPagePresenter.this.display.setError(AssetPagePresenter.this.con.assetPageNotValidDontSave(), null);
                }
            }
        });
        this.display.getResetButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssetPagePresenter.this.display.setInfo(AssetPagePresenter.this.con.infoAssetRestting() + AssetPagePresenter.this.nodeId);
                AssetPagePresenter.this.display.setData(AssetPagePresenter.this.asset);
                AssetPagePresenter.this.display.cleanUp();
                AssetPagePresenter.this.display.setInfo(AssetPagePresenter.this.con.infoAsset() + AssetPagePresenter.this.nodeId);
            }
        });
    }

    private void fetchAssetData() {
        this.rpcService.getAssetByNodeId(this.nodeId, new AsyncCallback<AssetCommand>(){

            public void onFailure(Throwable caught) {
                GWT.log((String)(AssetPagePresenter.this.con.errorFatchingAssetData() + AssetPagePresenter.this.nodeId), (Throwable)caught);
                AssetPagePresenter.this.display.setError(AssetPagePresenter.this.con.errorFatchingAssetData() + AssetPagePresenter.this.nodeId, caught);
            }

            public void onSuccess(AssetCommand result) {
                AssetPagePresenter.this.asset = result;
                AssetPagePresenter.this.display.setEnable(AssetPagePresenter.this.asset.getAllowModify());
                AssetPagePresenter.this.display.setData(AssetPagePresenter.this.asset);
                AssetPagePresenter.this.display.setInfo(AssetPagePresenter.this.con.infoAsset() + AssetPagePresenter.this.nodeId);
                AssetPagePresenter.this.display.cleanUp();
                AssetPagePresenter.this.fetchAssetSuggData();
            }
        });
    }

    private void fetchAssetSuggData() {
        this.rpcService.getAssetSuggestions(new AsyncCallback<AssetSuggCommand>(){

            public void onFailure(Throwable caught) {
                GWT.log((String)(AssetPagePresenter.this.con.errorFetchingAssetSuggData() + AssetPagePresenter.this.nodeId), (Throwable)caught);
                AssetPagePresenter.this.display.setError(AssetPagePresenter.this.con.errorFetchingAssetSuggData() + AssetPagePresenter.this.nodeId, caught);
            }

            public void onSuccess(AssetSuggCommand result) {
                AssetSuggCommand assetSugg = result;
                AssetPagePresenter.this.display.setDataSugg(assetSugg);
            }
        });
    }

    @Override
    public void go(HasWidgets container) {
        this.bind();
        container.clear();
        container.add(this.display.asWidget());
        this.display.setInfo(this.con.infoAssetLoging() + this.nodeId);
        this.fetchAssetData();
    }

    private void saveAssetData() {
        this.asset = this.display.getData();
        this.rpcService.saveOrUpdateAssetByNodeId(this.nodeId, this.asset, new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                GWT.log((String)(AssetPagePresenter.this.con.errorSavingAssetData() + AssetPagePresenter.this.nodeId), (Throwable)caught);
                AssetPagePresenter.this.display.setError(AssetPagePresenter.this.con.errorSavingAssetData() + AssetPagePresenter.this.nodeId, caught);
            }

            public void onSuccess(Boolean result) {
                AssetPagePresenter.this.eventBus.fireEvent((GwtEvent)new SavedAssetEvent(AssetPagePresenter.this.nodeId));
                AssetPagePresenter.this.display.setInfo(AssetPagePresenter.this.con.infoAssetSaved() + AssetPagePresenter.this.nodeId);
                AssetPagePresenter.this.display.cleanUp();
                AssetPagePresenter.this.fetchAssetData();
            }
        });
    }

    public static interface Display {
        public Widget asWidget();

        public void cleanUp();

        public AssetCommand getData();

        public HasClickHandlers getResetButton();

        public HasClickHandlers getSaveButton();

        public boolean isUiValid();

        public void setData(AssetCommand var1);

        public void setDataSugg(AssetSuggCommand var1);

        public void setEnable(Boolean var1);

        public void setError(String var1, Throwable var2);

        public void setInfo(String var1);
    }
}

