/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.notification.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationModel {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationModel.class);
    private static final String TXT_MESG = "textMsg";
    private static final String NUM_MESG = "numericMsg";
    private static final String NOTIFY = "notifyID";
    private static final String TIME = "pageTime";
    private static final String REPLYTIME = "respondTime";
    private static final String ANS_BY = "answeredBy";
    private static final String NODE = "nodeID";
    private static final String INTERFACE = "interfaceID";
    private static final String SERVICE = "serviceID";
    private static final String EVENTID = "eventid";
    private static final String SELECT = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS";

    public Notification[] allNotifications() throws SQLException {
        return this.allNotifications(null);
    }

    public Notification[] allNotifications(String order) throws SQLException {
        Notification[] notices = null;
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            String query = SELECT;
            if (order != null) {
                if (order.equalsIgnoreCase("asc")) {
                    query = query + " ORDER BY pagetime ASC";
                } else if (order.equalsIgnoreCase("desc")) {
                    query = query + " ORDER BY pagetime DESC";
                }
            }
            query = query + ";";
            ResultSet rs = stmt.executeQuery(query);
            d.watch((Object)rs);
            notices = NotificationModel.rs2NotifyBean(conn, rs);
        }
        catch (SQLException e) {
            LOG.error("allNotifications: Problem getting data from the notifications table: {}", (Object)e, (Object)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getServiceName(Connection conn, Integer id) {
        if (id == null) {
            return null;
        }
        String serviceName = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(NotificationModel.class);
        try {
            ps = conn.prepareStatement("SELECT servicename from service where serviceid = ?");
            d.watch((Object)ps);
            ps.setInt(1, id);
            rs = ps.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                serviceName = rs.getString("servicename");
            }
        }
        catch (SQLException e) {
            LOG.warn("unable to get service name for service ID '{}'", (Object)id, (Object)e);
        }
        finally {
            d.cleanUp();
        }
        return serviceName;
    }

    protected static Notification[] rs2NotifyBean(Connection conn, ResultSet rs) throws SQLException {
        Notification[] notices = null;
        Vector<Notification> vector = new Vector<Notification>();
        try {
            while (rs.next()) {
                Notification nbean = new Notification();
                nbean.m_timeReply = 0L;
                nbean.m_txtMsg = rs.getString(TXT_MESG);
                nbean.m_numMsg = rs.getString(NUM_MESG);
                nbean.m_notifyID = rs.getInt(NOTIFY);
                if (rs.getTimestamp(TIME) != null) {
                    nbean.m_timeSent = rs.getTimestamp(TIME).getTime();
                }
                if (rs.getTimestamp(REPLYTIME) != null) {
                    nbean.m_timeReply = rs.getTimestamp(REPLYTIME).getTime();
                }
                nbean.m_responder = rs.getString(ANS_BY);
                nbean.m_nodeID = rs.getInt(NODE);
                nbean.m_interfaceID = rs.getString(INTERFACE);
                nbean.m_serviceId = rs.getInt(SERVICE);
                nbean.m_eventId = rs.getInt(EVENTID);
                nbean.m_serviceName = NotificationModel.getServiceName(conn, nbean.m_serviceId);
                vector.addElement(nbean);
            }
        }
        catch (SQLException e) {
            LOG.error("Error occurred in rs2NotifyBean: {}", (Object)e, (Object)e);
            throw e;
        }
        notices = new Notification[vector.size()];
        for (int i = 0; i < notices.length; ++i) {
            notices[i] = (Notification)vector.elementAt(i);
        }
        return notices;
    }
}

