/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users.parsers;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.opennms.web.admin.users.parsers.DutySchedule;
import org.opennms.web.admin.users.parsers.NotificationInfo;

public class UserInfo
implements Cloneable {
    private String m_userId = "";
    private String m_fullName = "";
    private String m_userComments = "";
    private String m_password = "";
    private NotificationInfo m_notifInfo = new NotificationInfo();

    public Object clone() {
        UserInfo clone = new UserInfo();
        clone.setUserId(this.m_userId);
        clone.setFullName(this.m_fullName);
        clone.setUserComments(this.m_userComments);
        clone.setEncryptedPassword(this.m_password);
        NotificationInfo notifClone = new NotificationInfo();
        notifClone.setEmail(this.m_notifInfo.getEmail());
        notifClone.setNumericalService(this.m_notifInfo.getNumericalService());
        notifClone.setNumericalPin(this.m_notifInfo.getNumericalPin());
        notifClone.setTextService(this.m_notifInfo.getTextService());
        notifClone.setTextPin(this.m_notifInfo.getTextPin());
        List<DutySchedule> dutySchedules = this.m_notifInfo.getDutySchedules();
        for (DutySchedule dutySchedule : dutySchedules) {
            DutySchedule curDutySchedule = new DutySchedule(dutySchedule.toString());
            notifClone.addDutySchedule(curDutySchedule);
        }
        clone.setNotificationInfo(notifClone);
        return clone;
    }

    public NotificationInfo getNotificationInfo() {
        return this.m_notifInfo;
    }

    public void setNotificationInfo(NotificationInfo someInfo) {
        this.m_notifInfo = someInfo;
    }

    public void setUserId(String aUserId) {
        this.m_userId = aUserId;
    }

    public String getUserId() {
        return this.m_userId;
    }

    public void setFullName(String aFullName) {
        this.m_fullName = aFullName;
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public void setUserComments(String someUserComments) {
        this.m_userComments = someUserComments;
    }

    public String getUserComments() {
        return this.m_userComments;
    }

    public void setEncryptedPassword(String aPassword) {
        this.m_password = aPassword;
    }

    public void setUnencryptedPassword(String aPassword) throws IllegalStateException {
        this.m_password = UserInfo.encryptPassword(aPassword);
    }

    public static String encryptPassword(String aPassword) throws IllegalStateException {
        String encryptedPassword = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            encryptedPassword = UserInfo.hexToString(digest.digest(aPassword.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.toString());
        }
        return encryptedPassword;
    }

    private static String hexToString(byte[] data) {
        char[] hexadecimals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (data.length % 2 != 0) {
            return null;
        }
        char[] buffer = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int low = data[i] & 0xF;
            int high = (data[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimals[high];
            buffer[i * 2 + 1] = hexadecimals[low];
        }
        return new String(buffer);
    }

    public boolean comparePasswords(String aPassword) {
        return this.m_password.equals(UserInfo.encryptPassword(aPassword));
    }

    public String getPassword() {
        return this.m_password;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("user id           = " + this.m_userId + "\n");
        buffer.append("full name         = " + this.m_fullName + "\n");
        buffer.append("user comments     = " + this.m_userComments + "\n");
        buffer.append("password          = " + this.m_password + "\n");
        buffer.append(this.m_notifInfo.toString());
        return buffer.toString();
    }
}

