/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.distributed;

import org.opennms.web.svclayer.DistributedPollerService;
import org.opennms.web.svclayer.model.LocationMonitorIdCommand;
import org.opennms.web.validator.LocationMonitorIdValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/admin/distributed/locationMonitorPause.htm"})
public class LocationMonitorPauseController {
    @Autowired
    private DistributedPollerService m_distributedPollerService;
    @Autowired
    private LocationMonitorIdValidator m_validator;
    private static final String SUCCESS_VIEW = "redirect:/distributed/locationMonitorList.htm";
    private static final String ERROR_VIEW = "distributed/error";

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String handle(@ModelAttribute(value="command") LocationMonitorIdCommand cmd, BindingResult errors) {
        this.m_validator.validate(cmd, (Errors)errors);
        if (!errors.hasErrors()) {
            this.m_distributedPollerService.pauseLocationMonitor(cmd, errors);
        }
        if (errors.hasErrors()) {
            return ERROR_VIEW;
        }
        return SUCCESS_VIEW;
    }
}

