/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotEmpty;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.web.svclayer.ManualProvisioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/editProvisioningGroup.htm"})
@SessionAttributes(value={"freeFormEditing"})
public class EditProvisioningGroupController {
    private static final Logger LOG = LoggerFactory.getLogger(EditProvisioningGroupController.class);
    public static final String COMMAND_NAME = "nodeEditForm";
    @Autowired
    private ManualProvisioningService m_provisioningService;

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView onSubmit(@ModelAttribute(value="nodeEditForm") @Valid TreeCommand treeCmd, BindingResult errors, HttpSession session) {
        if (errors.hasErrors()) {
            return new ModelAndView("/admin/editProvisioningGroup", COMMAND_NAME, (Object)treeCmd);
        }
        String action = treeCmd.getAction();
        if (action != null) {
            if ("toggleFreeForm".equalsIgnoreCase(action)) {
                Boolean isFreeForm = (Boolean)session.getAttribute("freeFormEditing");
                if (isFreeForm == null) {
                    isFreeForm = false;
                }
                session.setAttribute("freeFormEditing", (Object)(isFreeForm == false ? 1 : 0));
            } else if ("addNode".equalsIgnoreCase(action)) {
                this.doAddNode(treeCmd);
            } else if ("addInterface".equalsIgnoreCase(action)) {
                this.doAddInterface(treeCmd);
            } else if ("addService".equalsIgnoreCase(action)) {
                this.doAddService(treeCmd);
            } else if ("addCategory".equalsIgnoreCase(action)) {
                this.doAddCategory(treeCmd);
            } else if ("addAssetField".equalsIgnoreCase(action)) {
                this.doAddAssetField(treeCmd);
            } else if ("save".equalsIgnoreCase(action)) {
                this.doSave(treeCmd, errors);
            } else if ("edit".equalsIgnoreCase(action)) {
                this.doEdit(treeCmd);
            } else if ("cancel".equalsIgnoreCase(action)) {
                this.doCancel(treeCmd);
            } else if ("delete".equalsIgnoreCase(action)) {
                this.doDelete(treeCmd);
            } else if ("import".equalsIgnoreCase(action)) {
                this.doImport(treeCmd);
            } else {
                if ("done".equalsIgnoreCase(action)) {
                    return this.done(treeCmd);
                }
                errors.reject("Unrecognized action: " + action);
            }
        }
        return new ModelAndView("/admin/editProvisioningGroup", COMMAND_NAME, (Object)treeCmd);
    }

    private ModelAndView done(TreeCommand treeCmd) {
        return new ModelAndView("redirect:/admin/provisioningGroups.htm");
    }

    private void doCancel(TreeCommand treeCmd) {
        Requisition formData = this.m_provisioningService.getProvisioningGroup(treeCmd.getGroupName());
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode("");
    }

    private void doImport(TreeCommand treeCmd) {
        this.m_provisioningService.importProvisioningGroup(treeCmd.getGroupName());
    }

    private void doDelete(TreeCommand treeCmd) {
        Requisition formData = this.m_provisioningService.deletePath(treeCmd.getGroupName(), treeCmd.getDataPath());
        treeCmd.setFormData(formData);
    }

    private void doAddCategory(TreeCommand treeCmd) {
        Requisition formData = this.m_provisioningService.addCategoryToNode(treeCmd.getGroupName(), treeCmd.getDataPath(), "New Category");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".category[0]");
    }

    private void doAddAssetField(TreeCommand treeCmd) {
        Requisition formData = this.m_provisioningService.addAssetFieldToNode(treeCmd.getGroupName(), treeCmd.getDataPath(), "key", "value");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".asset[0]");
    }

    private void doEdit(TreeCommand treeCmd) {
        treeCmd.setCurrentNode(treeCmd.getFormPath());
    }

    private void doSave(TreeCommand treeCmd, BindingResult errors) {
        try {
            LOG.debug("treeCmd = {}", (Object)treeCmd);
            treeCmd.getFormData().validate();
            Requisition formData = this.m_provisioningService.saveProvisioningGroup(treeCmd.getGroupName(), treeCmd.getFormData());
            treeCmd.setFormData(formData);
            treeCmd.setCurrentNode("");
        }
        catch (Throwable t) {
            errors.reject(t.getMessage());
        }
    }

    private void doAddService(TreeCommand treeCmd) {
        Requisition formData = this.m_provisioningService.addServiceToInterface(treeCmd.getGroupName(), treeCmd.getDataPath(), "SVC");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".monitoredService[0]");
    }

    private void doAddInterface(TreeCommand treeCmd) {
        Requisition formData = this.m_provisioningService.addInterfaceToNode(treeCmd.getGroupName(), treeCmd.getDataPath(), "");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".interface[0]");
    }

    private void doAddNode(TreeCommand treeCmd) {
        treeCmd.setFormData(this.m_provisioningService.addNewNodeToGroup(treeCmd.getGroupName(), "New Node"));
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".node[0]");
    }

    @ModelAttribute(value="nodeEditForm")
    private TreeCommand formBackingObject(@RequestParam String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("groupName required");
        }
        TreeCommand formCommand = new TreeCommand();
        Requisition formData = this.m_provisioningService.getProvisioningGroup(groupName);
        if (formData == null) {
            formData = this.m_provisioningService.createProvisioningGroup(groupName);
        }
        formCommand.setFormData(formData);
        return formCommand;
    }

    @ModelAttribute
    private void referenceData(ModelMap map, @RequestParam String groupName) {
        ArrayList<String> choices = new ArrayList<String>();
        for (PrimaryType type : PrimaryType.getAllTypes()) {
            choices.add(type.getCode());
        }
        map.put((Object)"snmpPrimaryChoices", choices);
        ArrayList<String> status = new ArrayList<String>();
        status.add("1");
        status.add("3");
        map.put((Object)"statusChoices", status);
        ArrayList services = new ArrayList(this.m_provisioningService.getServiceTypeNames(groupName));
        Collections.sort(services);
        map.put((Object)"services", services);
        ArrayList categories = new ArrayList(this.m_provisioningService.getNodeCategoryNames());
        Collections.sort(categories);
        map.put((Object)"categories", categories);
        ArrayList assetFields = new ArrayList(this.m_provisioningService.getAssetFieldNames());
        Collections.sort(assetFields);
        map.put((Object)"assetFields", assetFields);
    }

    public static class TreeCommand {
        private String m_formPath;
        private String m_action;
        @Valid
        private Requisition m_formData;
        @NotNull
        private String m_currentNode;
        @NotEmpty
        private String m_groupName = "hardcoded";

        public String getAction() {
            return this.m_action;
        }

        public void setAction(String action) {
            this.m_action = action;
        }

        public String getGroupName() {
            return this.m_groupName;
        }

        public void setGroupName(String groupName) {
            this.m_groupName = groupName;
        }

        public Requisition getFormData() {
            return this.m_formData;
        }

        public void setFormData(Requisition importData) {
            this.m_formData = importData;
        }

        public String getFormPath() {
            return this.m_formPath;
        }

        public void setFormPath(String target) {
            this.m_formPath = target;
        }

        public String getCurrentNode() {
            return this.m_currentNode;
        }

        public void setCurrentNode(String node) {
            this.m_currentNode = node;
        }

        public String getDataPath() {
            return this.m_formPath.substring("nodeEditForm.formData.".length());
        }

        public void setDataPath(String path) {
            this.m_formPath = "nodeEditForm.formData." + path;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("action", (Object)this.getAction()).append("currentNode", (Object)this.getCurrentNode()).append("dataPath", (Object)this.getDataPath()).append("formData", (Object)this.getFormData()).append("formPath", (Object)this.getFormPath()).append("groupName", (Object)this.getGroupName()).toString();
        }
    }
}

