/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.Panel;
import org.opennms.gwt.web.ui.asset.client.AssetPageConstants;
import org.opennms.gwt.web.ui.asset.client.presenter.AssetPagePresenter;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetDateBox;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetListBox;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetPasswordBox;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetSuggestBox;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetTextArea;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetTextBox;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSetTextDisplay;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringAsIntegerValidator;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringBasicValidator;
import org.opennms.gwt.web.ui.asset.shared.AssetCommand;
import org.opennms.gwt.web.ui.asset.shared.AssetSuggCommand;

public class AssetNodePageImpl
extends Composite
implements AssetPagePresenter.Display {
    private static AssetNodePageUiBinder uiBinder = (AssetNodePageUiBinder)GWT.create(AssetNodePageUiBinder.class);
    private AssetPageConstants con = (AssetPageConstants)GWT.create(AssetPageConstants.class);
    AssetCommand m_asset;
    @UiField
    Heading nodeInfoLabel;
    @UiField
    Anchor nodeInfoLink;
    @UiField
    FlowPanel mainPanel;
    @UiField
    Heading lInfoTop;
    @UiField
    Heading lInfoBottom;
    @UiField
    Panel snmpDiscPanel;
    @UiField
    FieldSetTextDisplay sSystemId;
    @UiField
    FieldSetTextDisplay sSystemName;
    @UiField
    FieldSetTextDisplay sSystemLocation;
    @UiField
    FieldSetTextDisplay sSystemContact;
    @UiField
    FieldSetTextDisplay sSystemDescription;
    @UiField
    FieldSetSuggestBox sDisplayCat;
    @UiField
    FieldSetSuggestBox sNotificationCat;
    @UiField
    FieldSetSuggestBox sPollerCat;
    @UiField
    FieldSetSuggestBox sThresholdCat;
    @UiField
    FieldSetSuggestBox sDescription;
    @UiField
    FieldSetSuggestBox sAssetCategory;
    @UiField
    FieldSetSuggestBox sManufacturer;
    @UiField
    FieldSetSuggestBox sModelNumber;
    @UiField
    FieldSetTextBox sSerialNumber;
    @UiField
    FieldSetTextBox sAssetNumber;
    @UiField
    FieldSetSuggestBox sOperatingSystem;
    @UiField
    FieldSetDateBox sDateInstalled;
    @UiField
    FieldSetSuggestBox sRegion;
    @UiField
    FieldSetSuggestBox sDivision;
    @UiField
    FieldSetSuggestBox sDepartment;
    @UiField
    FieldSetSuggestBox sAddress1;
    @UiField
    FieldSetSuggestBox sAddress2;
    @UiField
    FieldSetSuggestBox sCity;
    @UiField
    FieldSetSuggestBox sState;
    @UiField
    FieldSetSuggestBox sZip;
    @UiField
    FieldSetSuggestBox sCountry;
    @UiField
    FieldSetTextBox sLongitude;
    @UiField
    FieldSetTextBox sLatitude;
    @UiField
    FieldSetSuggestBox sBuilding;
    @UiField
    FieldSetSuggestBox sFloor;
    @UiField
    FieldSetSuggestBox sRoom;
    @UiField
    FieldSetSuggestBox sRack;
    @UiField
    FieldSetTextBox sSlot;
    @UiField
    FieldSetTextBox sRackUnitHight;
    @UiField
    FieldSetTextBox sPort;
    @UiField
    FieldSetSuggestBox sCircuitId;
    @UiField
    FieldSetSuggestBox sAdmin;
    @UiField
    FieldSetSuggestBox sVendorName;
    @UiField
    FieldSetSuggestBox sPhone;
    @UiField
    FieldSetSuggestBox sFax;
    @UiField
    FieldSetSuggestBox sLease;
    @UiField
    FieldSetDateBox sLeaseExpires;
    @UiField
    FieldSetTextBox sVendorAsset;
    @UiField
    FieldSetSuggestBox sMaintContract;
    @UiField
    FieldSetDateBox sContractExpires;
    @UiField
    FieldSetSuggestBox sMaintPhone;
    @UiField
    FieldSetTextBox sUserName;
    @UiField
    FieldSetPasswordBox sPassword;
    @UiField
    FieldSetPasswordBox sEnablePassword;
    @UiField
    FieldSetListBox sConnection;
    @UiField
    FieldSetListBox sAutoEnable;
    @UiField
    FieldSetSuggestBox sSnmpcommunity;
    @UiField
    FieldSetSuggestBox sCpu;
    @UiField
    FieldSetSuggestBox sRam;
    @UiField
    FieldSetSuggestBox sStoragectrl;
    @UiField
    FieldSetSuggestBox sAdditionalhardware;
    @UiField
    FieldSetSuggestBox sNumpowersupplies;
    @UiField
    FieldSetSuggestBox sInputpower;
    @UiField
    FieldSetSuggestBox sHdd1;
    @UiField
    FieldSetSuggestBox sHdd2;
    @UiField
    FieldSetSuggestBox sHdd3;
    @UiField
    FieldSetSuggestBox sHdd4;
    @UiField
    FieldSetSuggestBox sHdd5;
    @UiField
    FieldSetSuggestBox sHdd6;
    @UiField
    FieldSetSuggestBox sVmwareManagedObjectId;
    @UiField
    FieldSetSuggestBox sVmwareManagedEntityType;
    @UiField
    FieldSetSuggestBox sVmwareManagementServer;
    @UiField
    FieldSetSuggestBox sVmwareTopologyInfo;
    @UiField
    FieldSetSuggestBox sVmwareState;
    @UiField
    FieldSetTextArea sComment;
    @UiField
    Button saveButton;
    @UiField
    Button resetButton;
    @UiField
    Modal errorModal;
    @UiField
    HTML errorModalHtml;
    @UiField
    Label lastModified;
    private List<FieldSet> fieldSetList = new ArrayList<FieldSet>();

    public AssetNodePageImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.sDisplayCat.addWarningValidator(new StringBasicValidator());
        this.sNotificationCat.addWarningValidator(new StringBasicValidator());
        this.sThresholdCat.addWarningValidator(new StringBasicValidator());
        this.sPollerCat.addWarningValidator(new StringBasicValidator());
        this.sAssetCategory.addWarningValidator(new StringBasicValidator());
        this.sRackUnitHight.addErrorValidator(new StringAsIntegerValidator());
        this.sNumpowersupplies.addErrorValidator(new StringAsIntegerValidator());
        this.sInputpower.addErrorValidator(new StringAsIntegerValidator());
        this.initUiElementList();
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    @Override
    public void cleanUp() {
        for (FieldSet fs : this.fieldSetList) {
            fs.clearChanged();
        }
    }

    @Override
    public AssetCommand getData() {
        this.saveDataConfigCategories();
        this.saveDataIdentification();
        this.saveDataLocation();
        this.saveDataVendor();
        this.saveDataAuthentication();
        this.saveDataHardware();
        this.saveDataComments();
        this.saveDataVmware();
        return this.m_asset;
    }

    @Override
    public HasClickHandlers getResetButton() {
        return this.resetButton;
    }

    @Override
    public HasClickHandlers getSaveButton() {
        return this.saveButton;
    }

    private void initUiElementList() {
        this.fieldSetList.add(this.sSystemId);
        this.fieldSetList.add(this.sSystemName);
        this.fieldSetList.add(this.sSystemLocation);
        this.fieldSetList.add(this.sSystemContact);
        this.fieldSetList.add(this.sSystemDescription);
        this.fieldSetList.add(this.sDisplayCat);
        this.fieldSetList.add(this.sNotificationCat);
        this.fieldSetList.add(this.sPollerCat);
        this.fieldSetList.add(this.sThresholdCat);
        this.fieldSetList.add(this.sDescription);
        this.fieldSetList.add(this.sAssetCategory);
        this.fieldSetList.add(this.sManufacturer);
        this.fieldSetList.add(this.sModelNumber);
        this.fieldSetList.add(this.sSerialNumber);
        this.fieldSetList.add(this.sAssetNumber);
        this.fieldSetList.add(this.sDateInstalled);
        this.fieldSetList.add(this.sOperatingSystem);
        this.fieldSetList.add(this.sRegion);
        this.fieldSetList.add(this.sDivision);
        this.fieldSetList.add(this.sDepartment);
        this.fieldSetList.add(this.sAddress1);
        this.fieldSetList.add(this.sAddress2);
        this.fieldSetList.add(this.sCity);
        this.fieldSetList.add(this.sState);
        this.fieldSetList.add(this.sZip);
        this.fieldSetList.add(this.sCountry);
        this.fieldSetList.add(this.sLongitude);
        this.fieldSetList.add(this.sLatitude);
        this.fieldSetList.add(this.sBuilding);
        this.fieldSetList.add(this.sFloor);
        this.fieldSetList.add(this.sRoom);
        this.fieldSetList.add(this.sRack);
        this.fieldSetList.add(this.sSlot);
        this.fieldSetList.add(this.sRackUnitHight);
        this.fieldSetList.add(this.sPort);
        this.fieldSetList.add(this.sCircuitId);
        this.fieldSetList.add(this.sAdmin);
        this.fieldSetList.add(this.sVendorName);
        this.fieldSetList.add(this.sPhone);
        this.fieldSetList.add(this.sFax);
        this.fieldSetList.add(this.sLease);
        this.fieldSetList.add(this.sLeaseExpires);
        this.fieldSetList.add(this.sVendorAsset);
        this.fieldSetList.add(this.sMaintContract);
        this.fieldSetList.add(this.sContractExpires);
        this.fieldSetList.add(this.sMaintPhone);
        this.fieldSetList.add(this.sUserName);
        this.fieldSetList.add(this.sPassword);
        this.fieldSetList.add(this.sEnablePassword);
        this.fieldSetList.add(this.sConnection);
        this.fieldSetList.add(this.sAutoEnable);
        this.fieldSetList.add(this.sSnmpcommunity);
        this.fieldSetList.add(this.sCpu);
        this.fieldSetList.add(this.sRam);
        this.fieldSetList.add(this.sAdditionalhardware);
        this.fieldSetList.add(this.sInputpower);
        this.fieldSetList.add(this.sNumpowersupplies);
        this.fieldSetList.add(this.sStoragectrl);
        this.fieldSetList.add(this.sHdd1);
        this.fieldSetList.add(this.sHdd2);
        this.fieldSetList.add(this.sHdd3);
        this.fieldSetList.add(this.sHdd4);
        this.fieldSetList.add(this.sHdd5);
        this.fieldSetList.add(this.sHdd6);
        this.fieldSetList.add(this.sVmwareManagedObjectId);
        this.fieldSetList.add(this.sVmwareManagedEntityType);
        this.fieldSetList.add(this.sVmwareManagementServer);
        this.fieldSetList.add(this.sVmwareTopologyInfo);
        this.fieldSetList.add(this.sVmwareState);
        this.fieldSetList.add(this.sComment);
    }

    @Override
    public boolean isUiValid() {
        for (FieldSet fs : this.fieldSetList) {
            if (fs.getError().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void saveDataAuthentication() {
        this.m_asset.setUsername(this.sUserName.getValue());
        this.m_asset.setPassword(this.sPassword.getValue());
        this.m_asset.setEnable(this.sEnablePassword.getValue());
        this.m_asset.setConnection(this.sConnection.getValue());
        this.m_asset.setAutoenable(this.sAutoEnable.getValue());
        this.m_asset.setSnmpcommunity(this.sSnmpcommunity.getValue());
    }

    private void saveDataComments() {
        this.m_asset.setComment(this.sComment.getValue());
    }

    private void saveDataConfigCategories() {
        this.m_asset.setDisplayCategory(this.sDisplayCat.getValue());
        this.m_asset.setNotifyCategory(this.sNotificationCat.getValue());
        this.m_asset.setPollerCategory(this.sPollerCat.getValue());
        this.m_asset.setThresholdCategory(this.sThresholdCat.getValue());
    }

    private void saveDataHardware() {
        this.m_asset.setCpu(this.sCpu.getValue());
        this.m_asset.setRam(this.sRam.getValue());
        this.m_asset.setStoragectrl(this.sStoragectrl.getValue());
        this.m_asset.setAdditionalhardware(this.sAdditionalhardware.getValue());
        this.m_asset.setNumpowersupplies(this.sNumpowersupplies.getValue());
        this.m_asset.setInputpower(this.sInputpower.getValue());
        this.m_asset.setHdd1(this.sHdd1.getValue());
        this.m_asset.setHdd2(this.sHdd2.getValue());
        this.m_asset.setHdd3(this.sHdd3.getValue());
        this.m_asset.setHdd4(this.sHdd4.getValue());
        this.m_asset.setHdd5(this.sHdd5.getValue());
        this.m_asset.setHdd6(this.sHdd6.getValue());
    }

    private void saveDataIdentification() {
        this.m_asset.setDescription(this.sDescription.getValue());
        this.m_asset.setCategory(this.sAssetCategory.getValue());
        this.m_asset.setManufacturer(this.sManufacturer.getValue());
        this.m_asset.setModelNumber(this.sModelNumber.getValue());
        this.m_asset.setSerialNumber(this.sSerialNumber.getValue());
        this.m_asset.setAssetNumber(this.sAssetNumber.getValue());
        this.m_asset.setOperatingSystem(this.sOperatingSystem.getValue());
        this.m_asset.setDateInstalled(this.sDateInstalled.getValue());
    }

    private void saveDataLocation() {
        this.m_asset.setRegion(this.sRegion.getValue());
        this.m_asset.setDivision(this.sDivision.getValue());
        this.m_asset.setDepartment(this.sDepartment.getValue());
        this.m_asset.setAddress1(this.sAddress1.getValue());
        this.m_asset.setAddress2(this.sAddress2.getValue());
        this.m_asset.setCity(this.sCity.getValue());
        this.m_asset.setState(this.sState.getValue());
        this.m_asset.setZip(this.sZip.getValue());
        this.m_asset.setCountry(this.sCountry.getValue());
        this.m_asset.setLongitude(this.s2f(this.sLongitude.getValue()));
        this.m_asset.setLatitude(this.s2f(this.sLatitude.getValue()));
        this.m_asset.setBuilding(this.sBuilding.getValue());
        this.m_asset.setFloor(this.sFloor.getValue());
        this.m_asset.setRoom(this.sRoom.getValue());
        this.m_asset.setRack(this.sRack.getValue());
        this.m_asset.setSlot(this.sSlot.getValue());
        this.m_asset.setRackunitheight(this.sRackUnitHight.getValue());
        this.m_asset.setPort(this.sPort.getValue());
        this.m_asset.setCircuitId(this.sCircuitId.getValue());
        this.m_asset.setAdmin(this.sAdmin.getValue());
    }

    private void saveDataVendor() {
        this.m_asset.setVendor(this.sVendorName.getValue());
        this.m_asset.setVendorPhone(this.sPhone.getValue());
        this.m_asset.setVendorFax(this.sFax.getValue());
        this.m_asset.setLease(this.sLease.getValue());
        this.m_asset.setLeaseExpires(this.sLeaseExpires.getValue());
        this.m_asset.setVendorAssetNumber(this.sVendorAsset.getValue());
        this.m_asset.setMaintcontract(this.sMaintContract.getValue());
        this.m_asset.setMaintContractExpiration(this.sContractExpires.getValue());
        this.m_asset.setSupportPhone(this.sMaintPhone.getValue());
    }

    private void saveDataVmware() {
        this.m_asset.setVmwareManagedObjectId(this.sVmwareManagedObjectId.getValue());
        this.m_asset.setVmwareManagedEntityType(this.sVmwareManagedEntityType.getValue());
        this.m_asset.setVmwareManagementServer(this.sVmwareManagementServer.getValue());
        this.m_asset.setVmwareTopologyInfo(this.sVmwareTopologyInfo.getValue());
        this.m_asset.setVmwareState(this.sVmwareState.getValue());
    }

    @Override
    public void setData(AssetCommand asset) {
        this.m_asset = asset;
        this.nodeInfoLabel.setText(asset.getNodeLabel() + " " + this.con.nodeIdLabel() + " " + asset.getNodeId());
        this.nodeInfoLink.setHref("element/node.jsp?node=" + asset.getNodeId());
        this.nodeInfoLink.setHTML(this.con.nodeInfoLink());
        this.setDataSNMP(this.m_asset);
        this.setDataConfigCategories(this.m_asset);
        this.setDataIdentification(this.m_asset);
        this.setDataLocation(this.m_asset);
        this.setDataVendor(this.m_asset);
        this.setDataAuthentication(this.m_asset);
        this.setDataHardware(this.m_asset);
        this.setDataComments(this.m_asset);
        this.setDataVmware(this.m_asset);
        DateTimeFormat m_formater = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM);
        this.lastModified.setText(this.con.lastModified() + " " + m_formater.format(asset.getLastModifiedDate()) + " | " + asset.getLastModifiedBy());
    }

    private void setDataAuthentication(AssetCommand asset) {
        this.sUserName.setValue(asset.getUsername());
        this.sPassword.setValue(asset.getPassword());
        this.sEnablePassword.setValue(asset.getEnable());
        this.sConnection.setOptions(asset.getConnectionOptions());
        this.sConnection.setValue(asset.getConnection());
        this.sAutoEnable.setOptions(asset.getAutoenableOptions());
        this.sAutoEnable.setValue(asset.getAutoenable());
        this.sSnmpcommunity.setValue(asset.getSnmpcommunity());
    }

    private void setDataComments(AssetCommand asset) {
        this.sComment.setValue(asset.getComment());
    }

    private void setDataConfigCategories(AssetCommand asset) {
        this.sDisplayCat.setValue(asset.getDisplayCategory());
        this.sNotificationCat.setValue(asset.getNotifyCategory());
        this.sPollerCat.setValue(asset.getPollerCategory());
        this.sThresholdCat.setValue(asset.getThresholdCategory());
    }

    private void setDataHardware(AssetCommand asset) {
        this.sCpu.setValue(asset.getCpu());
        this.sRam.setValue(asset.getRam());
        this.sStoragectrl.setValue(asset.getStoragectrl());
        this.sAdditionalhardware.setValue(asset.getAdditionalhardware());
        this.sNumpowersupplies.setValue(asset.getNumpowersupplies());
        this.sInputpower.setValue(asset.getInputpower());
        this.sHdd1.setValue(asset.getHdd1());
        this.sHdd2.setValue(asset.getHdd2());
        this.sHdd3.setValue(asset.getHdd3());
        this.sHdd4.setValue(asset.getHdd4());
        this.sHdd5.setValue(asset.getHdd5());
        this.sHdd6.setValue(asset.getHdd6());
    }

    private void setDataIdentification(AssetCommand asset) {
        this.sDescription.setValue(asset.getDescription());
        this.sAssetCategory.setValue(asset.getCategory());
        this.sManufacturer.setValue(asset.getManufacturer());
        this.sModelNumber.setValue(asset.getModelNumber());
        this.sSerialNumber.setValue(asset.getSerialNumber());
        this.sAssetNumber.setValue(asset.getAssetNumber());
        this.sOperatingSystem.setValue(asset.getOperatingSystem());
        this.sDateInstalled.setValue(asset.getDateInstalled());
    }

    private void setDataLocation(AssetCommand asset) {
        this.sRegion.setValue(asset.getRegion());
        this.sDivision.setValue(asset.getDivision());
        this.sDepartment.setValue(asset.getDepartment());
        this.sAddress1.setValue(asset.getAddress1());
        this.sAddress2.setValue(asset.getAddress2());
        this.sCity.setValue(asset.getCity());
        this.sState.setValue(asset.getState());
        this.sZip.setValue(asset.getZip());
        this.sCountry.setValue(asset.getCountry());
        this.sLongitude.setValue(this.f2s(asset.getLongitude()));
        this.sLatitude.setValue(this.f2s(asset.getLatitude()));
        this.sBuilding.setValue(asset.getBuilding());
        this.sFloor.setValue(asset.getFloor());
        this.sRoom.setValue(asset.getRoom());
        this.sRack.setValue(asset.getRack());
        this.sSlot.setValue(asset.getSlot());
        this.sRackUnitHight.setValue(asset.getRackunitheight());
        this.sPort.setValue(asset.getPort());
        this.sCircuitId.setValue(asset.getCircuitId());
        this.sAdmin.setValue(asset.getAdmin());
    }

    private String f2s(Float value) {
        return value == null ? null : value.toString();
    }

    private Float s2f(String value) {
        if (value != null && !"".equals(value)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private void setDataSNMP(AssetCommand asset) {
        if (asset.getSnmpSysObjectId().equals("") || asset.getSnmpSysObjectId() == null) {
            this.snmpDiscPanel.setVisible(false);
        } else {
            this.sSystemId.setValue(asset.getSnmpSysObjectId());
            this.sSystemName.setValue(asset.getSnmpSysName());
            this.sSystemLocation.setValue(asset.getSnmpSysLocation());
            this.sSystemContact.setValue(asset.getSnmpSysContact());
            this.sSystemDescription.setValue(asset.getSnmpSysDescription());
            this.snmpDiscPanel.setVisible(true);
        }
    }

    @Override
    public void setDataSugg(AssetSuggCommand assetSugg) {
        this.setDataSuggConfigCategories(assetSugg);
        this.setDataSuggIdentification(assetSugg);
        this.setDataSuggLocation(assetSugg);
        this.setDataSuggVendor(assetSugg);
        this.setDataSuggAuth(assetSugg);
        this.setDataSuggHardware(assetSugg);
        this.setDataSuggVmware(assetSugg);
    }

    private void setDataSuggAuth(AssetSuggCommand assetSugg) {
        this.sSnmpcommunity.setSuggestions(assetSugg.getSnmpcommunity());
    }

    private void setDataSuggConfigCategories(AssetSuggCommand assetSugg) {
        this.sDisplayCat.setSuggestions(assetSugg.getDisplayCategory());
        this.sNotificationCat.setSuggestions(assetSugg.getNotifyCategory());
        this.sPollerCat.setSuggestions(assetSugg.getPollerCategory());
        this.sThresholdCat.setSuggestions(assetSugg.getThresholdCategory());
    }

    private void setDataSuggHardware(AssetSuggCommand assetSugg) {
        this.sCpu.setSuggestions(assetSugg.getCpu());
        this.sRam.setSuggestions(assetSugg.getRam());
        this.sStoragectrl.setSuggestions(assetSugg.getStoragectrl());
        this.sAdditionalhardware.setSuggestions(assetSugg.getAdditionalhardware());
        this.sNumpowersupplies.setSuggestions(assetSugg.getNumpowersupplies());
        this.sInputpower.setSuggestions(assetSugg.getInputpower());
        this.sHdd1.setSuggestions(assetSugg.getHdd1());
        this.sHdd2.setSuggestions(assetSugg.getHdd2());
        this.sHdd3.setSuggestions(assetSugg.getHdd3());
        this.sHdd4.setSuggestions(assetSugg.getHdd4());
        this.sHdd5.setSuggestions(assetSugg.getHdd5());
        this.sHdd6.setSuggestions(assetSugg.getHdd6());
    }

    private void setDataSuggIdentification(AssetSuggCommand assetSugg) {
        this.sDescription.setSuggestions(assetSugg.getDescription());
        this.sAssetCategory.setSuggestions(assetSugg.getCategory());
        this.sManufacturer.setSuggestions(assetSugg.getManufacturer());
        this.sModelNumber.setSuggestions(assetSugg.getModelNumber());
        this.sOperatingSystem.setSuggestions(assetSugg.getOperatingSystem());
    }

    private void setDataSuggLocation(AssetSuggCommand assetSugg) {
        this.sRegion.setSuggestions(assetSugg.getRegion());
        this.sDivision.setSuggestions(assetSugg.getDivision());
        this.sDepartment.setSuggestions(assetSugg.getDepartment());
        this.sAddress1.setSuggestions(assetSugg.getAddress1());
        this.sAddress2.setSuggestions(assetSugg.getAddress2());
        this.sCity.setSuggestions(assetSugg.getCity());
        this.sState.setSuggestions(assetSugg.getState());
        this.sZip.setSuggestions(assetSugg.getZip());
        this.sCountry.setSuggestions(assetSugg.getCountry());
        this.sBuilding.setSuggestions(assetSugg.getBuilding());
        this.sFloor.setSuggestions(assetSugg.getFloor());
        this.sRoom.setSuggestions(assetSugg.getRoom());
        this.sRack.setSuggestions(assetSugg.getRack());
        this.sCircuitId.setSuggestions(assetSugg.getCircuitId());
        this.sAdmin.setSuggestions(assetSugg.getAdmin());
    }

    private void setDataSuggVendor(AssetSuggCommand assetSugg) {
        this.sVendorName.setSuggestions(assetSugg.getVendor());
        this.sPhone.setSuggestions(assetSugg.getVendorPhone());
        this.sFax.setSuggestions(assetSugg.getVendorFax());
        this.sLease.setSuggestions(assetSugg.getLease());
        this.sMaintContract.setSuggestions(assetSugg.getMaintcontract());
        this.sMaintPhone.setSuggestions(assetSugg.getSupportPhone());
    }

    private void setDataVendor(AssetCommand asset) {
        this.sVendorName.setValue(asset.getVendor());
        this.sPhone.setValue(asset.getVendorPhone());
        this.sFax.setValue(asset.getVendorFax());
        this.sLease.setValue(asset.getLease());
        this.sLeaseExpires.setValue(asset.getLeaseExpires());
        this.sVendorAsset.setValue(asset.getVendorAssetNumber());
        this.sMaintContract.setValue(asset.getMaintcontract());
        this.sContractExpires.setValue(asset.getMaintContractExpiration());
        this.sMaintPhone.setValue(asset.getSupportPhone());
    }

    private void setDataSuggVmware(AssetSuggCommand assetSugg) {
        this.sVmwareManagedObjectId.setSuggestions(assetSugg.getVmwareManagedObjectId());
        this.sVmwareManagedEntityType.setSuggestions(assetSugg.getVmwareManagedEntityType());
        this.sVmwareManagementServer.setSuggestions(assetSugg.getVmwareManagementServer());
        this.sVmwareTopologyInfo.setSuggestions(assetSugg.getVmwareTopologyInfo());
        this.sVmwareState.setSuggestions(assetSugg.getVmwareState());
    }

    private void setDataVmware(AssetCommand asset) {
        this.sVmwareManagedObjectId.setValue(asset.getVmwareManagedObjectId());
        this.sVmwareManagedEntityType.setValue(asset.getVmwareManagedEntityType());
        this.sVmwareManagementServer.setValue(asset.getVmwareManagementServer());
        this.sVmwareTopologyInfo.setValue(asset.getVmwareTopologyInfo());
        this.sVmwareState.setValue(asset.getVmwareState());
    }

    @Override
    public void setEnable(Boolean enabled) {
        for (FieldSet fieldSet : this.fieldSetList) {
            fieldSet.setEnabled(enabled);
        }
        this.saveButton.setEnabled(enabled.booleanValue());
        this.resetButton.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setError(String description, Throwable throwable) {
        String error = "";
        if (throwable != null) {
            error = throwable.toString();
        }
        this.errorModalHtml.setHTML(description + error);
        this.errorModal.show();
    }

    @Override
    public void setInfo(String info) {
        this.lInfoTop.setText(info);
        this.lInfoBottom.setText(info);
    }

    @UiTemplate(value="AssetNodePage.ui.xml")
    static interface AssetNodePageUiBinder
    extends UiBinder<Widget, AssetNodePageImpl> {
    }
}

