/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.FlexTable;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.Notification;
import org.opennms.dashboard.client.PageableTableView;

class NotificationView
extends PageableTableView {
    private Notification[] m_notifications;

    NotificationView(Dashlet dashlet) {
        super(dashlet, 8, new String[]{"Node", "Service", "Message", "Sent Time", "Responder", "Response Time"});
    }

    public void setNotifications(Notification[] notifications) {
        this.m_notifications = notifications;
        this.refresh();
    }

    @Override
    protected void setRow(FlexTable table, int row, int elementIndex) {
        Notification notif = this.m_notifications[elementIndex];
        if (notif.getIsDashboardRole()) {
            table.setText(row, 0, notif.getNodeLabel());
        } else {
            table.setHTML(row, 0, "<a href=\"element/node.jsp?node=" + notif.getNodeId() + "\">" + notif.getNodeLabel() + "</a>");
        }
        table.setText(row, 1, notif.getServiceName());
        table.setHTML(row, 2, notif.getTextMessage());
        table.setText(row, 3, "" + notif.getSentTime());
        table.setText(row, 4, notif.getResponder());
        table.setText(row, 5, notif.getRespondTime() != null ? notif.getRespondTime().toString() : "");
        table.getRowFormatter().setStyleName(row, "severity-" + notif.getSeverity().toLowerCase());
    }

    @Override
    public int getElementCount() {
        return this.m_notifications == null ? 0 : this.m_notifications.length;
    }
}

