/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.gwt.FlowPanel;
import org.opennms.dashboard.client.AlarmDashlet;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.ErrorHandler;
import org.opennms.dashboard.client.GraphDashlet;
import org.opennms.dashboard.client.NodeStatusDashlet;
import org.opennms.dashboard.client.NotificationDashlet;
import org.opennms.dashboard.client.OutageDashlet;
import org.opennms.dashboard.client.SurveillanceDashlet;
import org.opennms.dashboard.client.SurveillanceGroup;
import org.opennms.dashboard.client.SurveillanceIntersection;
import org.opennms.dashboard.client.SurveillanceListener;
import org.opennms.dashboard.client.SurveillanceService;
import org.opennms.dashboard.client.SurveillanceServiceAsync;
import org.opennms.dashboard.client.SurveillanceSet;

public class Dashboard
implements EntryPoint,
ErrorHandler {
    Dashlet m_surveillance;
    AlarmDashlet m_alarms;
    OutageDashlet m_outages;
    NodeStatusDashlet m_nodeStatus;
    NotificationDashlet m_notifications;
    GraphDashlet m_graphs;
    private SurveillanceServiceAsync m_surveillanceService;
    private Modal m_modal;
    private FlowPanel m_modalContent = new FlowPanel();

    public void onModuleLoad() {
        this.add((Widget)this.createSurveillanceDashlet(), "surveillanceView");
        this.add((Widget)this.createAlarmDashlet(), "alarms");
        this.add((Widget)this.createGraphDashlet(), "graphs");
        this.add((Widget)this.createNotificationDashlet(), "notifications");
        this.add((Widget)this.createNodeStatusDashlet(), "nodeStatus");
        this.setSurveillanceSet(SurveillanceSet.DEFAULT);
        this.addModal();
    }

    private void addModal() {
        ModalHeader modalHeader = new ModalHeader();
        modalHeader.setTitle("Error Occurred");
        Button okBtn = new Button("OK");
        okBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Dashboard.this.m_modal.hide();
            }
        });
        ModalBody modalBody = new ModalBody();
        modalBody.add((Widget)this.m_modalContent);
        ModalFooter modalFooter = new ModalFooter();
        modalFooter.add((Widget)okBtn);
        this.m_modal = new Modal();
        this.m_modal.add((Widget)modalHeader);
        this.m_modal.add((Widget)modalBody);
        this.m_modal.add((Widget)modalFooter);
        RootPanel.get().add((Widget)this.m_modal);
    }

    private GraphDashlet createGraphDashlet() {
        this.m_graphs = new GraphDashlet(this);
        this.m_graphs.setSurveillanceService(this.getSurveillanceService());
        return this.m_graphs;
    }

    private NotificationDashlet createNotificationDashlet() {
        this.m_notifications = new NotificationDashlet(this);
        this.m_notifications.setSurveillanceService(this.getSurveillanceService());
        return this.m_notifications;
    }

    private AlarmDashlet createAlarmDashlet() {
        this.m_alarms = new AlarmDashlet(this);
        this.m_alarms.setSurveillanceService(this.getSurveillanceService());
        this.m_alarms.setSurveillanceSet(SurveillanceSet.DEFAULT);
        return this.m_alarms;
    }

    private Dashlet createSurveillanceDashlet() {
        SurveillanceDashlet surveillance = new SurveillanceDashlet(this);
        SurveillanceListener listener = new SurveillanceListener(){

            @Override
            public void onAllClicked(Dashlet viewer) {
                Dashboard.this.setSurveillanceSet(SurveillanceSet.DEFAULT);
            }

            @Override
            public void onIntersectionClicked(Dashlet viewer, SurveillanceIntersection intersection) {
                Dashboard.this.setSurveillanceSet(intersection);
            }

            @Override
            public void onSurveillanceGroupClicked(Dashlet viewer, SurveillanceGroup group) {
                Dashboard.this.setSurveillanceSet(group);
            }
        };
        surveillance.addSurveillanceViewListener(listener);
        SurveillanceServiceAsync svc = this.getSurveillanceService();
        surveillance.setSurveillanceService(svc);
        this.m_surveillance = surveillance;
        return this.m_surveillance;
    }

    private SurveillanceServiceAsync getSurveillanceService() {
        if (this.m_surveillanceService == null) {
            String serviceEntryPoint = GWT.getHostPageBaseURL() + "surveillanceService.gwt";
            SurveillanceServiceAsync svc = (SurveillanceServiceAsync)GWT.create(SurveillanceService.class);
            ServiceDefTarget endpoint = (ServiceDefTarget)svc;
            endpoint.setServiceEntryPoint(serviceEntryPoint);
            this.m_surveillanceService = svc;
        }
        return this.m_surveillanceService;
    }

    private NodeStatusDashlet createNodeStatusDashlet() {
        this.m_nodeStatus = new NodeStatusDashlet(this);
        this.m_nodeStatus.setSurveillanceService(this.getSurveillanceService());
        this.m_nodeStatus.setSurveillanceSet(SurveillanceSet.DEFAULT);
        return this.m_nodeStatus;
    }

    public void add(Widget widget, String elementId) {
        RootPanel panel = RootPanel.get((String)elementId);
        if (panel != null) {
            panel.add(widget);
        }
    }

    @Override
    public void error(Throwable e) {
        this.error(e.toString());
    }

    public void error(String err) {
        this.m_modalContent.clear();
        HTMLPanel html = new HTMLPanel(err);
        html.setStyleName("Message");
        this.m_modalContent.add((Widget)html);
        this.m_modal.show();
    }

    private void setSurveillanceSet(SurveillanceSet set) {
        this.m_surveillance.setSurveillanceSet(set);
        this.m_alarms.setSurveillanceSet(set);
        this.m_graphs.setSurveillanceSet(set);
        this.m_notifications.setSurveillanceSet(set);
        this.m_nodeStatus.setSurveillanceSet(set);
    }
}

