/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.admin.discovery.GeneralSettingsLoader;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDiscoveryServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ActionDiscoveryServlet.class);
    private static final long serialVersionUID = 2L;
    public static final String ATTRIBUTE_DISCOVERY_CONFIGURATION = ActionDiscoveryServlet.class.getSimpleName() + "-discoveryConfiguration";

    public static DiscoveryConfiguration getDiscoveryConfig() throws ServletException {
        DiscoveryConfiguration config = null;
        try {
            DiscoveryConfigFactory factory = DiscoveryConfigFactory.getInstance();
            factory.reload();
            config = factory.getConfiguration();
        }
        catch (Exception e) {
            throw new ServletException("Could not load configuration: " + e.getMessage(), (Throwable)e);
        }
        return config;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String specificIndex;
        String retries;
        LOG.info("Loading Discovery configuration.");
        HttpSession sess = request.getSession(true);
        DiscoveryConfiguration config = (DiscoveryConfiguration)sess.getAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION);
        if (config == null) {
            config = ActionDiscoveryServlet.getDiscoveryConfig();
            sess.setAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION, (Object)config);
        }
        config = GeneralSettingsLoader.load(request, config);
        String action = request.getParameter("action");
        LOG.debug("action: {}", (Object)action);
        if (action.equals("AddSpecific")) {
            LOG.debug("Adding Specific");
            String ipAddr = request.getParameter("specificipaddress");
            String timeout = request.getParameter("specifictimeout");
            retries = request.getParameter("specificretries");
            Specific newSpecific = new Specific();
            newSpecific.setContent(ipAddr);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(config.getTimeout())) {
                newSpecific.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(config.getRetries())) {
                newSpecific.setRetries(WebSecurityUtils.safeParseInt((String)retries));
            }
            config.addSpecific(newSpecific);
        }
        if (action.equals("RemoveSpecific")) {
            LOG.debug("Removing Specific");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            Specific spec = config.getSpecific(index);
            boolean result = config.removeSpecific(spec);
            LOG.debug("Removing Specific result = {}", (Object)result);
        }
        if (action.equals("AddIncludeRange")) {
            LOG.debug("Adding Include Range");
            String ipAddrBase = request.getParameter("irbase");
            String ipAddrEnd = request.getParameter("irend");
            String timeout = request.getParameter("irtimeout");
            String retries2 = request.getParameter("irretries");
            IncludeRange newIR = new IncludeRange();
            newIR.setBegin(ipAddrBase);
            newIR.setEnd(ipAddrEnd);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(config.getTimeout())) {
                newIR.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries2 != null && !"".equals(retries2.trim()) && !retries2.equals(config.getRetries())) {
                newIR.setRetries(WebSecurityUtils.safeParseInt((String)retries2));
            }
            config.addIncludeRange(newIR);
        }
        if (action.equals("RemoveIncludeRange")) {
            LOG.debug("Removing Include Range");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeRange ir = config.getIncludeRange(index);
            boolean result = config.removeIncludeRange(ir);
            LOG.debug("Removing Include Range result = {}", (Object)result);
        }
        if (action.equals("AddIncludeUrl")) {
            LOG.debug("Adding Include URL");
            String url = request.getParameter("iuurl");
            String timeout = request.getParameter("iutimeout");
            retries = request.getParameter("iuretries");
            IncludeUrl iu = new IncludeUrl();
            iu.setContent(url);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(config.getTimeout())) {
                iu.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(config.getRetries())) {
                iu.setRetries(WebSecurityUtils.safeParseInt((String)retries));
            }
            config.addIncludeUrl(iu);
        }
        if (action.equals("RemoveIncludeUrl")) {
            LOG.debug("Removing Include URL");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeUrl iu = config.getIncludeUrl(index);
            boolean result = config.removeIncludeUrl(iu);
            LOG.debug("Removing Include URL result = {}", (Object)result);
        }
        if (action.equals("AddExcludeRange")) {
            LOG.debug("Adding Exclude Range");
            String ipAddrBegin = request.getParameter("erbegin");
            String ipAddrEnd = request.getParameter("erend");
            ExcludeRange newER = new ExcludeRange();
            newER.setBegin(ipAddrBegin);
            newER.setEnd(ipAddrEnd);
            config.addExcludeRange(newER);
        }
        if (action.equals("RemoveExcludeRange")) {
            LOG.debug("Removing Exclude Range");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            ExcludeRange er = config.getExcludeRange(index);
            boolean result = config.removeExcludeRange(er);
            LOG.debug("Removing Exclude Range result = {}", (Object)result);
        }
        if (action.equals("SaveAndRestart")) {
            DiscoveryConfigFactory dcf = null;
            try {
                StringWriter configString = new StringWriter();
                config.marshal((Writer)configString);
                LOG.debug(configString.toString().trim());
                dcf = DiscoveryConfigFactory.getInstance();
                dcf.saveConfiguration(config);
            }
            catch (Throwable ex) {
                LOG.error("Error while saving configuration. {}", ex);
                throw new ServletException(ex);
            }
            EventProxy proxy = null;
            try {
                proxy = Util.createEventProxy();
            }
            catch (Throwable me) {
                LOG.error(me.getMessage());
            }
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discoveryConfigChange", "ActionDiscoveryServlet");
            bldr.setHost("host");
            try {
                proxy.send(bldr.getEvent());
            }
            catch (Throwable me) {
                LOG.error(me.getMessage());
            }
            LOG.info("Restart Discovery requested!");
            sess.removeAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION);
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)"admin/discovery/config-done.jsp"));
            return;
        }
        sess.setAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION, (Object)config);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/discovery/edit-config.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

