/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import java.util.Date;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.AbstractFieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringDateLocalValidator;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringMaxLengthValidator;

public class FieldSetDateBox
extends AbstractFieldSet
implements FieldSet,
ValueChangeHandler<Date>,
MouseUpHandler,
KeyUpHandler {
    private DateBox dateBox = new DateBox();
    private final DateTimeFormat localFormater = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_MEDIUM);
    private final DateTimeFormat onmsFormater = DateTimeFormat.getFormat((String)"yyyy-MM-dd");

    public FieldSetDateBox(String name, String value, String helpText) {
        super(name, helpText);
        this.init(value, -1);
    }

    @UiConstructor
    public FieldSetDateBox(String name, String value, String helpText, int maxLength) {
        super(name, helpText);
        this.init(value, maxLength);
    }

    @Override
    public String getValue() {
        String result;
        try {
            result = this.onmsFormater.format(this.dateBox.getValue());
        }
        catch (Exception e) {
            result = this.dateBox.getTextBox().getValue();
        }
        return result;
    }

    private void init(String value, int maxLength) {
        if (maxLength > 0) {
            this.addErrorValidator(new StringMaxLengthValidator(maxLength));
        }
        this.addWarningValidator(new StringDateLocalValidator());
        try {
            this.dateBox.setValue(this.onmsFormater.parseStrict(value));
        }
        catch (IllegalArgumentException e) {
            this.dateBox.getTextBox().setText(value);
        }
        this.inititalValue = value;
        this.dateBox.setFormat((DateBox.Format)new DateBox.DefaultFormat(this.localFormater));
        this.dateBox.getTextBox().addFocusHandler((FocusHandler)this);
        this.dateBox.getTextBox().addChangeHandler((ChangeHandler)this);
        this.dateBox.getTextBox().addMouseUpHandler((MouseUpHandler)this);
        this.dateBox.getTextBox().addKeyUpHandler((KeyUpHandler)this);
        this.dateBox.addValueChangeHandler((ValueChangeHandler)this);
        this.dateBox.addStyleName("form-control");
        this.panel.add((Widget)this.dateBox);
    }

    public void onKeyUp(KeyUpEvent event) {
        this.checkField();
    }

    public void onMouseUp(MouseUpEvent event) {
        this.checkField();
    }

    public void onValueChange(ValueChangeEvent<Date> event) {
        this.checkField();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.dateBox.getTextBox().setEnabled(enabled.booleanValue());
    }

    @Override
    public void setValue(String value) {
        try {
            this.dateBox.setValue(this.onmsFormater.parseStrict(value));
        }
        catch (Exception e) {
            this.dateBox.getTextBox().setText(value);
        }
        this.inititalValue = value;
        this.validate(this.getValue());
    }
}

