/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.rpc.IsSerializable;
import org.opennms.dashboard.client.SurveillanceGroup;
import org.opennms.dashboard.client.SurveillanceIntersection;

public class SurveillanceData
implements IsSerializable {
    private boolean m_complete = false;
    private String m_name;
    private SurveillanceGroup[] m_columnGroups;
    private SurveillanceGroup[] m_rowGroups;
    private SurveillanceIntersection[][] m_cells;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    public void setComplete(boolean complete) {
        this.m_complete = complete;
    }

    public int getColumnCount() {
        return this.m_columnGroups.length;
    }

    public int getRowCount() {
        return this.m_rowGroups.length;
    }

    public String getColumnHeading(int columnIndex) {
        return this.m_columnGroups[columnIndex].getLabel();
    }

    public String getRowHeading(int rowIndex) {
        return this.m_rowGroups[rowIndex].getLabel();
    }

    public SurveillanceIntersection getCell(int row, int col) {
        this.ensureData();
        return this.m_cells[row][col];
    }

    private void ensureData() {
        if (this.m_cells == null) {
            this.m_cells = new SurveillanceIntersection[this.getRowCount()][this.getColumnCount()];
            for (int row = 0; row < this.getRowCount(); ++row) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    this.m_cells[row][col] = new SurveillanceIntersection(this.m_rowGroups[row], this.m_columnGroups[col]);
                }
            }
        }
    }

    public void setCell(int row, int col, SurveillanceIntersection cell) {
        this.ensureData();
        cell.setRowGroup(this.m_rowGroups[col]);
        cell.setColumnGroup(this.m_columnGroups[col]);
        this.m_cells[row][col] = cell;
    }

    public void setCell(int row, int col, String data, String status) {
        this.ensureData();
        this.m_cells[row][col].setData(data);
        this.m_cells[row][col].setStatus(status);
    }

    public void setCell(int row, int col, String value) {
        this.setCell(row, col, value, null);
    }

    public SurveillanceIntersection getIntersection(int row, int col) {
        return this.m_cells[row][col];
    }

    public SurveillanceGroup[] getColumnGroups() {
        return this.m_columnGroups;
    }

    public void setColumnGroups(SurveillanceGroup[] columnGroups) {
        this.m_columnGroups = columnGroups;
    }

    public SurveillanceGroup[] getRowGroups() {
        return this.m_rowGroups;
    }

    public void setRowGroups(SurveillanceGroup[] rowGroups) {
        this.m_rowGroups = rowGroups;
    }
}

