/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelFooter;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.DashletView;
import org.opennms.dashboard.client.SurveillanceSet;

public abstract class Dashlet
extends Composite {
    private Panel m_panel = new Panel();
    private String m_title;
    private DashletTitle m_titleWidget;
    private DashletView m_view;
    private DashletLoader m_loader;
    private DashletFooter m_footer;
    private Dashboard m_dashboard;
    private boolean m_hasFooter = true;

    public Dashlet(Dashboard dashboard, String title) {
        this.m_title = title;
        this.m_dashboard = dashboard;
        this.initWidget((Widget)this.m_panel);
    }

    public Dashlet(Dashboard dashboard, String title, boolean hasFooter) {
        this(dashboard, title);
        this.m_hasFooter = hasFooter;
    }

    protected void setView(DashletView view) {
        this.m_view = view;
    }

    protected void setView(Widget view) {
        this.setView(new DashletView(this, view));
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
        this.m_titleWidget.setTitle(this.m_title);
    }

    public void addToTitleBar(Widget widget, DockPanel.DockLayoutConstant constraint) {
        this.addToFooter(widget, constraint);
    }

    public void addToFooter(Widget widget, DockPanel.DockLayoutConstant constraint) {
        this.m_footer.add(widget);
    }

    public void setLoader(DashletLoader loader) {
        this.m_loader = loader;
    }

    protected void onLoad() {
        if (this.m_loader == null) {
            this.m_loader = new DashletLoader();
        }
        this.m_titleWidget = new DashletTitle(this.m_title, this.m_loader);
        this.m_panel.add((Widget)this.m_titleWidget);
        this.m_panel.add((Widget)this.m_view);
        if (this.m_hasFooter) {
            this.m_footer = new DashletFooter();
            this.m_panel.add((Widget)this.m_footer);
        }
        this.m_view.onDashLoad();
    }

    protected void error(Throwable caught) {
        this.m_dashboard.error(caught);
    }

    public void error(String err) {
        this.m_dashboard.error(err);
    }

    public void setSurveillanceSet(SurveillanceSet set) {
    }

    class DashletFooter
    extends Composite {
        private PanelFooter m_panelFooter = new PanelFooter();

        DashletFooter() {
            this.initWidget((Widget)this.m_panelFooter);
        }

        public void add(Widget widget) {
            this.m_panelFooter.add(widget);
        }
    }

    class DashletTitle
    extends Composite {
        private PanelHeader m_panelHeader = new PanelHeader();
        private Heading m_heading = new Heading(HeadingSize.H3);

        DashletTitle(String title, DashletLoader loader) {
            this.m_heading.setText(title);
            this.m_panelHeader.add((Widget)this.m_heading);
            this.m_panelHeader.add((Widget)Dashlet.this.m_loader);
            this.initWidget((Widget)this.m_panelHeader);
        }

        public void setTitle(String title) {
            this.m_heading.setText(title);
        }

        public void add(Widget widget, DockPanel.DockLayoutConstant constraint) {
            widget.addStyleName("pull-right");
            this.m_panelHeader.add(widget);
        }
    }
}

