/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.web.controller.RrdGraphController;
import org.springframework.mock.web.MockHttpServletRequest;

public class RrdGraphControllerTest {
    private static final int ONE_HOUR_IN_MILLIS = 3600000;
    private static final int ONE_DAY_IN_MILLIS = 86400000;
    private RrdGraphController m_controller;
    private MockHttpServletRequest m_request;

    @Before
    public void setUp() throws InterruptedException {
        this.m_controller = new RrdGraphController();
        this.m_request = new MockHttpServletRequest();
        GregorianCalendar now = new GregorianCalendar();
        if (now.get(11) == 23 && now.get(12) > 59 && now.get(13) > 50) {
            Thread.sleep(30000L);
        }
    }

    private void setSubHourFieldsZero(Calendar cal) {
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private void setSubDayFieldsZero(Calendar cal) {
        this.setSubHourFieldsZero(cal);
        cal.set(11, 0);
    }

    @Test
    public void testExplicitTimeSpec() {
        this.m_request.addParameter("start", "123456789");
        this.m_request.addParameter("end", "123456790");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        Assert.assertEquals((long)123456789L, (long)result[0]);
        Assert.assertEquals((long)123456790L, (long)result[1]);
    }

    private void assertTimestampsEqualWithEpsilon(long expected, long actual, int epsilon, String desc) {
        Assert.assertTrue((String)("Expecting the calculated " + desc + " time " + actual + " (" + new Date(actual).toString() + ")" + " to be within " + epsilon + "ms of " + expected + " (" + new Date(expected) + ")"), (Math.abs(actual - expected) < (long)epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultStartEndTimeSpec() {
        long now = new Date().getTime();
        long oneDayAgo = now - 86400000L;
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(oneDayAgo, start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(now, end, 1000, "end");
        Assert.assertTrue((String)("Expecting the calculated end time " + end + " to be within 1000ms of now " + now), (Math.abs(end - now) < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyStringStartEndTimeSpec() {
        long now = new Date().getTime();
        long oneDayAgo = now - 86400000L;
        this.m_request.addParameter("end", "");
        this.m_request.addParameter("start", "");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(oneDayAgo, start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(now, end, 1000, "end");
    }

    @Test
    public void testNowEnd() {
        long now = new Date().getTime();
        long oneDayAgo = now - 86400000L;
        this.m_request.addParameter("end", "now");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(oneDayAgo, start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(now, end, 1000, "end");
    }

    @Test
    public void testAbbreviatedNowForEnd() {
        long now = new Date().getTime();
        long oneDayAgo = now - 86400000L;
        this.m_request.addParameter("end", "n");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(oneDayAgo, start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(now, end, 1000, "end");
    }

    @Test
    public void test24HourClockHourTodayStartEndTime() {
        GregorianCalendar now = new GregorianCalendar();
        now.set(11, 8);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        Date startDate = now.getTime();
        now.set(11, 16);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        Date endDate = now.getTime();
        this.m_request.addParameter("start", "08:00");
        this.m_request.addParameter("end", "16:00");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testSimpleNegativeOffset() {
        GregorianCalendar now = new GregorianCalendar();
        Date endDate = now.getTime();
        Date startDate = new Date(now.getTimeInMillis() - 3600000L);
        this.m_request.addParameter("start", "-1h");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }

    @Test
    public void testRelativeStartOffsetEnd() {
        GregorianCalendar now = new GregorianCalendar();
        Date endDate = new Date(now.getTimeInMillis() - 3600000L);
        Date startDate = new Date(now.getTimeInMillis() - 10800000L);
        this.m_request.addParameter("end", "-1h");
        this.m_request.addParameter("start", "end-2h");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }

    @Test
    public void testRelativeStartOffsetEndAbbreviatedEnd() {
        GregorianCalendar now = new GregorianCalendar();
        Date endDate = new Date(now.getTimeInMillis() - 3600000L);
        Date startDate = new Date(now.getTimeInMillis() - 10800000L);
        this.m_request.addParameter("start", "e-2h");
        this.m_request.addParameter("end", "-1h");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }

    @Test
    public void testRelativeEndOffsetStart() {
        GregorianCalendar now = new GregorianCalendar();
        Date endDate = new Date(now.getTimeInMillis() - 0x6DDD00L);
        Date startDate = new Date(now.getTimeInMillis() - 14400000L);
        this.m_request.addParameter("end", "start+2h");
        this.m_request.addParameter("start", "-4h");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }

    @Test
    public void testRelativeEndOffsetStartAbbreviatedStart() {
        GregorianCalendar now = new GregorianCalendar();
        Date endDate = new Date(now.getTimeInMillis() - 0x6DDD00L);
        Date startDate = new Date(now.getTimeInMillis() - 14400000L);
        this.m_request.addParameter("end", "s+2h");
        this.m_request.addParameter("start", "-4h");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }

    @Test
    public void testHourMinuteSyntax() {
        GregorianCalendar now = new GregorianCalendar();
        this.setSubHourFieldsZero(now);
        now.set(11, 8);
        now.set(12, 30);
        Date startDate = now.getTime();
        now.set(11, 16);
        now.set(12, 45);
        Date endDate = now.getTime();
        this.m_request.addParameter("end", "16:45");
        this.m_request.addParameter("start", "8.30");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testDateWithDots() {
        GregorianCalendar cal = new GregorianCalendar(1980, 0, 1);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar(1980, 11, 15);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 15.12.1980");
        this.m_request.addParameter("start", "00:00 01.01.1980");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testDateWithSlashes() {
        GregorianCalendar cal = new GregorianCalendar(1980, 0, 1);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar(1980, 11, 15);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 12/15/1980");
        this.m_request.addParameter("start", "00:00 01/01/1980");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testDateWithNoDelimiters() {
        GregorianCalendar cal = new GregorianCalendar(1980, 0, 1);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar(1980, 11, 15);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 19801215");
        this.m_request.addParameter("start", "00:00 19800101");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testNamedMonthsNoYear() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2, 2);
        cal.set(5, 1);
        this.setSubDayFieldsZero(cal);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar();
        cal.set(2, 10);
        cal.set(5, 15);
        this.setSubDayFieldsZero(cal);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 November 15");
        this.m_request.addParameter("start", "00:00 Mar 1 ");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testNamedMonthsTwoDigitYear() {
        GregorianCalendar cal = new GregorianCalendar(1980, 1, 2);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar(1980, 9, 16);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 October 16 80");
        this.m_request.addParameter("start", "00:00 Feb 2 80");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testNamedMonthsFourDigitYear() {
        GregorianCalendar cal = new GregorianCalendar(1980, 3, 6);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar(1980, 8, 17);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 September 17 1980");
        this.m_request.addParameter("start", "00:00 Apr 6 1980");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testDayOfWeekTimeSpec() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(7, 5);
        cal.set(11, 12);
        this.setSubHourFieldsZero(cal);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar();
        cal.set(7, 6);
        cal.set(11, 18);
        this.setSubHourFieldsZero(cal);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "6pm Friday");
        this.m_request.addParameter("start", "noon Thursday");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
        Assert.assertEquals((long)endDate.getTime(), (long)end);
    }

    @Test
    public void testTimeOffsets1() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(cal.getTimeInMillis() - 60000L);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar();
        cal.setTimeInMillis(cal.getTimeInMillis() - 10000L);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "now-10 seconds");
        this.m_request.addParameter("start", "now - 1minute");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
    }

    @Test
    public void testTimeOffsets2() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(cal.getTimeInMillis() - 86400000L);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar();
        cal.setTimeInMillis(cal.getTimeInMillis() - 10800000L);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "now-3 hours");
        this.m_request.addParameter("start", "now - 1 day");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
    }

    @Test
    public void testTimeOffsets3() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2, 6);
        cal.set(5, 12);
        ((Calendar)cal).add(2, -1);
        Date startDate = cal.getTime();
        cal = new GregorianCalendar();
        cal.set(2, 6);
        cal.set(5, 12);
        ((Calendar)cal).add(3, -3);
        Date endDate = cal.getTime();
        this.m_request.addParameter("end", "Jul 12 - 3 weeks");
        this.m_request.addParameter("start", "Jul 12 - 1 month");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
    }

    @Test
    public void testTimeOffsets4() {
        GregorianCalendar cal = new GregorianCalendar(1980, 6, 12);
        Date endDate = cal.getTime();
        cal = new GregorianCalendar(1979, 6, 12);
        Date startDate = cal.getTime();
        this.m_request.addParameter("end", "00:00 12.07.1980");
        this.m_request.addParameter("start", "end - 1 year");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        long end = result[1];
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
        this.assertTimestampsEqualWithEpsilon(endDate.getTime(), end, 1000, "end");
    }

    @Test
    public void complexTest1() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 9);
        ((Calendar)cal).add(6, -1);
        this.setSubHourFieldsZero(cal);
        Date startDate = cal.getTime();
        this.m_request.addParameter("end", "now");
        this.m_request.addParameter("start", "noon yesterday -3hours");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        Assert.assertEquals((long)startDate.getTime(), (long)start);
    }

    @Test
    public void complexTest2() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(10, -5);
        ((Calendar)cal).add(12, -45);
        Date startDate = cal.getTime();
        this.m_request.addParameter("end", "now");
        this.m_request.addParameter("start", "-5h45min");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }

    @Test
    public void complexTest3() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(2, -5);
        ((Calendar)cal).add(3, -1);
        ((Calendar)cal).add(6, -2);
        Date startDate = cal.getTime();
        this.m_request.addParameter("end", "now");
        this.m_request.addParameter("start", "-5mon1w2d");
        long[] result = this.m_controller.parseTimes((HttpServletRequest)this.m_request);
        long start = result[0];
        this.assertTimestampsEqualWithEpsilon(startDate.getTime(), start, 1000, "start");
    }
}

