/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.mock.MockServiceTypeDao;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.MockForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.web.svclayer.support.DefaultManualProvisioningService;
import org.opennms.web.svclayer.support.PropertyUtils;

public class DefaultManualProvisioningServiceTest {
    private DefaultManualProvisioningService m_provisioningService;
    private Requisition m_testData;
    private ForeignSourceRepository m_activeRepository = new MockForeignSourceRepository();
    private ForeignSourceRepository m_pendingRepository = new MockForeignSourceRepository();
    private MockServiceTypeDao m_serviceTypeDao = new MockServiceTypeDao();

    @Before
    public void setUp() throws Exception {
        this.m_testData = this.m_activeRepository.importResourceRequisition(ConfigurationTestUtils.getSpringResourceForResource((Object)this, (String)"/tec_dump.xml"));
        this.m_provisioningService = new DefaultManualProvisioningService();
        this.m_provisioningService.setDeployedForeignSourceRepository(this.m_activeRepository);
        this.m_provisioningService.setPendingForeignSourceRepository(this.m_pendingRepository);
        this.m_provisioningService.setServiceTypeDao((ServiceTypeDao)this.m_serviceTypeDao);
    }

    @Test
    public void testGetProvisioningGroupNames() {
        TreeSet<String> expected = new TreeSet<String>();
        expected.add("matt:");
        Collection groupNames = this.m_provisioningService.getProvisioningGroupNames();
        Assert.assertEquals(expected, (Object)groupNames);
    }

    @Test
    public void testGetProvisioningGroup() {
        String name = "matt:";
        Requisition expected = this.m_testData;
        Requisition actual = this.m_provisioningService.getProvisioningGroup(name);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAddNewNodeToGroup() {
        String groupName = "matt:";
        String nodeLabel = "david";
        int initialCount = this.m_testData.getNodes().size();
        Requisition result = this.m_provisioningService.addNewNodeToGroup(groupName, nodeLabel);
        int newCount = result.getNodes().size();
        Assert.assertEquals((long)(initialCount + 1), (long)newCount);
        Assert.assertEquals((Object)nodeLabel, (Object)((RequisitionNode)result.getNodes().get(0)).getNodeLabel());
    }

    @Test
    public void testAddCategoryToNode() {
        String groupName = "matt:";
        String pathToNode = "node[0]";
        String categoryName = "categoryName";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToNode + ".categoryCount"), Integer.TYPE);
        Requisition result = this.m_provisioningService.addCategoryToNode(groupName, pathToNode, categoryName);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".categoryCount"), Integer.TYPE);
        Assert.assertEquals((long)(initialCount + 1), (long)newCount);
        RequisitionCategory newCategory = (RequisitionCategory)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".category[0]"), RequisitionCategory.class);
        Assert.assertNotNull((Object)newCategory);
        Assert.assertEquals((Object)categoryName, (Object)newCategory.getName());
    }

    @Test
    public void testAddInterfaceToNode() {
        String groupName = "matt:";
        String pathToNode = "node[0]";
        String ipAddr = "10.1.1.1";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToNode + ".interfaceCount"), Integer.TYPE);
        Requisition result = this.m_provisioningService.addInterfaceToNode(groupName, pathToNode, ipAddr);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".interfaceCount"), Integer.TYPE);
        Assert.assertEquals((long)(initialCount + 1), (long)newCount);
        RequisitionInterface newIface = (RequisitionInterface)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".interface[0]"), RequisitionInterface.class);
        Assert.assertNotNull((Object)newIface);
        Assert.assertEquals((Object)ipAddr, (Object)newIface.getIpAddr());
    }

    @Test
    public void testAddServiceToInterface() {
        String groupName = "matt:";
        String pathToInterface = "node[0].interface[0]";
        String serviceName = "SVC";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        Requisition result = this.m_provisioningService.addServiceToInterface(groupName, pathToInterface, serviceName);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        Assert.assertEquals((long)(initialCount + 1), (long)newCount);
        RequisitionMonitoredService svc = (RequisitionMonitoredService)PropertyUtils.getPathValue((Object)result, (String)(pathToInterface + ".monitoredService[0]"), RequisitionMonitoredService.class);
        Assert.assertNotNull((Object)svc);
        Assert.assertEquals((Object)serviceName, (Object)svc.getServiceName());
    }

    @Test
    public void testDeletePath() {
        String groupName = "matt:";
        String pathToInterface = "node[0].interface[0]";
        String pathToDelete = pathToInterface + ".monitoredService[0]";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        String svcName = (String)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToDelete + ".serviceName"), String.class);
        Requisition result = this.m_provisioningService.deletePath(groupName, pathToDelete);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        Assert.assertEquals((long)(initialCount - 1), (long)newCount);
        RequisitionMonitoredService svc = (RequisitionMonitoredService)PropertyUtils.getPathValue((Object)result, (String)(pathToInterface + ".monitoredService[0]"), RequisitionMonitoredService.class);
        Assert.assertNotNull((Object)svc);
        Assert.assertFalse((boolean)svc.getServiceName().equals(svcName));
    }

    @Test
    public void serviceTypeNamesIncludesServiceFromPollerConfiguration() {
        HashMap<String, Object> serviceMonitors = new HashMap<String, Object>();
        serviceMonitors.put("Shochu-Stock-Level", null);
        PollerConfig pollerConfig = (PollerConfig)EasyMock.createNiceMock(PollerConfig.class);
        EasyMock.expect((Object)pollerConfig.getServiceMonitors()).andReturn(serviceMonitors);
        this.m_provisioningService.setPollerConfig(pollerConfig);
        EasyMock.replay((Object[])new Object[]{pollerConfig});
        Collection services = this.m_provisioningService.getServiceTypeNames("");
        Assert.assertTrue((boolean)services.contains("ICMP"));
        Assert.assertTrue((boolean)services.contains("Shochu-Stock-Level"));
        EasyMock.verify((Object[])new Object[]{pollerConfig});
    }
}

