/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.FilterFavoriteDao;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.services.FilterFavoriteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class FilterFavoriteServiceIT {
    @Autowired
    private FilterFavoriteService service;
    @Autowired
    private DatabasePopulator populator;

    @Before
    public void setUp() {
        this.populator.addExtension((DatabasePopulator.Extension)new DatabasePopulator.Extension<FilterFavoriteDao>(){

            public DatabasePopulator.DaoSupport<FilterFavoriteDao> getDaoSupport() {
                return new DatabasePopulator.DaoSupport(FilterFavoriteDao.class, (OnmsDao)FilterFavoriteServiceIT.this.service.getFilterFavoriteDao());
            }

            public void onPopulate(DatabasePopulator populator, FilterFavoriteDao dao) {
                dao.save((Object)this.createFavorite("mvr", "First Favorite 1", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.EVENT));
                dao.save((Object)this.createFavorite("mvr", "First Favorite 2", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.EVENT));
                dao.save((Object)this.createFavorite("mvr", "First Favorite 3", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.EVENT));
                dao.save((Object)this.createFavorite("mvr", "First Favorite 1", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.ALARM));
                dao.save((Object)this.createFavorite("mvr", "First Favorite 2", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.ALARM));
                dao.save((Object)this.createFavorite("mvr", "First Favorite 3", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.ALARM));
            }

            public void onShutdown(DatabasePopulator populator, FilterFavoriteDao dao) {
                for (OnmsFilterFavorite eachFavorite : dao.findAll()) {
                    dao.delete((Object)eachFavorite);
                }
            }

            private OnmsFilterFavorite createFavorite(String user, String filterName, String filterCriteria, OnmsFilterFavorite.Page page) {
                OnmsFilterFavorite favorite = new OnmsFilterFavorite();
                favorite.setName(filterName);
                favorite.setFilter(filterCriteria);
                favorite.setPage(page);
                favorite.setUsername(user);
                return favorite;
            }
        });
        this.populator.populateDatabase();
    }

    @After
    public void tearDown() {
        this.populator.resetDatabase();
    }

    @Test
    public void testGetFavorites() {
        Assert.assertTrue((!this.service.getFavorites("mvr", OnmsFilterFavorite.Page.EVENT).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!this.service.getFavorites("mvr", OnmsFilterFavorite.Page.ALARM).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.service.getFavorites("admin", OnmsFilterFavorite.Page.EVENT).isEmpty());
        Assert.assertTrue((boolean)this.service.getFavorites("admin", OnmsFilterFavorite.Page.ALARM).isEmpty());
    }

    @Test
    public void testCreateAndDeleteFavorites() throws FilterFavoriteService.FilterFavoriteException {
        List alarmFavorites = this.service.getFavorites("mvr", OnmsFilterFavorite.Page.ALARM);
        List eventFavorites = this.service.getFavorites("mvr", OnmsFilterFavorite.Page.EVENT);
        OnmsFilterFavorite favorite = FilterFavoriteServiceIT.createFavorite(this.service, "mvr", "First Favorite", "filter=severity%3D6&amp;filter=node%3D2", OnmsFilterFavorite.Page.EVENT);
        Assert.assertEquals((Object)favorite, (Object)this.service.getFavorite(favorite.getId(), "mvr"));
        List newAlarmFavorites = this.service.getFavorites("mvr", OnmsFilterFavorite.Page.ALARM);
        List newEventFavorites = this.service.getFavorites("mvr", OnmsFilterFavorite.Page.EVENT);
        Assert.assertEquals((Object)alarmFavorites, (Object)newAlarmFavorites);
        Assert.assertEquals((long)(eventFavorites.size() + 1), (long)newEventFavorites.size());
        Assert.assertTrue((boolean)newEventFavorites.contains(favorite));
        try {
            FilterFavoriteServiceIT.createFavorite(this.service, favorite.getUsername(), favorite.getName(), favorite.getFilter(), favorite.getPage());
            Assert.fail((String)"Creation should have been failed");
        }
        catch (FilterFavoriteService.FilterFavoriteException filterFavoriteException) {
            // empty catch block
        }
        Assert.assertEquals((Object)favorite, (Object)this.service.getFavorite(favorite.getId(), "mvr"));
        Assert.assertNull((Object)this.service.getFavorite(favorite.getId(), "admin"));
        Assert.assertEquals((Object)false, (Object)this.service.deleteFavorite(favorite.getId().intValue(), "admin"));
        Assert.assertNotNull((Object)this.service.getFavorite(favorite.getId(), "mvr"));
        Assert.assertEquals((Object)true, (Object)this.service.deleteFavorite(favorite.getId().intValue(), "mvr"));
        Assert.assertNull((Object)this.service.getFavorite(favorite.getId(), "mvr"));
    }

    private static OnmsFilterFavorite createFavorite(FilterFavoriteService service, String username, String filterName, String filterCriteria, OnmsFilterFavorite.Page page) throws FilterFavoriteService.FilterFavoriteException {
        OnmsFilterFavorite filterToCreate = new OnmsFilterFavorite();
        filterToCreate.setUsername(username);
        filterToCreate.setName(filterName);
        filterToCreate.setFilter(filterCriteria);
        filterToCreate.setPage(page);
        return FilterFavoriteServiceIT.createFavorite(service, filterToCreate, new AssertionCallback(){

            @Override
            public void validate(OnmsFilterFavorite favoriteToCreate, OnmsFilterFavorite createdFavorite) {
                Assert.assertNotNull((Object)favoriteToCreate);
                Assert.assertNotNull((Object)createdFavorite);
                Assert.assertEquals((Object)favoriteToCreate.getUsername(), (Object)createdFavorite.getUsername());
                Assert.assertEquals((Object)favoriteToCreate.getName(), (Object)createdFavorite.getName());
                Assert.assertEquals((Object)favoriteToCreate.getFilter(), (Object)createdFavorite.getFilter());
                Assert.assertEquals((Object)favoriteToCreate.getPage(), (Object)createdFavorite.getPage());
            }
        });
    }

    private static OnmsFilterFavorite createFavorite(FilterFavoriteService service, OnmsFilterFavorite createFavorite, AssertionCallback callback) throws FilterFavoriteService.FilterFavoriteException {
        OnmsFilterFavorite favorite = service.createFavorite(createFavorite.getUsername(), createFavorite.getName(), createFavorite.getFilter(), createFavorite.getPage());
        callback.validate(createFavorite, favorite);
        return favorite;
    }

    private static interface AssertionCallback {
        public void validate(OnmsFilterFavorite var1, OnmsFilterFavorite var2);
    }
}

