/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import javax.servlet.ServletContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

public class NegativeForeignSourceFilter
extends EqualsFilter<String> {
    public static final String TYPE = "foreignsourcenot";

    public NegativeForeignSourceFilter(String foreignSource, ServletContext servletContext) {
        super(TYPE, SQLType.STRING, "OUTAGES.NODEID", "NODE.foreignSource", foreignSource);
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " not in (SELECT DISTINCT NODE.nodeID FROM NODE WHERE NODE.foreignSource=%s)";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)" {alias}.nodeid not in (SELECT DISTINCT NODE.nodeID FROM NODE WHERE NODE.foreignSource=?)", this.getValue(), (Type)StringType.INSTANCE);
    }

    @Override
    public String toString() {
        return "<NegativeForeignSourceFilter: " + this.getDescription() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegativeForeignSourceFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

