/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.AbstractFieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringMaxLengthValidator;

public class FieldSetSuggestBox
extends AbstractFieldSet
implements FieldSet,
ValueChangeHandler<String>,
SelectionHandler<SuggestOracle.Suggestion>,
KeyUpHandler,
MouseUpHandler {
    private SuggestBox suggBox;
    private Collection<String> suggestions;
    private MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();

    public FieldSetSuggestBox(String name, String value, String helpText) {
        super(name, helpText);
        this.init(value, null, -1);
    }

    public FieldSetSuggestBox(String name, String value, String helpText, Collection<String> suggestions) {
        super(name, helpText);
        this.init(value, suggestions, -1);
    }

    @UiConstructor
    public FieldSetSuggestBox(String name, String value, String helpText, int maxLength) {
        super(name, helpText);
        this.init(value, null, maxLength);
    }

    public Collection<String> getSuggestions() {
        return this.suggestions;
    }

    @Override
    public String getValue() {
        return this.suggBox.getText();
    }

    private void init(String value, Collection<String> suggestions, int maxLength) {
        if (maxLength > 0) {
            this.addErrorValidator(new StringMaxLengthValidator(maxLength));
        }
        if (suggestions != null) {
            this.oracle.addAll(suggestions);
            this.oracle.setDefaultSuggestionsFromText(suggestions);
        }
        this.inititalValue = value;
        this.suggBox = new SuggestBox((SuggestOracle)this.oracle);
        this.suggBox.setText(value);
        this.suggBox.getValueBox().addFocusHandler((FocusHandler)this);
        this.suggBox.getValueBox().addChangeHandler((ChangeHandler)this);
        this.suggBox.getValueBox().addValueChangeHandler((ValueChangeHandler)this);
        this.suggBox.getValueBox().addMouseUpHandler((MouseUpHandler)this);
        this.suggBox.addValueChangeHandler((ValueChangeHandler)this);
        this.suggBox.addKeyUpHandler((KeyUpHandler)this);
        this.suggBox.addSelectionHandler((SelectionHandler)this);
        this.suggBox.addStyleName("form-control");
        this.panel.add((Widget)this.suggBox);
    }

    @Override
    public void onFocus(FocusEvent event) {
        this.suggBox.showSuggestionList();
    }

    public void onKeyUp(KeyUpEvent event) {
        this.checkField();
    }

    public void onMouseUp(MouseUpEvent event) {
        this.checkField();
    }

    public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
        String selected = ((SuggestOracle.Suggestion)event.getSelectedItem()).getReplacementString();
        ValueChangeEvent.fire((HasValueChangeHandlers)this.suggBox, (Object)selected);
        this.checkField();
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.checkField();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.suggBox.getValueBox().setEnabled(enabled.booleanValue());
    }

    public void setSuggestions(Collection<String> suggestions) {
        this.suggestions = suggestions;
        this.oracle.clear();
        if (suggestions != null) {
            this.oracle.addAll(suggestions);
            this.oracle.setDefaultSuggestionsFromText(suggestions);
        }
    }

    @Override
    public void setValue(String value) {
        this.suggBox.setText(value);
        this.inititalValue = value;
        this.validate(this.getValue());
    }
}

