/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.AbstractFieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;

public class FieldSetListBox
extends AbstractFieldSet
implements FieldSet {
    private ListBox listBox = new ListBox(false);
    private List<String> options;

    @UiConstructor
    public FieldSetListBox(String name, String value, String helpText) {
        super(name, helpText);
        this.init(value, null);
    }

    public FieldSetListBox(String name, String value, String helpText, List<String> options) {
        super(name, helpText);
        this.init(value, options);
    }

    @Override
    public String getValue() {
        return this.listBox.getItemText(this.listBox.getSelectedIndex());
    }

    private void init(String value, List<String> options) {
        this.inititalValue = value;
        this.options = options;
        if (options != null) {
            for (String string : options) {
                this.listBox.addItem(string);
            }
            if (options.contains(value)) {
                this.listBox.setSelectedIndex(options.indexOf(value));
            } else {
                this.listBox.addItem(value);
                this.listBox.setSelectedIndex(options.size());
            }
        }
        if (options == null) {
            this.listBox.addItem(value);
            this.listBox.setSelectedIndex(0);
        }
        this.listBox.setVisibleItemCount(1);
        this.listBox.addChangeHandler((ChangeHandler)this);
        this.listBox.addStyleName("form-control");
        this.panel.add((Widget)this.listBox);
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.listBox.setEnabled(enabled.booleanValue());
    }

    public void setOptions(List<String> options) {
        this.options = options;
        this.listBox.clear();
        for (String string : options) {
            this.listBox.addItem(string);
        }
    }

    @Override
    public void setValue(String value) {
        if (this.options.contains(value)) {
            this.listBox.setSelectedIndex(this.options.indexOf(value));
        } else {
            this.listBox.addItem(value);
            this.listBox.getItemCount();
            this.listBox.setSelectedIndex(this.listBox.getItemCount() - 1);
        }
        this.inititalValue = value;
        this.validate(this.getValue());
    }
}

