/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.NodeRtc;
import org.opennms.dashboard.client.NodeStatusView;
import org.opennms.dashboard.client.SurveillanceServiceAsync;
import org.opennms.dashboard.client.SurveillanceSet;

public class NodeStatusDashlet
extends Dashlet {
    private NodeStatusView m_view = new NodeStatusView(this);
    private NodeStatusLoader m_loader = new NodeStatusLoader();

    public NodeStatusDashlet(Dashboard dashboard) {
        super(dashboard, "Node Status");
        this.setLoader(this.m_loader);
        this.setView(this.m_view);
    }

    @Override
    public void setSurveillanceSet(SurveillanceSet set) {
        this.m_loader.load(set);
    }

    public void setSurveillanceService(SurveillanceServiceAsync svc) {
        this.m_loader.setSurveillanceService(svc);
    }

    class NodeStatusLoader
    extends DashletLoader
    implements AsyncCallback<NodeRtc[]> {
        private SurveillanceServiceAsync m_suveillanceService;

        NodeStatusLoader() {
        }

        public void load(SurveillanceSet surveillanceSet) {
            this.loading();
            this.m_suveillanceService.getRtcForSet(surveillanceSet, this);
        }

        public void onDataLoaded(NodeRtc[] rtcs) {
            try {
                NodeStatusDashlet.this.m_view.setNodeRtc(rtcs);
            }
            finally {
                this.complete();
            }
        }

        public void setSurveillanceService(SurveillanceServiceAsync svc) {
            this.m_suveillanceService = svc;
        }

        public void onFailure(Throwable caught) {
            this.loadError(caught);
            NodeStatusDashlet.this.error(caught);
        }

        public void onSuccess(NodeRtc[] result) {
            this.onDataLoaded(result);
        }
    }
}

