/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventDisplayFilter;
import org.opennms.web.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DaoWebEventRepository
implements WebEventRepository,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DaoWebEventRepository.class);
    @Autowired
    EventDao m_eventDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    private OnmsCriteria getOnmsCriteria(EventCriteria eventCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsEvent.class);
        criteria.createAlias("alarm", "alarm", 1);
        criteria.createAlias("node", "node", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        criteria.add(new EventDisplayFilter("Y").getCriterion());
        eventCriteria.visit(new EventCriteria.EventCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitAckType(AcknowledgeType ackType) throws RuntimeException {
                if (ackType == AcknowledgeType.ACKNOWLEDGED) {
                    criteria.add(Restrictions.isNotNull((String)"eventAckUser"));
                } else if (ackType == AcknowledgeType.UNACKNOWLEDGED) {
                    criteria.add(Restrictions.isNull((String)"eventAckUser"));
                }
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case ID: {
                        criteria.addOrder(Order.desc((String)"id"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"ipAddr"));
                        break;
                    }
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"node.label"));
                        break;
                    }
                    case POLLER: {
                        criteria.addOrder(Order.desc((String)"distPoller"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case SEVERITY: {
                        criteria.addOrder(Order.desc((String)"eventSeverity"));
                        break;
                    }
                    case TIME: {
                        criteria.addOrder(Order.desc((String)"eventTime"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"id"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"ipAddr"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"node.label"));
                        break;
                    }
                    case REVERSE_POLLER: {
                        criteria.addOrder(Order.asc((String)"distPoller"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case REVERSE_SEVERITY: {
                        criteria.addOrder(Order.asc((String)"eventSeverity"));
                        break;
                    }
                    case REVERSE_TIME: {
                        criteria.addOrder(Order.asc((String)"eventTime"));
                    }
                }
            }
        });
        return criteria;
    }

    private Event mapOnmsEventToEvent(OnmsEvent onmsEvent) {
        LOG.debug("Mapping OnmsEvent to WebEvent for event with database id {}", (Object)onmsEvent.getId());
        Event event = new Event();
        event.acknowledgeTime = onmsEvent.getEventAckTime();
        event.acknowledgeUser = onmsEvent.getEventAckUser();
        event.alarmId = onmsEvent.getAlarm() != null ? onmsEvent.getAlarm().getId() : 0;
        event.autoAction = onmsEvent.getEventAutoAction();
        event.createTime = onmsEvent.getEventCreateTime();
        event.description = onmsEvent.getEventDescr();
        event.dpName = onmsEvent.getDistPoller() != null ? onmsEvent.getDistPoller().getId() : "";
        event.eventDisplay = onmsEvent.getEventDisplay().equals("Y");
        event.forward = onmsEvent.getEventForward();
        event.host = onmsEvent.getEventHost();
        event.id = onmsEvent.getId();
        event.ipAddr = onmsEvent.getIpAddr() == null ? null : InetAddressUtils.toIpAddrString((InetAddress)onmsEvent.getIpAddr());
        event.logGroup = onmsEvent.getEventLogGroup();
        event.logMessage = onmsEvent.getEventLogMsg();
        event.mouseOverText = onmsEvent.getEventMouseOverText();
        event.nodeLabel = this.getNodeLabelFromNode(onmsEvent);
        LOG.debug("Found NodeLabel for mapped event:{}", (Object)event.getNodeLabel());
        event.nodeID = this.getNodeIdFromNode(onmsEvent);
        LOG.debug("Found NodeId for mapped event:{}", (Object)event.getNodeId());
        event.notification = onmsEvent.getEventNotification();
        event.operatorAction = onmsEvent.getEventOperAction();
        event.operatorActionMenuText = onmsEvent.getEventOperActionMenuText();
        event.operatorInstruction = onmsEvent.getEventOperInstruct();
        event.parms = onmsEvent.getEventParms();
        event.serviceID = onmsEvent.getServiceType() != null ? onmsEvent.getServiceType().getId() : 0;
        event.serviceName = onmsEvent.getServiceType() != null ? onmsEvent.getServiceType().getName() : "";
        event.severity = OnmsSeverity.get((int)onmsEvent.getEventSeverity());
        event.snmp = onmsEvent.getEventSnmp();
        event.snmphost = onmsEvent.getEventSnmpHost();
        event.time = onmsEvent.getEventTime();
        event.troubleTicket = onmsEvent.getEventTTicket();
        event.troubleTicketState = onmsEvent.getEventTTicketState();
        event.uei = onmsEvent.getEventUei();
        return event;
    }

    private Integer getNodeIdFromNode(OnmsEvent onmsEvent) {
        try {
            return onmsEvent.getNode() != null ? onmsEvent.getNode().getId() : 0;
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("No node found in database for event with id: {}", (Object)onmsEvent.getId());
            return 0;
        }
    }

    private String getNodeLabelFromNode(OnmsEvent onmsEvent) {
        try {
            return onmsEvent.getNode() != null ? onmsEvent.getNode().getLabel() : "";
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("No node found in database for event with id: {}", (Object)onmsEvent.getId());
            return "";
        }
    }

    @Override
    @Transactional
    public void acknowledgeAll(String user, Date timestamp) {
        this.acknowledgeMatchingEvents(user, timestamp, new EventCriteria(new Filter[0]));
    }

    @Override
    @Transactional
    public void acknowledgeMatchingEvents(String user, Date timestamp, EventCriteria criteria) {
        List events = this.m_eventDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsEvent event : events) {
            event.setEventAckUser(user);
            event.setEventAckTime(timestamp);
            this.m_eventDao.update((Object)event);
        }
    }

    @Override
    @Transactional
    public int countMatchingEvents(EventCriteria criteria) {
        return this.m_eventDao.countMatching(this.getOnmsCriteria(criteria));
    }

    @Override
    @Transactional
    public int[] countMatchingEventsBySeverity(EventCriteria criteria) {
        int[] eventCounts = new int[8];
        eventCounts[OnmsSeverity.CLEARED.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.CLEARED.getId())));
        eventCounts[OnmsSeverity.CRITICAL.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.CRITICAL.getId())));
        eventCounts[OnmsSeverity.INDETERMINATE.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.INDETERMINATE.getId())));
        eventCounts[OnmsSeverity.MAJOR.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.MAJOR.getId())));
        eventCounts[OnmsSeverity.MINOR.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.MINOR.getId())));
        eventCounts[OnmsSeverity.NORMAL.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.NORMAL.getId())));
        eventCounts[OnmsSeverity.WARNING.getId()] = this.m_eventDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"eventSeverity", (Object)OnmsSeverity.WARNING.getId())));
        return eventCounts;
    }

    @Override
    @Transactional
    public Event getEvent(int eventId) {
        return this.mapOnmsEventToEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
    }

    @Override
    @Transactional
    public Event[] getMatchingEvents(EventCriteria criteria) {
        ArrayList<Event> events = new ArrayList<Event>();
        LOG.debug("getMatchingEvents: try to get events for Criteria: {}", (Object)criteria.toString());
        List onmsEvents = this.m_eventDao.findMatching(this.getOnmsCriteria(criteria));
        LOG.debug("getMatchingEvents: found {} events", (Object)onmsEvents.size());
        if (onmsEvents.size() > 0) {
            Iterator eventIt = onmsEvents.iterator();
            while (eventIt.hasNext()) {
                events.add(this.mapOnmsEventToEvent((OnmsEvent)eventIt.next()));
            }
        }
        return events.toArray(new Event[0]);
    }

    @Override
    @Transactional
    public void unacknowledgeAll() {
        this.unacknowledgeMatchingEvents(new EventCriteria(new Filter[0]));
    }

    @Override
    @Transactional
    public void unacknowledgeMatchingEvents(EventCriteria criteria) {
        List events = this.m_eventDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsEvent event : events) {
            event.setEventAckUser(null);
            event.setEventAckTime(null);
            this.m_eventDao.update((Object)event);
        }
    }
}

