/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.criterion.Criterion;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.SQLType;

public abstract class BaseFilter<T>
implements Filter {
    protected String m_filterName;
    protected SQLType<T> m_sqlType;
    private String m_fieldName;
    private String m_propertyName;

    public BaseFilter(String filterType, SQLType<T> sqlType, String fieldName, String propertyName) {
        this.m_filterName = filterType;
        this.m_sqlType = sqlType;
        this.m_fieldName = fieldName;
        this.m_propertyName = propertyName;
    }

    public String getSQLFieldName() {
        return this.m_fieldName;
    }

    public String getPropertyName() {
        return this.m_propertyName;
    }

    @Override
    public String getDescription() {
        return this.m_filterName + "=" + this.getValueString();
    }

    public final void bindValue(PreparedStatement ps, int parameterIndex, T value) throws SQLException {
        this.m_sqlType.bindParam(ps, parameterIndex, value);
    }

    public String formatValue(T value) {
        return this.m_sqlType.formatValue(value);
    }

    public final String getValueAsString(T value) {
        return this.m_sqlType.getValueAsString(value);
    }

    public abstract String getValueString();

    @Override
    public abstract Criterion getCriterion();

    @Override
    public abstract int bindParam(PreparedStatement var1, int var2) throws SQLException;

    @Override
    public abstract String getParamSql();

    @Override
    public abstract String getSql();

    @Override
    public abstract String getTextDescription();

    public String toString() {
        return new ToStringBuilder((Object)this).append("description", (Object)this.getDescription()).append("text description", (Object)this.getTextDescription()).append("SQL field name", (Object)this.getSQLFieldName()).append("property name", (Object)this.getPropertyName()).toString();
    }
}

