/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.ChooseResourceService;
import org.opennms.web.svclayer.model.ChooseResourceModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ChooseResourceController
extends AbstractController
implements InitializingBean {
    private ChooseResourceService m_chooseResourceService;
    private String m_defaultEndUrl;
    private NodeDao m_nodeDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] requiredParameters = new String[]{"parentResourceId or", "parentResourceType and parentResource"};
        String endUrl = WebSecurityUtils.sanitizeString((String)request.getParameter("endUrl"));
        String resourceId = WebSecurityUtils.sanitizeString((String)request.getParameter("parentResourceId"));
        if (resourceId == null) {
            OnmsNode node;
            String resourceType = WebSecurityUtils.sanitizeString((String)request.getParameter("parentResourceType"));
            String resource = WebSecurityUtils.sanitizeString((String)request.getParameter("parentResource"));
            boolean isStoreByForeignSource = ResourceTypeUtils.isStoreByForeignSource();
            if (request.getParameter("parentResourceType") == null) {
                throw new MissingParameterException("parentResourceType", requiredParameters);
            }
            if (request.getParameter("parentResource") == null) {
                throw new MissingParameterException("parentResource", requiredParameters);
            }
            if (resourceType.equals("node") && isStoreByForeignSource && (node = this.m_nodeDao.get(resource)) != null && node.getForeignSource() != null && node.getForeignId() != null) {
                resourceType = "nodeSource";
                resource = node.getForeignSource() + ':' + node.getForeignId();
            }
            if (resourceType.equals("nodeSource") && !isStoreByForeignSource && (node = this.m_nodeDao.get(resource)) != null && node.getForeignSource() != null && node.getForeignId() != null) {
                resourceType = "node";
                resource = node.getId().toString();
            }
            resourceId = OnmsResource.createResourceId((String[])new String[]{resourceType, resource});
        }
        if (endUrl == null || "".equals(endUrl)) {
            endUrl = this.m_defaultEndUrl;
        }
        ChooseResourceModel model = this.m_chooseResourceService.findChildResources(resourceId, endUrl);
        return new ModelAndView("/graph/chooseresource", "model", (Object)model);
    }

    public void afterPropertiesSet() {
        if (this.m_chooseResourceService == null) {
            throw new IllegalStateException("chooseResourceService property not set");
        }
        if (this.m_defaultEndUrl == null) {
            throw new IllegalStateException("defaultEndUrl property not set");
        }
        if (this.m_nodeDao == null) {
            throw new IllegalStateException("nodeDao property not set");
        }
    }

    public ChooseResourceService getChooseResourceService() {
        return this.m_chooseResourceService;
    }

    public void setChooseResourceService(ChooseResourceService chooseResourceService) {
        this.m_chooseResourceService = chooseResourceService;
    }

    public String getDefaultEndUrl() {
        return this.m_defaultEndUrl;
    }

    public void setDefaultEndUrl(String defaultEndUrl) {
        this.m_defaultEndUrl = defaultEndUrl;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

